/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.rmi.config;

import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundGatewayParser;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class RmiOutboundGatewayParser
extends AbstractOutboundGatewayParser {
    protected String getGatewayClassName(Element element) {
        return "org.springframework.integration.rmi.RmiOutboundGateway";
    }

    protected String parseUrl(Element element, ParserContext parserContext) {
        String portAttribute;
        String host = element.getAttribute("host");
        String remoteChannel = element.getAttribute("remote-channel");
        if (!StringUtils.hasText((String)host) || !StringUtils.hasText((String)remoteChannel)) {
            parserContext.getReaderContext().error("The 'host' and 'remote-channel' attributes are both required", (Object)element);
        }
        String port = StringUtils.hasText((String)(portAttribute = element.getAttribute("port"))) ? portAttribute : "1099";
        return "rmi://" + host + ":" + port + "/" + "org.springframework.integration.rmiGateway." + remoteChannel;
    }
}

