/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.outbound;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.data.redis.support.collections.RedisCollectionFactoryBean;
import org.springframework.data.redis.support.collections.RedisList;
import org.springframework.data.redis.support.collections.RedisMap;
import org.springframework.data.redis.support.collections.RedisProperties;
import org.springframework.data.redis.support.collections.RedisSet;
import org.springframework.data.redis.support.collections.RedisStore;
import org.springframework.data.redis.support.collections.RedisZSet;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;

public class RedisStoreWritingMessageHandler
extends AbstractMessageHandler {
    private Expression zsetIncrementScoreExpression = new FunctionExpression(m -> m.getHeaders().get((Object)"redis_zsetIncrementScore"));
    private Expression keyExpression = new FunctionExpression(m -> m.getHeaders().get((Object)"redis_key"));
    private Expression mapKeyExpression = new FunctionExpression(m -> m.getHeaders().get((Object)"redis_mapKey"));
    private boolean mapKeyExpressionExplicitlySet;
    private StandardEvaluationContext evaluationContext;
    private RedisTemplate<String, ?> redisTemplate = new StringRedisTemplate();
    private RedisCollectionFactoryBean.CollectionType collectionType = RedisCollectionFactoryBean.CollectionType.LIST;
    private boolean extractPayloadElements = true;
    private final RedisConnectionFactory connectionFactory;
    private volatile boolean initialized;

    public RedisStoreWritingMessageHandler(RedisTemplate<String, ?> redisTemplate) {
        Assert.notNull(redisTemplate, (String)"'redisTemplate' must not be null");
        RedisConnectionFactory connectionFactory = redisTemplate.getConnectionFactory();
        Assert.notNull((Object)connectionFactory, (String)"'redisTemplate.connectionFactory' must not be null");
        this.redisTemplate = redisTemplate;
        this.connectionFactory = connectionFactory;
    }

    public RedisStoreWritingMessageHandler(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"'connectionFactory' must not be null");
        this.connectionFactory = connectionFactory;
    }

    public void setKey(String key) {
        Assert.hasText((String)key, (String)"key must not be empty");
        this.setKeyExpression((Expression)new LiteralExpression(key));
    }

    public void setKeyExpressionString(String keyExpression) {
        Assert.hasText((String)keyExpression, (String)"'keyExpression' must not be empty");
        this.setKeyExpression(EXPRESSION_PARSER.parseExpression(keyExpression));
    }

    public void setKeyExpression(Expression keyExpression) {
        Assert.notNull((Object)keyExpression, (String)"keyExpression must not be null");
        this.keyExpression = keyExpression;
    }

    public void setCollectionType(RedisCollectionFactoryBean.CollectionType collectionType) {
        this.collectionType = collectionType;
    }

    public void setExtractPayloadElements(boolean extractPayloadElements) {
        this.extractPayloadElements = extractPayloadElements;
    }

    public void setMapKeyExpressionString(String mapKeyExpression) {
        Assert.hasText((String)mapKeyExpression, (String)"'mapKeyExpression' must not be empty");
        this.setMapKeyExpression(EXPRESSION_PARSER.parseExpression(mapKeyExpression));
    }

    public void setMapKeyExpression(Expression mapKeyExpression) {
        Assert.notNull((Object)mapKeyExpression, (String)"'mapKeyExpression' must not be null");
        this.mapKeyExpression = mapKeyExpression;
        this.mapKeyExpressionExplicitlySet = true;
    }

    public void setZsetIncrementExpressionString(String zsetIncrementScoreExpression) {
        Assert.hasText((String)zsetIncrementScoreExpression, (String)"'zsetIncrementScoreExpression' must not be empty");
        this.setZsetIncrementExpression(EXPRESSION_PARSER.parseExpression(zsetIncrementScoreExpression));
    }

    public void setZsetIncrementExpression(Expression zsetIncrementScoreExpression) {
        Assert.notNull((Object)zsetIncrementScoreExpression, (String)"'zsetIncrementScoreExpression' must not be null");
        this.zsetIncrementScoreExpression = zsetIncrementScoreExpression;
    }

    public String getComponentType() {
        return "redis:store-outbound-channel-adapter";
    }

    protected void onInit() {
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
        Assert.state((!this.mapKeyExpressionExplicitlySet || this.collectionType == RedisCollectionFactoryBean.CollectionType.MAP || this.collectionType == RedisCollectionFactoryBean.CollectionType.PROPERTIES ? 1 : 0) != 0, (String)"'mapKeyExpression' can only be set for CollectionType.MAP or CollectionType.PROPERTIES");
        if (this.redisTemplate instanceof StringRedisTemplate) {
            if (!this.extractPayloadElements) {
                RedisTemplate template = new RedisTemplate();
                StringRedisSerializer serializer = new StringRedisSerializer();
                template.setKeySerializer((RedisSerializer)serializer);
                template.setHashKeySerializer((RedisSerializer)serializer);
                this.redisTemplate = template;
            }
            this.redisTemplate.setConnectionFactory(this.connectionFactory);
            this.redisTemplate.afterPropertiesSet();
        }
        this.initialized = true;
    }

    protected void handleMessageInternal(Message<?> message) {
        String key = (String)this.keyExpression.getValue((EvaluationContext)this.evaluationContext, message, String.class);
        Assert.hasText((String)key, () -> "Failed to determine a key for the Redis store based on the message: " + String.valueOf(message));
        RedisStore store = this.createStoreView(key);
        Assert.state((boolean)this.initialized, (String)"handler not initialized - afterPropertiesSet() must be called before the first use");
        try {
            if (this.collectionType == RedisCollectionFactoryBean.CollectionType.ZSET) {
                this.writeToZset((RedisZSet<Object>)((RedisZSet)store), message);
            } else if (this.collectionType == RedisCollectionFactoryBean.CollectionType.SET) {
                this.writeToSet((RedisSet<Object>)((RedisSet)store), message);
            } else if (this.collectionType == RedisCollectionFactoryBean.CollectionType.LIST) {
                this.writeToList((RedisList<Object>)((RedisList)store), message);
            } else if (this.collectionType == RedisCollectionFactoryBean.CollectionType.MAP) {
                this.writeToMap((RedisMap<Object, Object>)((RedisMap)store), message);
            } else if (this.collectionType == RedisCollectionFactoryBean.CollectionType.PROPERTIES) {
                this.writeToProperties((RedisProperties)store, message);
            }
        }
        catch (Exception ex) {
            throw IntegrationUtils.wrapInHandlingExceptionIfNecessary(message, () -> "Failed to store Message data into Redis collection in the [" + String.valueOf((Object)this) + "]", (Throwable)ex);
        }
    }

    private void writeToZset(RedisZSet<Object> zset, Message<?> message) {
        Object payload = message.getPayload();
        BoundZSetOperations ops = this.redisTemplate.boundZSetOps((Object)((String)zset.getKey()));
        boolean zsetIncrementHeader = this.extractZsetIncrementHeader(message);
        if (this.extractPayloadElements) {
            if (payload instanceof Map && this.verifyAllMapValuesOfTypeNumber((Map)payload)) {
                Map payloadAsMap = (Map)payload;
                this.processInPipeline(() -> {
                    for (Map.Entry entry : payloadAsMap.entrySet()) {
                        Number d = (Number)entry.getValue();
                        this.incrementOrOverwrite((BoundZSetOperations<String, Object>)ops, entry.getKey(), d == null ? Double.valueOf(this.determineScore(message)) : (Double)NumberUtils.convertNumberToTargetClass((Number)d, Double.class), zsetIncrementHeader);
                    }
                });
            } else if (payload instanceof Collection) {
                this.processInPipeline(() -> {
                    for (Object object : (Collection)payload) {
                        this.incrementOrOverwrite((BoundZSetOperations<String, Object>)ops, object, this.determineScore(message), zsetIncrementHeader);
                    }
                });
            } else {
                this.incrementOrOverwrite((BoundZSetOperations<String, Object>)ops, payload, this.determineScore(message), zsetIncrementHeader);
            }
        } else {
            this.incrementOrOverwrite((BoundZSetOperations<String, Object>)ops, payload, this.determineScore(message), zsetIncrementHeader);
        }
    }

    private boolean extractZsetIncrementHeader(Message<?> message) {
        Boolean value = (Boolean)this.zsetIncrementScoreExpression.getValue((EvaluationContext)this.evaluationContext, message, Boolean.class);
        return value != null ? value : false;
    }

    private void writeToList(RedisList<Object> list, Message<?> message) {
        Object payload = message.getPayload();
        if (this.extractPayloadElements) {
            if (payload instanceof Collection) {
                list.addAll((Collection)payload);
            } else {
                list.add(payload);
            }
        } else {
            list.add(payload);
        }
    }

    private void writeToSet(RedisSet<Object> set, Message<?> message) {
        Object payload = message.getPayload();
        if (this.extractPayloadElements && payload instanceof Collection) {
            BoundSetOperations ops = this.redisTemplate.boundSetOps((Object)((String)set.getKey()));
            this.processInPipeline(() -> {
                for (Object object : (Collection)payload) {
                    ops.add(new Object[]{object});
                }
            });
        } else {
            set.add(payload);
        }
    }

    private void writeToMap(RedisMap<Object, Object> map, Message<?> message) {
        Object payload = message.getPayload();
        if (this.extractPayloadElements && payload instanceof Map) {
            this.processInPipeline(() -> map.putAll((Map)payload));
        } else {
            Object key = this.determineMapKey(message, false);
            map.put(key, payload);
        }
    }

    private void writeToProperties(RedisProperties properties, Message<?> message) {
        Object payload = message.getPayload();
        if (this.extractPayloadElements && payload instanceof Properties) {
            this.processInPipeline(() -> properties.putAll((Map)((Properties)payload)));
        } else {
            Assert.isInstanceOf(String.class, (Object)payload, (String)"For property, payload must be a String.");
            Object key = this.determineMapKey(message, true);
            properties.put(key, payload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInPipeline(PipelineCallback callback) {
        RedisConnectionFactory connectionFactoryForPipeline = this.redisTemplate.getConnectionFactory();
        Assert.state((connectionFactoryForPipeline != null ? 1 : 0) != 0, (String)"RedisTemplate returned no connection factory");
        RedisConnection connection = RedisConnectionUtils.bindConnection((RedisConnectionFactory)connectionFactoryForPipeline);
        try {
            connection.openPipeline();
            callback.process();
        }
        finally {
            connection.closePipeline();
            RedisConnectionUtils.unbindConnection((RedisConnectionFactory)connectionFactoryForPipeline);
        }
    }

    private Object determineMapKey(Message<?> message, boolean property) {
        Object mapKey = this.mapKeyExpression.getValue((EvaluationContext)this.evaluationContext, message);
        Assert.notNull((Object)mapKey, () -> "Cannot determine a map key for the entry based on the message: " + String.valueOf(message));
        if (property) {
            Assert.isInstanceOf(String.class, (Object)mapKey, (String)"For property, key must be a String");
        }
        return mapKey;
    }

    private void incrementOrOverwrite(BoundZSetOperations<String, Object> ops, Object object, Double score, boolean zsetIncrementScore) {
        if (score != null) {
            this.doIncrementOrOverwrite(ops, object, score, zsetIncrementScore);
        } else {
            this.logger.debug((CharSequence)"Zset Score could not be determined. Using default score of 1");
            this.doIncrementOrOverwrite(ops, object, 1.0, zsetIncrementScore);
        }
    }

    private void doIncrementOrOverwrite(BoundZSetOperations<String, Object> ops, Object object, Double score, boolean increment) {
        if (increment) {
            ops.incrementScore(object, score.doubleValue());
        } else {
            ops.add(object, score.doubleValue());
        }
    }

    private boolean verifyAllMapValuesOfTypeNumber(Map<?, ?> map) {
        for (Object value : map.values()) {
            if (value instanceof Number) continue;
            this.logger.warn((CharSequence)LogMessage.format((String)"failed to extract payload elementsbecause '%s' is not of type Number", value));
            return false;
        }
        return true;
    }

    private RedisStore createStoreView(String key) {
        RedisCollectionFactoryBean fb = new RedisCollectionFactoryBean();
        fb.setKey(key);
        fb.setTemplate(this.redisTemplate);
        fb.setType(this.collectionType);
        fb.afterPropertiesSet();
        return fb.getObject();
    }

    private double determineScore(Message<?> message) {
        Object scoreHeader = message.getHeaders().get((Object)"redis_zsetScore");
        if (scoreHeader == null) {
            return 1.0;
        }
        Assert.isInstanceOf(Number.class, (Object)scoreHeader, () -> "Header redis_zsetScore must be a Number");
        Number score = (Number)scoreHeader;
        return Double.valueOf(score.toString());
    }

    private static interface PipelineCallback {
        public void process();
    }
}

