/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.outbound;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericToStringSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.redis.outbound.ArgumentsStrategy;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class RedisOutboundGateway
extends AbstractReplyProducingMessageHandler {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private static final byte[][] EMPTY_ARGS = new byte[0][];
    private final RedisTemplate<?, ?> redisTemplate;
    private EvaluationContext evaluationContext;
    private RedisSerializer<Object> argumentsSerializer = new GenericToStringSerializer(Object.class);
    private Expression commandExpression = new FunctionExpression(message -> message.getHeaders().get((Object)"redis_command"));
    private @Nullable ArgumentsStrategy argumentsStrategy = new PayloadArgumentsStrategy();

    public RedisOutboundGateway(RedisTemplate<?, ?> redisTemplate) {
        Assert.notNull(redisTemplate, (String)"'redisTemplate' must not be null");
        this.redisTemplate = redisTemplate;
    }

    public RedisOutboundGateway(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"'connectionFactory' must not be null");
        this.redisTemplate = new RedisTemplate();
        this.redisTemplate.setConnectionFactory(connectionFactory);
        this.redisTemplate.afterPropertiesSet();
    }

    public void setArgumentsSerializer(RedisSerializer<?> serializer) {
        Assert.notNull(serializer, (String)"'serializer' must not be null");
        this.argumentsSerializer = serializer;
    }

    public void setCommandExpression(Expression commandExpression) {
        this.commandExpression = commandExpression;
    }

    public void setCommandExpressionString(String commandExpression) {
        Assert.hasText((String)commandExpression, (String)"'commandExpression' must not be empty");
        this.commandExpression = EXPRESSION_PARSER.parseExpression(commandExpression);
    }

    public void setArgumentsStrategy(@Nullable ArgumentsStrategy argumentsStrategy) {
        this.argumentsStrategy = argumentsStrategy;
    }

    public String getComponentType() {
        return "redis:outbound-gateway";
    }

    protected void doInit() {
        super.doInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    protected @Nullable Object handleRequestMessage(Message<?> requestMessage) {
        Object[] arguments;
        String command = (String)this.commandExpression.getValue(this.evaluationContext, requestMessage, String.class);
        Assert.notNull((Object)command, (String)"The 'command' must not evaluate to 'null'.");
        Object args = null;
        if (this.argumentsStrategy != null && !ObjectUtils.isEmpty((Object[])(arguments = this.argumentsStrategy.resolve(command, requestMessage)))) {
            args = new byte[arguments.length][];
            for (int i = 0; i < arguments.length; ++i) {
                byte[] bytes;
                Object argument = arguments[i];
                args[i] = argument instanceof byte[] ? (bytes = (byte[])argument) : this.argumentsSerializer.serialize(argument);
            }
        }
        byte[][] actualArgs = (byte[][])(args != null ? args : EMPTY_ARGS);
        return this.redisTemplate.execute(connection -> connection.execute(command, actualArgs));
    }

    private static class PayloadArgumentsStrategy
    implements ArgumentsStrategy {
        PayloadArgumentsStrategy() {
        }

        @Override
        public Object[] resolve(String command, Message<?> message) {
            Object payload = message.getPayload();
            if (payload instanceof Object[]) {
                return (Object[])payload;
            }
            return new Object[]{payload};
        }
    }
}

