/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.integration.support.locks.DefaultLockRegistry;
import org.springframework.integration.support.locks.LockRegistry;
import org.springframework.util.Assert;

public final class RedisLockRegistry
implements LockRegistry {
    private static final Log logger;
    private static final byte[] hostName;
    private static final long DEFAULT_EXPIRE_AFTER = 60000L;
    private final String registryKey;
    private final RedisTemplate<String, RedisLock> redisTemplate;
    private final ThreadLocal<Set<RedisLock>> weakThreadLocks = new ThreadLocal();
    private final ThreadLocal<List<RedisLock>> hardThreadLocks = new ThreadLocal();
    private final long expireAfter;
    private final LockRegistry localRegistry;
    private final LockSerializer lockSerializer = new LockSerializer();
    private boolean useWeakReferences = false;

    public RedisLockRegistry(RedisConnectionFactory connectionFactory, String registryKey) {
        this(connectionFactory, registryKey, 60000L);
    }

    public RedisLockRegistry(RedisConnectionFactory connectionFactory, String registryKey, long expireAfter) {
        this(connectionFactory, registryKey, expireAfter, (LockRegistry)new DefaultLockRegistry());
    }

    public RedisLockRegistry(RedisConnectionFactory connectionFactory, String registryKey, long expireAfter, LockRegistry localRegistry) {
        Assert.notNull((Object)connectionFactory, (String)"'connectionFactory' cannot be null");
        Assert.notNull((Object)registryKey, (String)"'registryKey' cannot be null");
        Assert.notNull((Object)localRegistry, (String)"'localRegistry' cannot be null");
        this.redisTemplate = new RedisTemplate();
        this.redisTemplate.setConnectionFactory(connectionFactory);
        this.redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        this.redisTemplate.setValueSerializer((RedisSerializer)new LockSerializer());
        this.redisTemplate.afterPropertiesSet();
        this.registryKey = registryKey;
        this.expireAfter = expireAfter;
        this.localRegistry = localRegistry;
    }

    public void setUseWeakReferences(boolean useWeakReferences) {
        this.useWeakReferences = useWeakReferences;
    }

    private Collection<RedisLock> getWeakThreadLocks() {
        Set<RedisLock> locks = this.weakThreadLocks.get();
        if (locks == null) {
            locks = Collections.newSetFromMap(new WeakHashMap());
            this.weakThreadLocks.set(locks);
        }
        return locks;
    }

    private Collection<RedisLock> getHardThreadLocks() {
        List<RedisLock> locks = this.hardThreadLocks.get();
        if (locks == null) {
            locks = new LinkedList<RedisLock>();
            this.hardThreadLocks.set(locks);
        }
        return locks;
    }

    private RedisLock findLock(Collection<RedisLock> locks, Object key) {
        if (locks != null) {
            for (RedisLock lock : locks) {
                if (!lock.getLockKey().equals(key)) continue;
                return lock;
            }
        }
        return null;
    }

    private void toHardThreadStorage(RedisLock lock) {
        if (this.weakThreadLocks.get() != null) {
            this.weakThreadLocks.get().remove(lock);
        }
        this.getHardThreadLocks().add(lock);
        if (this.weakThreadLocks.get() != null && this.weakThreadLocks.get().isEmpty()) {
            this.weakThreadLocks.remove();
        }
    }

    private void toWeakThreadStorage(RedisLock lock) {
        if (this.hardThreadLocks.get() != null) {
            this.getHardThreadLocks().remove(lock);
        }
        if (this.useWeakReferences) {
            this.getWeakThreadLocks().add(lock);
        }
        if (this.hardThreadLocks.get() != null && this.hardThreadLocks.get().isEmpty()) {
            this.hardThreadLocks.remove();
        }
    }

    public Lock obtain(Object lockKey) {
        RedisLock lockInStore;
        Assert.isInstanceOf(String.class, (Object)lockKey);
        RedisLock lock = this.findLock((Collection<RedisLock>)this.hardThreadLocks.get(), lockKey);
        if (!(lock == null || lock.thread == null || (lockInStore = (RedisLock)this.redisTemplate.boundValueOps((Object)(this.registryKey + ":" + lockKey)).get()) != null && lock.equals(lockInStore))) {
            this.getHardThreadLocks().remove(lock);
            lock = null;
        }
        if (lock == null && (lock = this.findLock((Collection<RedisLock>)this.weakThreadLocks.get(), lockKey)) == null) {
            lock = new RedisLock((String)lockKey);
            if (this.useWeakReferences) {
                this.getWeakThreadLocks().add(lock);
            }
        }
        return lock;
    }

    public Collection<Lock> listLocks() {
        return (Collection)this.redisTemplate.execute((RedisCallback)new RedisCallback<Collection<Lock>>(){

            public Collection<Lock> doInRedis(RedisConnection connection) throws DataAccessException {
                Set keys = connection.keys((RedisLockRegistry.this.registryKey + ":*").getBytes());
                ArrayList<Lock> list = new ArrayList<Lock>(keys.size());
                if (keys.size() > 0) {
                    List locks = connection.mGet((byte[][])keys.toArray((T[])new byte[keys.size()][]));
                    for (byte[] lock : locks) {
                        list.add(RedisLockRegistry.this.lockSerializer.deserialize(lock));
                    }
                }
                return list;
            }
        });
    }

    static {
        String host;
        logger = LogFactory.getLog(LockRegistry.class);
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            host = "unknownHost";
        }
        hostName = host.getBytes();
    }

    private class LockSerializer
    implements RedisSerializer<RedisLock> {
        private LockSerializer() {
        }

        public byte[] serialize(RedisLock t) throws SerializationException {
            int hostLength = t.lockHost.length;
            int keyLength = t.lockKey.length();
            int threadNameLength = t.threadName.length();
            byte[] value = new byte[1 + hostLength + 1 + keyLength + 1 + threadNameLength + 8];
            ByteBuffer buff = ByteBuffer.wrap(value);
            buff.put((byte)hostLength).put(t.lockHost).put((byte)keyLength).put(t.lockKey.getBytes()).put((byte)threadNameLength).put(t.threadName.getBytes()).putLong(t.lockedAt);
            return value;
        }

        public RedisLock deserialize(byte[] bytes) throws SerializationException {
            if (bytes == null) {
                return null;
            }
            ByteBuffer buff = ByteBuffer.wrap(bytes);
            byte[] host = new byte[buff.get()];
            buff.get(host);
            byte[] lockKey = new byte[buff.get()];
            buff.get(lockKey);
            byte[] threadName = new byte[buff.get()];
            buff.get(threadName);
            long lockedAt = buff.getLong();
            RedisLock lock = new RedisLock(new String(lockKey));
            lock.lockedAt = lockedAt;
            RedisLock.access$1402(lock, host);
            lock.threadName = new String(threadName);
            return lock;
        }
    }

    private class RedisLock
    implements Lock {
        private final String lockKey;
        private long lockedAt;
        private Thread thread;
        private String threadName;
        private byte[] lockHost;
        private int reLock;

        private RedisLock(String lockKey) {
            this.lockKey = lockKey;
            this.lockHost = hostName;
        }

        private String getLockKey() {
            return this.lockKey;
        }

        @Override
        public void lock() {
            Lock localLock = RedisLockRegistry.this.localRegistry.obtain((Object)this.lockKey);
            localLock.lock();
            try {
                while (true) {
                    try {
                        while (!this.obtainLock()) {
                            Thread.sleep(100L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                localLock.unlock();
                throw new RuntimeException(e);
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            Lock localLock = RedisLockRegistry.this.localRegistry.obtain((Object)this.lockKey);
            localLock.lockInterruptibly();
            try {
                while (!this.obtainLock()) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException ie) {
                localLock.unlock();
                throw ie;
            }
            catch (Exception e) {
                localLock.unlock();
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean tryLock() {
            Lock localLock = RedisLockRegistry.this.localRegistry.obtain((Object)this.lockKey);
            try {
                if (!localLock.tryLock()) {
                    return false;
                }
                boolean obtainedLock = this.obtainLock();
                if (!obtainedLock) {
                    localLock.unlock();
                }
                return obtainedLock;
            }
            catch (Exception e) {
                localLock.unlock();
                throw new RuntimeException(e);
            }
        }

        private boolean obtainLock() {
            Thread currentThread = Thread.currentThread();
            if (currentThread.equals(this.thread)) {
                ++this.reLock;
                return true;
            }
            RedisLockRegistry.this.toHardThreadStorage(this);
            this.lockedAt = System.currentTimeMillis();
            this.threadName = currentThread.getName();
            Boolean success = false;
            try {
                success = (Boolean)RedisLockRegistry.this.redisTemplate.execute((SessionCallback)new SessionCallback<Boolean>(){

                    public Boolean execute(RedisOperations ops) throws DataAccessException {
                        String key = RedisLock.this.constructLockKey();
                        ops.watch((Object)key);
                        if (ops.opsForValue().get((Object)key) != null) {
                            ops.unwatch();
                            return false;
                        }
                        ops.multi();
                        ops.opsForValue().set((Object)key, (Object)RedisLock.this, RedisLockRegistry.this.expireAfter, TimeUnit.MILLISECONDS);
                        return ops.exec() != null;
                    }
                });
            }
            finally {
                if (!success.booleanValue()) {
                    this.lockedAt = 0L;
                    this.threadName = null;
                    RedisLockRegistry.this.toWeakThreadStorage(this);
                } else {
                    this.thread = currentThread;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("New lock; " + this.toString()));
                    }
                }
            }
            return success;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            Lock localLock = RedisLockRegistry.this.localRegistry.obtain((Object)this.lockKey);
            if (!localLock.tryLock(time, unit)) {
                return false;
            }
            try {
                long expire = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(time, unit);
                boolean acquired = false;
                while (!(acquired = this.obtainLock()) && System.currentTimeMillis() < expire) {
                    Thread.sleep(100L);
                }
                if (!acquired) {
                    localLock.unlock();
                }
                return acquired;
            }
            catch (Exception e) {
                localLock.unlock();
                throw new RuntimeException(e);
            }
        }

        @Override
        public void unlock() {
            block9: {
                if (!Thread.currentThread().equals(this.thread)) {
                    if (this.thread == null) {
                        throw new IllegalStateException("Lock is not locked; " + this.toString());
                    }
                    throw new IllegalStateException("Lock is owned by " + this.thread.getName() + "; " + this.toString());
                }
                try {
                    if (this.reLock-- > 0) break block9;
                    try {
                        this.assertLockInRedisIsUnchanged();
                        RedisLockRegistry.this.redisTemplate.delete((Object)this.constructLockKey());
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Released lock; " + this.toString()));
                        }
                    }
                    finally {
                        this.thread = null;
                        this.reLock = 0;
                        RedisLockRegistry.this.toWeakThreadStorage(this);
                    }
                }
                finally {
                    Lock localLock = RedisLockRegistry.this.localRegistry.obtain((Object)this.lockKey);
                    localLock.unlock();
                }
            }
        }

        private void assertLockInRedisIsUnchanged() {
            RedisLock lockInStore = (RedisLock)RedisLockRegistry.this.redisTemplate.boundValueOps((Object)this.constructLockKey()).get();
            if (lockInStore == null || !this.equals(lockInStore)) {
                throw new IllegalStateException("Lock was released due to expiration; " + this.toString() + (lockInStore == null ? "" : "; lock in store: " + lockInStore.toString()));
            }
        }

        private String constructLockKey() {
            return RedisLockRegistry.this.registryKey + ":" + this.lockKey;
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException("Conditions are not supported");
        }

        public String toString() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("YYYY-MM-dd@HH:mm:ss.SSS");
            return "RedisLock [lockKey=" + this.constructLockKey() + ",lockedAt=" + dateFormat.format(new Date(this.lockedAt)) + ", thread=" + this.threadName + ", lockHost=" + new String(this.lockHost) + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + Arrays.hashCode(this.lockHost);
            result = 31 * result + (this.lockKey == null ? 0 : this.lockKey.hashCode());
            result = 31 * result + (int)(this.lockedAt ^ this.lockedAt >>> 32);
            result = 31 * result + (this.threadName == null ? 0 : this.threadName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RedisLock other = (RedisLock)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (!Arrays.equals(this.lockHost, other.lockHost)) {
                return false;
            }
            if (!this.lockKey.equals(other.lockKey)) {
                return false;
            }
            if (this.lockedAt != other.lockedAt) {
                return false;
            }
            return !(this.threadName == null ? other.threadName != null : !this.threadName.equals(other.threadName));
        }

        private RedisLockRegistry getOuterType() {
            return RedisLockRegistry.this;
        }

        static /* synthetic */ byte[] access$1402(RedisLock x0, byte[] x1) {
            x0.lockHost = x1;
            return x1;
        }
    }
}

