/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mqtt.support;

import java.lang.reflect.Method;
import java.util.Objects;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.mqttv5.client.IMqttAsyncClient;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.integration.JavaUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public final class MqttUtils {
    private static final boolean PAHO_MQTTV3_PRESENT = ClassUtils.isPresent((String)"org.eclipse.paho.client.mqttv3.MqttAsyncClient", null);
    private static final boolean PAHO_MQTTV5_PRESENT = ClassUtils.isPresent((String)"org.eclipse.paho.mqttv5.client.MqttAsyncClient", null);
    private static final @Nullable Method V3_STOP_RECONNECT_CYCLE_METHOD;
    private static final @Nullable Method V5_STOP_RECONNECT_CYCLE_METHOD;

    private MqttUtils() {
    }

    public static MqttConnectOptions cloneConnectOptions(MqttConnectOptions options) {
        MqttConnectOptions options2 = new MqttConnectOptions();
        BeanUtils.copyProperties((Object)options, (Object)options2, (String[])new String[]{"password", "serverURIs"});
        if (options.getPassword() != null) {
            options2.setPassword(options.getPassword());
        }
        return options2;
    }

    public static void stopClientReconnectCycle(org.eclipse.paho.client.mqttv3.IMqttAsyncClient client) {
        ReflectionUtils.invokeMethod((Method)Objects.requireNonNull(V3_STOP_RECONNECT_CYCLE_METHOD), (Object)client);
    }

    public static void stopClientReconnectCycle(IMqttAsyncClient client) {
        ReflectionUtils.invokeMethod((Method)Objects.requireNonNull(V5_STOP_RECONNECT_CYCLE_METHOD), (Object)client);
    }

    static {
        if (PAHO_MQTTV3_PRESENT) {
            V3_STOP_RECONNECT_CYCLE_METHOD = ReflectionUtils.findMethod(MqttAsyncClient.class, (String)"stopReconnectCycle");
            JavaUtils.INSTANCE.acceptIfNotNull((Object)V3_STOP_RECONNECT_CYCLE_METHOD, ReflectionUtils::makeAccessible);
        } else {
            V3_STOP_RECONNECT_CYCLE_METHOD = null;
        }
        if (PAHO_MQTTV5_PRESENT) {
            V5_STOP_RECONNECT_CYCLE_METHOD = ReflectionUtils.findMethod(org.eclipse.paho.mqttv5.client.MqttAsyncClient.class, (String)"stopReconnectCycle");
            JavaUtils.INSTANCE.acceptIfNotNull((Object)V5_STOP_RECONNECT_CYCLE_METHOD, ReflectionUtils::makeAccessible);
        } else {
            V5_STOP_RECONNECT_CYCLE_METHOD = null;
        }
    }
}

