/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mqtt.support;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.mapping.BytesMessageMapper;
import org.springframework.integration.mqtt.support.MqttMessageConverter;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.util.Assert;

public class DefaultPahoMessageConverter
implements MqttMessageConverter,
BeanFactoryAware {
    private final Charset charset;
    private final int defaultQos;
    private final MessageProcessor<Integer> qosProcessor;
    private final boolean defaultRetained;
    private final MessageProcessor<Boolean> retainedProcessor;
    private @Nullable BytesMessageMapper bytesMessageMapper;
    private boolean payloadAsBytes = false;
    private BeanFactory beanFactory;
    private volatile MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();
    private volatile boolean messageBuilderFactorySet;

    public DefaultPahoMessageConverter() {
        this(0, false);
    }

    public DefaultPahoMessageConverter(int defaultQos, boolean defaultRetained) {
        this(defaultQos, defaultRetained, StandardCharsets.UTF_8.name());
    }

    public DefaultPahoMessageConverter(String charset) {
        this(0, false, charset);
    }

    public DefaultPahoMessageConverter(int defaultQos, boolean defaultRetained, String charset) {
        this(defaultQos, MqttMessageConverter.defaultQosProcessor(), defaultRetained, MqttMessageConverter.defaultRetainedProcessor(), charset);
    }

    public DefaultPahoMessageConverter(int defaultQos, MessageProcessor<Integer> qosProcessor, boolean defaultRetained, MessageProcessor<Boolean> retainedProcessor) {
        this(defaultQos, qosProcessor, defaultRetained, retainedProcessor, StandardCharsets.UTF_8.name());
    }

    public DefaultPahoMessageConverter(int defaultQos, MessageProcessor<Integer> qosProcessor, boolean defaultRetained, MessageProcessor<Boolean> retainedProcessor, String charset) {
        Assert.notNull(qosProcessor, (String)"'qosProcessor' cannot be null");
        Assert.notNull(retainedProcessor, (String)"'retainedProcessor' cannot be null");
        this.defaultQos = defaultQos;
        this.qosProcessor = qosProcessor;
        this.defaultRetained = defaultRetained;
        this.retainedProcessor = retainedProcessor;
        this.charset = Charset.forName(charset);
    }

    public final void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected MessageBuilderFactory getMessageBuilderFactory() {
        if (!this.messageBuilderFactorySet) {
            this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory((BeanFactory)this.beanFactory);
            this.messageBuilderFactorySet = true;
        }
        return this.messageBuilderFactory;
    }

    public void setPayloadAsBytes(boolean payloadAsBytes) {
        this.payloadAsBytes = payloadAsBytes;
    }

    public boolean isPayloadAsBytes() {
        return this.payloadAsBytes;
    }

    public void setBytesMessageMapper(BytesMessageMapper bytesMessageMapper) {
        this.bytesMessageMapper = bytesMessageMapper;
    }

    public @Nullable Message<?> toMessage(Object mqttMessage, @Nullable MessageHeaders headers) {
        Assert.isInstanceOf(MqttMessage.class, (Object)mqttMessage, () -> "This converter can only convert an 'MqttMessage'; received: " + mqttMessage.getClass().getName());
        return this.toMessage(null, (MqttMessage)mqttMessage);
    }

    @Override
    public AbstractIntegrationMessageBuilder<?> toMessageBuilder(@Nullable String topic, MqttMessage mqttMessage) {
        try {
            AbstractIntegrationMessageBuilder messageBuilder = this.bytesMessageMapper != null ? this.getMessageBuilderFactory().fromMessage(this.bytesMessageMapper.toMessage(mqttMessage.getPayload())) : this.getMessageBuilderFactory().withPayload(this.mqttBytesToPayload(mqttMessage));
            messageBuilder.setHeader("mqtt_id", (Object)mqttMessage.getId()).setHeader("mqtt_receivedQos", (Object)mqttMessage.getQos()).setHeader("mqtt_duplicate", (Object)mqttMessage.isDuplicate()).setHeader("mqtt_receivedRetained", (Object)mqttMessage.isRetained());
            if (topic != null) {
                messageBuilder.setHeader("mqtt_receivedTopic", (Object)topic);
            }
            return messageBuilder;
        }
        catch (Exception e) {
            throw new MessageConversionException("failed to convert object to Message", (Throwable)e);
        }
    }

    public MqttMessage fromMessage(Message<?> message, Class<?> targetClass) {
        byte[] payloadBytes = this.messageToMqttBytes(message);
        MqttMessage mqttMessage = new MqttMessage(payloadBytes);
        Integer qos = (Integer)this.qosProcessor.processMessage(message);
        mqttMessage.setQos(qos == null ? this.defaultQos : qos);
        Boolean retained = (Boolean)this.retainedProcessor.processMessage(message);
        mqttMessage.setRetained(retained == null ? this.defaultRetained : retained);
        return mqttMessage;
    }

    protected Object mqttBytesToPayload(MqttMessage mqttMessage) {
        if (this.payloadAsBytes) {
            return mqttMessage.getPayload();
        }
        return new String(mqttMessage.getPayload(), this.charset);
    }

    protected byte[] messageToMqttBytes(Message<?> message) {
        if (this.bytesMessageMapper != null) {
            try {
                return this.bytesMessageMapper.fromMessage(message);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to map outbound message", e);
            }
        }
        Object payload = message.getPayload();
        Assert.isTrue((payload instanceof byte[] || payload instanceof String ? 1 : 0) != 0, () -> "This default converter can only handle 'byte[]' or 'String' payloads; consider adding a transformer to your flow definition, or provide a BytesMessageMapper, or subclass this converter for " + payload.getClass().getName() + " payloads");
        byte[] payloadBytes = payload instanceof String ? ((String)payload).getBytes(this.charset) : (byte[])payload;
        return payloadBytes;
    }
}

