/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mqtt.support;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.eclipse.paho.mqttv5.common.packet.UserProperty;
import org.springframework.core.log.LogAccessor;
import org.springframework.core.log.LogMessage;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.PatternMatchUtils;

public class MqttHeaderMapper
implements HeaderMapper<MqttProperties> {
    private static final LogAccessor LOGGER = new LogAccessor(MqttHeaderMapper.class);
    private String[] inboundHeaderNames = new String[]{"*"};
    private String[] outboundHeaderNames = new String[]{"contentType", "mqtt_messageExpiryInterval", "mqtt_responseTopic", "mqtt_correlationData"};

    public void setInboundHeaderNames(String ... inboundHeaderNames) {
        Assert.notNull((Object)inboundHeaderNames, (String)"'inboundHeaderNames' must not be null");
        Object[] copy = Arrays.copyOf(inboundHeaderNames, inboundHeaderNames.length);
        Arrays.sort(copy);
        this.inboundHeaderNames = copy;
    }

    public void setOutboundHeaderNames(String ... outboundHeaderNames) {
        Assert.notNull((Object)outboundHeaderNames, (String)"'outboundHeaderNames' must not be null");
        Object[] copy = Arrays.copyOf(outboundHeaderNames, outboundHeaderNames.length);
        Arrays.sort(copy);
        this.outboundHeaderNames = copy;
    }

    public void fromHeaders(MessageHeaders headers, MqttProperties target) {
        for (Map.Entry entry : headers.entrySet()) {
            Object value;
            String name = (String)entry.getKey();
            if (!MqttHeaderMapper.shouldMapHeader(name, this.outboundHeaderNames) || (value = entry.getValue()) == null) continue;
            MqttHeaderMapper.setMqttHeader(target, name, value);
        }
    }

    public Map<String, Object> toHeaders(MqttProperties source) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        if (source.getPayloadFormat()) {
            headers.compute("contentType", (k, v) -> this.mapPropertyIfMatch((String)k, source.getContentType()));
        }
        headers.compute("mqtt_topicAlias", (k, v) -> this.mapPropertyIfMatch((String)k, source.getTopicAlias()));
        headers.compute("mqtt_responseTopic", (k, v) -> this.mapPropertyIfMatch((String)k, source.getResponseTopic()));
        headers.compute("mqtt_correlationData", (k, v) -> this.mapPropertyIfMatch((String)k, source.getCorrelationData()));
        List userProperties = source.getUserProperties();
        for (UserProperty userProperty : userProperties) {
            String name = userProperty.getKey();
            if (!MqttHeaderMapper.shouldMapHeader(name, this.inboundHeaderNames)) continue;
            headers.put(name, userProperty.getValue());
        }
        return headers;
    }

    private Object mapPropertyIfMatch(String headerName, @Nullable Object value) {
        return value != null && MqttHeaderMapper.shouldMapHeader(headerName, this.inboundHeaderNames) ? value : null;
    }

    private static boolean shouldMapHeader(String headerName, String[] patterns) {
        if (patterns != null && patterns.length > 0) {
            for (String pattern : patterns) {
                if (!PatternMatchUtils.simpleMatch((String)pattern, (String)headerName)) continue;
                LOGGER.debug((CharSequence)LogMessage.format((String)"headerName=[{0}] WILL be mapped, matched pattern={1}", (Object)headerName, (Object)pattern));
                return true;
            }
        }
        LOGGER.debug((CharSequence)LogMessage.format((String)"headerName=[{0}] WILL NOT be mapped", (Object)headerName));
        return false;
    }

    private static void setMqttHeader(MqttProperties target, String name, Object value) {
        switch (name) {
            case "contentType": {
                MqttHeaderMapper.setContentType(target, value);
                target.setPayloadFormat(true);
                break;
            }
            case "mqtt_messageExpiryInterval": {
                MqttHeaderMapper.setMessageExpiryInterval(target, value);
                break;
            }
            case "mqtt_responseTopic": {
                MqttHeaderMapper.setResponseTopic(target, value);
                break;
            }
            case "mqtt_correlationData": {
                MqttHeaderMapper.setCorrelationData(target, value);
                break;
            }
            default: {
                if (value instanceof String) {
                    target.getUserProperties().add(new UserProperty(name, (String)value));
                    break;
                }
                if (value == null) break;
                throw new IllegalArgumentException("Expected String value for MQTT user properties, but received: " + value.getClass());
            }
        }
    }

    private static void setContentType(MqttProperties target, Object value) {
        if (value instanceof MimeType) {
            target.setContentType(((MimeType)value).toString());
        } else if (value instanceof String) {
            target.setContentType((String)value);
        } else {
            throw new IllegalArgumentException("Expected MediaType or String value for 'content-type' header value, but received: " + value.getClass());
        }
    }

    private static void setMessageExpiryInterval(MqttProperties target, Object value) {
        if (value instanceof Long) {
            target.setMessageExpiryInterval((Long)value);
        } else if (value instanceof String) {
            target.setMessageExpiryInterval(Long.valueOf(Long.parseLong((String)value)));
        } else {
            throw new IllegalArgumentException("Expected Long or String value for 'mqtt_messageExpiryInterval' header value, but received: " + value.getClass());
        }
    }

    private static void setResponseTopic(MqttProperties target, Object value) {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Expected String value for 'mqtt_responseTopic' header value, but received: " + value.getClass());
        }
        target.setResponseTopic((String)value);
    }

    private static void setCorrelationData(MqttProperties target, Object value) {
        if (value instanceof byte[]) {
            target.setCorrelationData((byte[])value);
        } else if (value instanceof String) {
            target.setCorrelationData(((String)value).getBytes(StandardCharsets.UTF_8));
        } else {
            throw new IllegalArgumentException("Expected byte[] or String value for 'mqtt_correlationData' header value, but received: " + value.getClass());
        }
    }
}

