/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mqtt.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.integration.mqtt.core.ClientManager;
import org.springframework.util.Assert;

public abstract class AbstractMqttClientManager<T, C>
implements ClientManager<T, C>,
ApplicationEventPublisherAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final int DEFAULT_MANAGER_PHASE = 0;
    private final Set<ClientManager.ConnectCallback> connectCallbacks = Collections.synchronizedSet(new HashSet());
    private final String clientId;
    private int phase = 0;
    private long completionTimeout = 30000L;
    private long disconnectCompletionTimeout = 5000L;
    private boolean manualAcks;
    private ApplicationEventPublisher applicationEventPublisher;
    private String url;
    private String beanName;
    private T client;

    protected AbstractMqttClientManager(String clientId) {
        Assert.notNull((Object)clientId, (String)"'clientId' is required");
        this.clientId = clientId;
    }

    public void setManualAcks(boolean manualAcks) {
        this.manualAcks = manualAcks;
    }

    protected String getUrl() {
        return this.url;
    }

    protected void setUrl(String url) {
        this.url = url;
    }

    protected String getClientId() {
        return this.clientId;
    }

    protected ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    protected synchronized void setClient(T client) {
        this.client = client;
    }

    protected Set<ClientManager.ConnectCallback> getCallbacks() {
        return this.connectCallbacks;
    }

    public void setCompletionTimeout(long completionTimeout) {
        this.completionTimeout = completionTimeout;
    }

    protected long getCompletionTimeout() {
        return this.completionTimeout;
    }

    public void setDisconnectCompletionTimeout(long completionTimeout) {
        this.disconnectCompletionTimeout = completionTimeout;
    }

    protected long getDisconnectCompletionTimeout() {
        return this.disconnectCompletionTimeout;
    }

    @Override
    public boolean isManualAcks() {
        return this.manualAcks;
    }

    @Override
    public synchronized T getClient() {
        return this.client;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        Assert.notNull((Object)applicationEventPublisher, (String)"'applicationEventPublisher' cannot be null");
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    public int getPhase() {
        return this.phase;
    }

    @Override
    public void addCallback(ClientManager.ConnectCallback connectCallback) {
        this.connectCallbacks.add(connectCallback);
    }

    @Override
    public boolean removeCallback(ClientManager.ConnectCallback connectCallback) {
        return this.connectCallbacks.remove(connectCallback);
    }

    public synchronized boolean isRunning() {
        return this.client != null;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }
}

