/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mqtt.outbound;

import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.Lifecycle;
import org.springframework.expression.Expression;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.mqtt.support.DefaultPahoMessageConverter;
import org.springframework.integration.mqtt.support.MqttMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;

public abstract class AbstractMqttMessageHandler
extends AbstractMessageHandler
implements Lifecycle {
    private static final MessageProcessor<String> DEFAULT_TOPIC_PROCESSOR = message -> (String)message.getHeaders().get((Object)"mqtt_topic", String.class);
    private final AtomicBoolean running = new AtomicBoolean();
    private final String url;
    private final String clientId;
    private String defaultTopic;
    private MessageProcessor<String> topicProcessor = DEFAULT_TOPIC_PROCESSOR;
    private int defaultQos = 0;
    private MessageProcessor<Integer> qosProcessor = MqttMessageConverter.defaultQosProcessor();
    private boolean defaultRetained;
    private MessageProcessor<Boolean> retainedProcessor = MqttMessageConverter.defaultRetainedProcessor();
    private MessageConverter converter;
    private int clientInstance;

    public AbstractMqttMessageHandler(String url, String clientId) {
        Assert.hasText((String)clientId, (String)"'clientId' cannot be null or empty");
        this.url = url;
        this.clientId = clientId;
    }

    public void setDefaultTopic(String defaultTopic) {
        this.defaultTopic = defaultTopic;
    }

    public void setTopicExpression(Expression topicExpression) {
        Assert.notNull((Object)topicExpression, (String)"'topicExpression' cannot be null");
        this.topicProcessor = new ExpressionEvaluatingMessageProcessor(topicExpression);
    }

    public void setTopicExpressionString(String topicExpression) {
        Assert.hasText((String)topicExpression, (String)"'topicExpression' must not be null or empty");
        this.topicProcessor = new ExpressionEvaluatingMessageProcessor(topicExpression);
    }

    public void setDefaultQos(int defaultQos) {
        this.defaultQos = defaultQos;
    }

    public void setQosExpression(Expression qosExpression) {
        Assert.notNull((Object)qosExpression, (String)"'qosExpression' cannot be null");
        this.qosProcessor = new ExpressionEvaluatingMessageProcessor(qosExpression);
    }

    public void setQosExpressionString(String qosExpression) {
        Assert.hasText((String)qosExpression, (String)"'qosExpression' must not be null or empty");
        this.qosProcessor = new ExpressionEvaluatingMessageProcessor(qosExpression);
    }

    public void setDefaultRetained(boolean defaultRetained) {
        this.defaultRetained = defaultRetained;
    }

    public void setRetainedExpression(Expression retainedExpression) {
        Assert.notNull((Object)retainedExpression, (String)"'qosExpression' cannot be null");
        this.retainedProcessor = new ExpressionEvaluatingMessageProcessor(retainedExpression);
    }

    public void setRetainedExpressionString(String retainedExpression) {
        Assert.hasText((String)retainedExpression, (String)"'qosExpression' must not be null or empty");
        this.retainedProcessor = new ExpressionEvaluatingMessageProcessor(retainedExpression);
    }

    public void setConverter(MessageConverter converter) {
        Assert.notNull((Object)converter, (String)"'converter' cannot be null");
        this.converter = converter;
    }

    protected MessageConverter getConverter() {
        return this.converter;
    }

    protected String getUrl() {
        return this.url;
    }

    public String getClientId() {
        return this.clientId;
    }

    public int getClientInstance() {
        return this.clientInstance;
    }

    public String getComponentType() {
        return "mqtt:outbound-channel-adapter";
    }

    protected void incrementClientInstance() {
        ++this.clientInstance;
    }

    protected void onInit() {
        super.onInit();
        if (this.topicProcessor instanceof BeanFactoryAware && this.getBeanFactory() != null) {
            ((BeanFactoryAware)this.topicProcessor).setBeanFactory(this.getBeanFactory());
        }
        if (this.qosProcessor instanceof BeanFactoryAware && this.getBeanFactory() != null) {
            ((BeanFactoryAware)this.qosProcessor).setBeanFactory(this.getBeanFactory());
        }
        if (this.retainedProcessor instanceof BeanFactoryAware && this.getBeanFactory() != null) {
            ((BeanFactoryAware)this.retainedProcessor).setBeanFactory(this.getBeanFactory());
        }
        if (this.converter == null) {
            DefaultPahoMessageConverter defaultConverter = new DefaultPahoMessageConverter(this.defaultQos, this.qosProcessor, this.defaultRetained, this.retainedProcessor);
            if (this.getBeanFactory() != null) {
                defaultConverter.setBeanFactory(this.getBeanFactory());
            }
            this.converter = defaultConverter;
        }
    }

    public final void start() {
        if (!this.running.getAndSet(true)) {
            this.doStart();
        }
    }

    protected abstract void doStart();

    public final void stop() {
        if (this.running.getAndSet(false)) {
            this.doStop();
        }
    }

    protected abstract void doStop();

    public boolean isRunning() {
        return this.running.get();
    }

    protected void handleMessageInternal(Message<?> message) {
        Object mqttMessage = this.converter.fromMessage(message, Object.class);
        String topic = (String)this.topicProcessor.processMessage(message);
        if (topic == null && this.defaultTopic == null) {
            throw new IllegalStateException("No topic could be determined from the message and no default topic defined");
        }
        this.publish(topic == null ? this.defaultTopic : topic, mqttMessage, message);
    }

    protected abstract void publish(String var1, Object var2, Message<?> var3);
}

