/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mqtt.core;

import java.util.Arrays;
import java.util.Properties;
import javax.net.SocketFactory;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttClient;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.springframework.integration.mqtt.core.ConsumerStopAction;
import org.springframework.integration.mqtt.core.MqttPahoClientFactory;
import org.springframework.util.Assert;

public class DefaultMqttPahoClientFactory
implements MqttPahoClientFactory {
    private MqttConnectOptions options = new MqttConnectOptions();
    private MqttClientPersistence persistence;
    private ConsumerStopAction consumerStopAction = ConsumerStopAction.UNSUBSCRIBE_CLEAN;

    @Deprecated
    public void setCleanSession(Boolean cleanSession) {
        this.options.setCleanSession(cleanSession.booleanValue());
    }

    @Deprecated
    public void setConnectionTimeout(Integer connectionTimeout) {
        this.options.setConnectionTimeout(connectionTimeout.intValue());
    }

    @Deprecated
    public void setKeepAliveInterval(Integer keepAliveInterval) {
        this.options.setKeepAliveInterval(keepAliveInterval.intValue());
    }

    @Deprecated
    public void setPassword(String password) {
        this.options.setPassword(password.toCharArray());
    }

    @Deprecated
    public void setSocketFactory(SocketFactory socketFactory) {
        this.options.setSocketFactory(socketFactory);
    }

    @Deprecated
    public void setSslProperties(Properties sslProperties) {
        this.options.setSSLProperties(sslProperties);
    }

    @Deprecated
    public void setUserName(String userName) {
        this.options.setUserName(userName);
    }

    @Deprecated
    public void setWill(Will will) {
        this.options.setWill(will.getTopic(), will.getPayload(), will.getQos(), will.isRetained());
    }

    public void setPersistence(MqttClientPersistence persistence) {
        this.persistence = persistence;
    }

    @Deprecated
    public void setServerURIs(String ... serverURIs) {
        Assert.notNull((Object)serverURIs, (String)"'serverURIs' must not be null.");
        this.options.setServerURIs(Arrays.copyOf(serverURIs, serverURIs.length));
    }

    @Override
    public ConsumerStopAction getConsumerStopAction() {
        return this.consumerStopAction;
    }

    public void setConsumerStopAction(ConsumerStopAction consumerStopAction) {
        this.consumerStopAction = consumerStopAction;
    }

    @Override
    public IMqttClient getClientInstance(String uri, String clientId) throws MqttException {
        return new MqttClient(uri == null ? "tcp://NO_URL_PROVIDED" : uri, clientId, this.persistence);
    }

    @Override
    public IMqttAsyncClient getAsyncClientInstance(String uri, String clientId) throws MqttException {
        return new MqttAsyncClient(uri == null ? "tcp://NO_URL_PROVIDED" : uri, clientId, this.persistence);
    }

    public void setConnectionOptions(MqttConnectOptions options) {
        Assert.notNull((Object)options, (String)"MqttConnectOptions cannot be null");
        this.options = options;
    }

    @Override
    public MqttConnectOptions getConnectionOptions() {
        return this.options;
    }

    public static class Will {
        private final String topic;
        private final byte[] payload;
        private final int qos;
        private final boolean retained;

        public Will(String topic, byte[] payload, int qos, boolean retained) {
            this.topic = topic;
            this.payload = payload;
            this.qos = qos;
            this.retained = retained;
        }

        protected String getTopic() {
            return this.topic;
        }

        protected byte[] getPayload() {
            return this.payload;
        }

        protected int getQos() {
            return this.qos;
        }

        protected boolean isRetained() {
            return this.retained;
        }
    }
}

