/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.inbound;

import com.mongodb.DBObject;
import java.util.Collection;
import java.util.Map;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.BasicUpdate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.util.Pair;
import org.springframework.expression.Expression;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public abstract class AbstractMongoDbMessageSource<T>
extends AbstractMessageSource<T>
implements ApplicationContextAware {
    private static final String ID_FIELD = "_id";
    protected final Expression queryExpression;
    private Expression collectionNameExpression = new LiteralExpression("data");
    private MongoConverter mongoConverter;
    private Class<?> entityClass = DBObject.class;
    private boolean expectSingleResult = false;
    private @Nullable Expression updateExpression;
    private ApplicationContext applicationContext;
    private volatile boolean initialized = false;

    protected AbstractMongoDbMessageSource(Expression queryExpression) {
        Assert.notNull((Object)queryExpression, (String)"'queryExpression' must not be null");
        this.queryExpression = queryExpression;
    }

    public void setEntityClass(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"'entityClass' must not be null");
        this.entityClass = entityClass;
    }

    public void setExpectSingleResult(boolean expectSingleResult) {
        this.expectSingleResult = expectSingleResult;
    }

    public void setCollectionNameExpression(Expression collectionNameExpression) {
        Assert.notNull((Object)collectionNameExpression, (String)"'collectionNameExpression' must not be null");
        this.collectionNameExpression = collectionNameExpression;
    }

    public void setMongoConverter(MongoConverter mongoConverter) {
        this.mongoConverter = mongoConverter;
    }

    public void setUpdateExpression(Expression updateExpression) {
        this.updateExpression = updateExpression;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Expression getCollectionNameExpression() {
        return this.collectionNameExpression;
    }

    public MongoConverter getMongoConverter() {
        return this.mongoConverter;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public boolean isExpectSingleResult() {
        return this.expectSingleResult;
    }

    public @Nullable Expression getUpdateExpression() {
        return this.updateExpression;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected void onInit() {
        super.onInit();
        TypeLocator typeLocator = this.getEvaluationContext().getTypeLocator();
        if (typeLocator instanceof StandardTypeLocator) {
            StandardTypeLocator standardTypeLocator = (StandardTypeLocator)typeLocator;
            standardTypeLocator.registerImport("org.springframework.data.mongodb.core.query");
        }
    }

    protected Query evaluateQueryExpression() {
        Object value = this.queryExpression.getValue(this.getEvaluationContext());
        Assert.notNull((Object)value, (String)"'queryExpression' must not evaluate to null");
        Object query = null;
        if (value instanceof String) {
            String string = (String)value;
            return new BasicQuery(string);
        }
        if (value instanceof Query) {
            Query castQuery = (Query)value;
            return castQuery;
        }
        throw new IllegalStateException("'queryExpression' must evaluate to String or org.springframework.data.mongodb.core.query.Query, but not: " + String.valueOf(value));
    }

    protected String evaluateCollectionNameExpression() {
        String collectionName = (String)this.getCollectionNameExpression().getValue(this.getEvaluationContext(), String.class);
        Assert.notNull((Object)collectionName, (String)"'collectionNameExpression' must not evaluate to null");
        return collectionName;
    }

    protected Query getByIdInQuery(Collection<?> entities) {
        LinkedMultiValueMap byIds = new LinkedMultiValueMap();
        entities.stream().map(this::idForEntity).forEach(arg_0 -> AbstractMongoDbMessageSource.lambda$getByIdInQuery$0((MultiValueMap)byIds, arg_0));
        Criteria[] criterias = (Criteria[])byIds.entrySet().stream().map(it -> Criteria.where((String)((String)it.getKey())).in((Collection)it.getValue())).toArray(Criteria[]::new);
        return new Query((CriteriaDefinition)(criterias.length == 1 ? criterias[0] : new Criteria().orOperator(criterias)));
    }

    protected Pair<String, Object> idForEntity(Object entity) {
        if (entity instanceof String) {
            return AbstractMongoDbMessageSource.idFieldFromMap(Document.parse((String)entity.toString()));
        }
        if (entity instanceof Map) {
            Map asMap = (Map)entity;
            return AbstractMongoDbMessageSource.idFieldFromMap(asMap);
        }
        MappingContext mappingContext = this.mongoConverter.getMappingContext();
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)mappingContext.getRequiredPersistentEntity(entity.getClass());
        String idField = ((MongoPersistentProperty)persistentEntity.getRequiredIdProperty()).getFieldName();
        IdentifierAccessor idAccessor = persistentEntity.getIdentifierAccessor(entity);
        return Pair.of((Object)idField, (Object)idAccessor.getRequiredIdentifier());
    }

    protected @Nullable Update evaluateUpdateExpression() {
        if (this.updateExpression != null) {
            Object value = this.updateExpression.getValue(this.getEvaluationContext());
            Assert.notNull((Object)value, (String)"'updateExpression' must not evaluate to null");
            if (value instanceof String) {
                String string = (String)value;
                return new BasicUpdate(string);
            }
            if (value instanceof Update) {
                Update castUpdate = (Update)value;
                return castUpdate;
            }
            throw new IllegalStateException("'updateExpression' must evaluate to String or org.springframework.data.mongodb.core.query.Update");
        }
        return null;
    }

    private static Pair<String, Object> idFieldFromMap(Map<?, ?> map) {
        return Pair.of((Object)ID_FIELD, map.get(ID_FIELD));
    }

    private static /* synthetic */ void lambda$getByIdInQuery$0(MultiValueMap byIds, Pair it) {
        byIds.add((Object)((String)it.getFirst()), it.getSecond());
    }
}

