/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.store;

import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import com.mongodb.client.DistinctIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.springframework.beans.BeansException;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.integration.history.MessageHistory;
import org.springframework.integration.message.AdviceMessage;
import org.springframework.integration.store.AbstractMessageGroupStore;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageGroupStore;
import org.springframework.integration.store.MessageMetadata;
import org.springframework.integration.store.MessageStore;
import org.springframework.integration.store.SimpleMessageGroup;
import org.springframework.integration.support.MutableMessage;
import org.springframework.integration.support.MutableMessageBuilder;
import org.springframework.integration.support.converter.WhiteListDeserializingConverter;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class MongoDbMessageStore
extends AbstractMessageGroupStore
implements MessageStore,
BeanClassLoaderAware,
ApplicationContextAware,
InitializingBean {
    public static final String SEQUENCE_NAME = "messagesSequence";
    private static final String HEADERS = "headers";
    private static final String UNCHECKED = "unchecked";
    private static final String GROUP_ID_MUST_NOT_BE_NULL = "'groupId' must not be null";
    private static final String DEFAULT_COLLECTION_NAME = "messages";
    private static final String GROUP_ID_KEY = "_groupId";
    private static final String GROUP_COMPLETE_KEY = "_group_complete";
    private static final String LAST_RELEASED_SEQUENCE_NUMBER = "_last_released_sequence";
    private static final String GROUP_TIMESTAMP_KEY = "_group_timestamp";
    private static final String GROUP_UPDATE_TIMESTAMP_KEY = "_group_update_timestamp";
    private static final String CREATED_DATE = "_createdDate";
    private static final String SEQUENCE = "sequence";
    private final MongoTemplate template;
    private final MessageReadingMongoConverter converter;
    private final String collectionName;
    private ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
    private ApplicationContext applicationContext;
    private String[] whiteListPatterns;

    public MongoDbMessageStore(MongoDbFactory mongoDbFactory) {
        this(mongoDbFactory, null);
    }

    public MongoDbMessageStore(MongoDbFactory mongoDbFactory, @Nullable String collectionName) {
        Assert.notNull((Object)mongoDbFactory, (String)"mongoDbFactory must not be null");
        this.converter = new MessageReadingMongoConverter(mongoDbFactory, (MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty>)new MongoMappingContext());
        this.template = new MongoTemplate(mongoDbFactory, (MongoConverter)this.converter);
        this.collectionName = StringUtils.hasText((String)collectionName) ? collectionName : DEFAULT_COLLECTION_NAME;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        Assert.notNull((Object)classLoader, (String)"classLoader must not be null");
        this.classLoader = classLoader;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void addWhiteListPatterns(String ... patterns) {
        this.whiteListPatterns = patterns != null ? Arrays.copyOf(patterns, patterns.length) : null;
    }

    public void setCustomConverters(Object ... customConverters) {
        this.converter.setCustomConverters(customConverters);
    }

    public void afterPropertiesSet() {
        if (this.applicationContext != null) {
            this.converter.setApplicationContext(this.applicationContext);
        }
        this.converter.afterPropertiesSet();
        IndexOperations indexOperations = this.template.indexOps(this.collectionName);
        indexOperations.ensureIndex((IndexDefinition)new Index(GROUP_ID_KEY, Sort.Direction.ASC).on(GROUP_UPDATE_TIMESTAMP_KEY, Sort.Direction.DESC).on(SEQUENCE, Sort.Direction.DESC));
    }

    public <T> Message<T> addMessage(Message<T> message) {
        Assert.notNull(message, (String)"'message' must not be null");
        this.addMessageDocument(new MessageWrapper(message));
        return message;
    }

    private void addMessageDocument(MessageWrapper document) {
        UUID messageId = (UUID)document.headers.get("id");
        Assert.notNull((Object)messageId, (String)"ID header must not be null");
        Query query = MongoDbMessageStore.whereMessageIdIsAndGroupIdIs(messageId, document.get_GroupId());
        if (!this.template.exists(query, MessageWrapper.class, this.collectionName)) {
            if (document.get_Group_timestamp() == 0L) {
                document.set_Group_timestamp(System.currentTimeMillis());
            }
            document.set_message_timestamp(System.currentTimeMillis());
            this.template.insert((Object)document, this.collectionName);
        }
    }

    public Message<?> getMessage(UUID id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        MessageWrapper messageWrapper = (MessageWrapper)this.template.findOne(MongoDbMessageStore.whereMessageIdIs(id), MessageWrapper.class, this.collectionName);
        return messageWrapper != null ? messageWrapper.getMessage() : null;
    }

    public MessageMetadata getMessageMetadata(UUID id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        MessageWrapper messageWrapper = (MessageWrapper)this.template.findOne(MongoDbMessageStore.whereMessageIdIs(id), MessageWrapper.class, this.collectionName);
        if (messageWrapper != null) {
            MessageMetadata messageMetadata = new MessageMetadata(id);
            messageMetadata.setTimestamp(messageWrapper.get_message_timestamp());
            return messageMetadata;
        }
        return null;
    }

    @ManagedAttribute
    public long getMessageCount() {
        return this.template.getCollection(this.collectionName).countDocuments();
    }

    public Message<?> removeMessage(UUID id) {
        Assert.notNull((Object)id, (String)"'id' must not be null");
        MessageWrapper messageWrapper = (MessageWrapper)this.template.findAndRemove(MongoDbMessageStore.whereMessageIdIs(id), MessageWrapper.class, this.collectionName);
        return messageWrapper != null ? messageWrapper.getMessage() : null;
    }

    public MessageGroup getMessageGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)GROUP_ID_MUST_NOT_BE_NULL);
        Query query = MongoDbMessageStore.whereGroupIdOrder(groupId);
        MessageWrapper messageWrapper = (MessageWrapper)this.template.findOne(query, MessageWrapper.class, this.collectionName);
        if (messageWrapper != null) {
            long createdTime = messageWrapper.get_Group_timestamp();
            long lastModifiedTime = messageWrapper.get_Group_update_timestamp();
            boolean complete = messageWrapper.get_Group_complete();
            int lastReleasedSequence = messageWrapper.get_LastReleasedSequenceNumber();
            MessageGroup messageGroup = this.getMessageGroupFactory().create((MessageGroupStore)this, groupId, createdTime, complete);
            messageGroup.setLastModified(lastModifiedTime);
            messageGroup.setLastReleasedMessageSequenceNumber(lastReleasedSequence);
            return messageGroup;
        }
        return new SimpleMessageGroup(groupId);
    }

    public void addMessagesToGroup(Object groupId, Message<?> ... messages) {
        Assert.notNull((Object)groupId, (String)GROUP_ID_MUST_NOT_BE_NULL);
        Assert.notNull(messages, (String)"'message' must not be null");
        Query query = MongoDbMessageStore.whereGroupIdOrder(groupId);
        MessageWrapper messageDocument = (MessageWrapper)this.template.findOne(query, MessageWrapper.class, this.collectionName);
        long createdTime = System.currentTimeMillis();
        int lastReleasedSequence = 0;
        boolean complete = false;
        if (messageDocument != null) {
            createdTime = messageDocument.get_Group_timestamp();
            lastReleasedSequence = messageDocument.get_LastReleasedSequenceNumber();
            complete = messageDocument.get_Group_complete();
        }
        for (Message<?> message : messages) {
            MessageWrapper wrapper = new MessageWrapper(message);
            wrapper.set_GroupId(groupId);
            wrapper.set_Group_timestamp(createdTime);
            wrapper.set_Group_update_timestamp(messageDocument == null ? createdTime : System.currentTimeMillis());
            wrapper.set_Group_complete(complete);
            wrapper.set_LastReleasedSequenceNumber(lastReleasedSequence);
            wrapper.set_Sequence(this.getNextId());
            this.addMessageDocument(wrapper);
        }
    }

    public void removeMessagesFromGroup(Object groupId, Collection<Message<?>> messages) {
        Assert.notNull((Object)groupId, (String)GROUP_ID_MUST_NOT_BE_NULL);
        Assert.notNull(messages, (String)"'messageToRemove' must not be null");
        ArrayList<UUID> ids = new ArrayList<UUID>();
        for (Message<?> messageToRemove : messages) {
            ids.add(messageToRemove.getHeaders().getId());
            if (ids.size() < this.getRemoveBatchSize()) continue;
            this.bulkRemove(groupId, ids);
            ids.clear();
        }
        if (ids.size() > 0) {
            this.bulkRemove(groupId, ids);
        }
        this.updateGroup(groupId, MongoDbMessageStore.lastModifiedUpdate());
    }

    private void bulkRemove(Object groupId, Collection<UUID> ids) {
        BulkOperations bulkOperations = this.template.bulkOps(BulkOperations.BulkMode.ORDERED, this.collectionName);
        for (UUID id : ids) {
            bulkOperations.remove(MongoDbMessageStore.whereMessageIdIsAndGroupIdIs(id, groupId));
        }
        bulkOperations.execute();
    }

    public void removeMessageGroup(Object groupId) {
        this.template.remove(MongoDbMessageStore.whereGroupIdIs(groupId), this.collectionName);
    }

    public Iterator<MessageGroup> iterator() {
        ArrayList<MessageGroup> messageGroups = new ArrayList<MessageGroup>();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)GROUP_ID_KEY).exists(true));
        DistinctIterable groupIds = this.template.getCollection(this.collectionName).distinct(GROUP_ID_KEY, (Bson)query.getQueryObject(), String.class);
        for (Object groupId : groupIds) {
            messageGroups.add(this.getMessageGroup(groupId));
        }
        return messageGroups.iterator();
    }

    public Message<?> pollMessageFromGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)GROUP_ID_MUST_NOT_BE_NULL);
        Query query = MongoDbMessageStore.whereGroupIdIs(groupId).with(Sort.by((String[])new String[]{GROUP_UPDATE_TIMESTAMP_KEY, SEQUENCE}));
        MessageWrapper messageWrapper = (MessageWrapper)this.template.findAndRemove(query, MessageWrapper.class, this.collectionName);
        Message<?> message = null;
        if (messageWrapper != null) {
            message = messageWrapper.getMessage();
        }
        this.updateGroup(groupId, MongoDbMessageStore.lastModifiedUpdate());
        return message;
    }

    public int messageGroupSize(Object groupId) {
        long lCount = this.template.count(new Query((CriteriaDefinition)Criteria.where((String)GROUP_ID_KEY).is(groupId)), this.collectionName);
        Assert.isTrue((lCount <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Message count is out of Integer's range");
        return (int)lCount;
    }

    public void setLastReleasedSequenceNumberForGroup(Object groupId, int sequenceNumber) {
        this.updateGroup(groupId, MongoDbMessageStore.lastModifiedUpdate().set(LAST_RELEASED_SEQUENCE_NUMBER, (Object)sequenceNumber));
    }

    public void completeGroup(Object groupId) {
        this.updateGroup(groupId, MongoDbMessageStore.lastModifiedUpdate().set(GROUP_COMPLETE_KEY, (Object)true));
    }

    public Message<?> getOneMessageFromGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)GROUP_ID_MUST_NOT_BE_NULL);
        Query query = MongoDbMessageStore.whereGroupIdOrder(groupId);
        MessageWrapper messageWrapper = (MessageWrapper)this.template.findOne(query, MessageWrapper.class, this.collectionName);
        if (messageWrapper != null) {
            return messageWrapper.getMessage();
        }
        return null;
    }

    public Collection<Message<?>> getMessagesForGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)GROUP_ID_MUST_NOT_BE_NULL);
        Query query = MongoDbMessageStore.whereGroupIdOrder(groupId);
        List messageWrappers = this.template.find(query, MessageWrapper.class, this.collectionName);
        return messageWrappers.stream().map(MessageWrapper::getMessage).collect(Collectors.toList());
    }

    @ManagedAttribute
    public int getMessageCountForAllMessageGroups() {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"messageId").exists(true).and("groupId").exists(true));
        long count = this.template.count(query, this.collectionName);
        Assert.isTrue((count <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Message count is out of Integer's range");
        return (int)count;
    }

    @ManagedAttribute
    public int getMessageGroupCount() {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"groupId").exists(true));
        return ((ArrayList)this.template.getCollection(this.collectionName).distinct("groupId", (Bson)query.getQueryObject(), Object.class).into(new ArrayList())).size();
    }

    private static Update lastModifiedUpdate() {
        return Update.update((String)GROUP_UPDATE_TIMESTAMP_KEY, (Object)System.currentTimeMillis());
    }

    private static Query whereMessageIdIs(UUID id) {
        return new Query((CriteriaDefinition)Criteria.where((String)"headers.id").is((Object)id));
    }

    private static Query whereMessageIdIsAndGroupIdIs(UUID id, Object groupId) {
        return new Query((CriteriaDefinition)Criteria.where((String)"headers.id").is((Object)id).and(GROUP_ID_KEY).is(groupId));
    }

    private static Query whereGroupIdOrder(Object groupId) {
        return MongoDbMessageStore.whereGroupIdIs(groupId).with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{GROUP_UPDATE_TIMESTAMP_KEY, SEQUENCE}));
    }

    private static Query whereGroupIdIs(Object groupId) {
        return new Query((CriteriaDefinition)Criteria.where((String)GROUP_ID_KEY).is(groupId));
    }

    private void updateGroup(Object groupId, Update update) {
        Query query = MongoDbMessageStore.whereGroupIdIs(groupId).with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{GROUP_UPDATE_TIMESTAMP_KEY, SEQUENCE}));
        this.template.updateFirst(query, update, this.collectionName);
    }

    private int getNextId() {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)SEQUENCE_NAME));
        query.fields().include(SEQUENCE);
        return (Integer)((Map)this.template.findAndModify(query, new Update().inc(SEQUENCE, (Number)1), FindAndModifyOptions.options().returnNew(true).upsert(true), Map.class, this.collectionName)).get(SEQUENCE);
    }

    private static void enhanceHeaders(MessageHeaders messageHeaders, Map<String, Object> headers) {
        Object tsHeader;
        Map innerMap = (Map)new DirectFieldAccessor((Object)messageHeaders).getPropertyValue(HEADERS);
        Object idHeader = headers.get("id");
        if (idHeader != null) {
            innerMap.put("id", idHeader);
        }
        if ((tsHeader = headers.get("timestamp")) != null) {
            innerMap.put("timestamp", tsHeader);
        }
    }

    private static Map<String, Object> asMap(Bson bson) {
        if (bson instanceof Document) {
            return (Document)bson;
        }
        if (bson instanceof DBObject) {
            return ((DBObject)bson).toMap();
        }
        throw new IllegalArgumentException(String.format("Cannot read %s. as map. Given Bson must be a Document or DBObject!", bson.getClass()));
    }

    private static final class MessageWrapper {
        private static final String UNUSED = "unused";
        @Id
        private String _id;
        private volatile Object _groupId;
        @Transient
        private final Message<?> message;
        private final String _messageType;
        private final Object payload;
        private final Map<String, ?> headers;
        private final Message<?> inputMessage;
        private long _message_timestamp;
        private volatile long _group_timestamp;
        private volatile long _group_update_timestamp;
        private volatile int _last_released_sequence;
        private volatile boolean _group_complete;
        private int sequence;

        MessageWrapper(Message<?> message) {
            Assert.notNull(message, (String)"'message' must not be null");
            this.message = message;
            this._messageType = message.getClass().getName();
            this.payload = message.getPayload();
            this.headers = message.getHeaders();
            this.inputMessage = message instanceof AdviceMessage ? ((AdviceMessage)message).getInputMessage() : null;
        }

        public int get_LastReleasedSequenceNumber() {
            return this._last_released_sequence;
        }

        public long get_Group_timestamp() {
            return this._group_timestamp;
        }

        public boolean get_Group_complete() {
            return this._group_complete;
        }

        public Object get_GroupId() {
            return this._groupId;
        }

        public Message<?> getMessage() {
            return this.message;
        }

        public void set_GroupId(Object groupId) {
            this._groupId = groupId;
        }

        public void set_Group_timestamp(long groupTimestamp) {
            this._group_timestamp = groupTimestamp;
        }

        public long get_message_timestamp() {
            return this._message_timestamp;
        }

        public void set_message_timestamp(long _message_timestamp) {
            this._message_timestamp = _message_timestamp;
        }

        public long get_Group_update_timestamp() {
            return this._group_update_timestamp;
        }

        public void set_Group_update_timestamp(long lastModified) {
            this._group_update_timestamp = lastModified;
        }

        public void set_LastReleasedSequenceNumber(int lastReleasedSequenceNumber) {
            this._last_released_sequence = lastReleasedSequenceNumber;
        }

        public void set_Group_complete(boolean completedGroup) {
            this._group_complete = completedGroup;
        }

        public void set_Sequence(int sequence) {
            this.sequence = sequence;
        }
    }

    @WritingConverter
    private static class ThrowableToBytesConverter
    implements Converter<Throwable, byte[]> {
        private final Converter<Object, byte[]> serializingConverter = new SerializingConverter();

        ThrowableToBytesConverter() {
        }

        public byte[] convert(Throwable source) {
            return (byte[])this.serializingConverter.convert((Object)source);
        }
    }

    @ReadingConverter
    private class DocumentToErrorMessageConverter
    implements Converter<Document, ErrorMessage> {
        private final WhiteListDeserializingConverter deserializingConverter = new WhiteListDeserializingConverter();

        DocumentToErrorMessageConverter() {
        }

        public ErrorMessage convert(Document source) {
            Map headers = MongoDbMessageStore.this.converter.normalizeHeaders((Map)source.get((Object)MongoDbMessageStore.HEADERS));
            Object payload = this.deserializingConverter.convert(((Binary)source.get((Object)"payload")).getData());
            ErrorMessage message = new ErrorMessage((Throwable)payload, headers);
            MongoDbMessageStore.enhanceHeaders(message.getHeaders(), headers);
            return message;
        }
    }

    @ReadingConverter
    private class DocumentToAdviceMessageConverter
    implements Converter<Document, AdviceMessage<?>> {
        DocumentToAdviceMessageConverter() {
        }

        public AdviceMessage<?> convert(Document source) {
            Map headers = MongoDbMessageStore.this.converter.normalizeHeaders((Map)source.get((Object)MongoDbMessageStore.HEADERS));
            Message inputMessage = null;
            if (source.get((Object)"inputMessage") != null) {
                Bson inputMessageObject = (Bson)source.get((Object)"inputMessage");
                Object inputMessageType = MongoDbMessageStore.asMap(inputMessageObject).get("_class");
                try {
                    Class messageClass = ClassUtils.forName((String)inputMessageType.toString(), (ClassLoader)MongoDbMessageStore.this.classLoader);
                    inputMessage = (Message)MongoDbMessageStore.this.converter.read(messageClass, inputMessageObject);
                }
                catch (Exception e) {
                    throw new IllegalStateException("failed to load class: " + inputMessageType, e);
                }
            }
            AdviceMessage message = new AdviceMessage(MongoDbMessageStore.this.converter.extractPayload((Bson)source), headers, inputMessage);
            MongoDbMessageStore.enhanceHeaders(message.getHeaders(), headers);
            return message;
        }
    }

    @ReadingConverter
    private final class DocumentToMutableMessageConverter
    implements Converter<Document, MutableMessage<?>> {
        DocumentToMutableMessageConverter() {
        }

        public MutableMessage<?> convert(Document source) {
            Map headers = MongoDbMessageStore.this.converter.normalizeHeaders((Map)source.get((Object)MongoDbMessageStore.HEADERS));
            Object payload = MongoDbMessageStore.this.converter.extractPayload((Bson)source);
            return (MutableMessage)MutableMessageBuilder.withPayload((Object)payload).copyHeaders(headers).build();
        }
    }

    @ReadingConverter
    private class DocumentToGenericMessageConverter
    implements Converter<Document, GenericMessage<?>> {
        DocumentToGenericMessageConverter() {
        }

        public GenericMessage<?> convert(Document source) {
            Map headers = MongoDbMessageStore.this.converter.normalizeHeaders((Map)source.get((Object)MongoDbMessageStore.HEADERS));
            GenericMessage message = new GenericMessage(MongoDbMessageStore.this.converter.extractPayload((Bson)source), headers);
            MongoDbMessageStore.enhanceHeaders(message.getHeaders(), headers);
            return message;
        }
    }

    @WritingConverter
    private static class MessageHistoryToDocumentConverter
    implements Converter<MessageHistory, Document> {
        MessageHistoryToDocumentConverter() {
        }

        public Document convert(MessageHistory source) {
            BasicDBList dbList = new BasicDBList();
            for (Properties properties : source) {
                Document historyProperty = new Document().append("name", (Object)properties.getProperty("name")).append("type", (Object)properties.getProperty("type")).append("timestamp", (Object)properties.getProperty("timestamp"));
                dbList.add((Object)historyProperty);
            }
            return new Document("components", (Object)dbList).append("_class", (Object)MessageHistory.class.getName());
        }
    }

    private final class MessageReadingMongoConverter
    extends MappingMongoConverter {
        private static final String CLASS = "_class";
        private Object[] customConverters;

        MessageReadingMongoConverter(MongoDbFactory mongoDbFactory, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
            super((DbRefResolver)new DefaultDbRefResolver(mongoDbFactory), mappingContext);
        }

        void setCustomConverters(Object ... customConverters) {
            this.customConverters = customConverters != null ? Arrays.copyOf(customConverters, customConverters.length) : null;
        }

        public void afterPropertiesSet() {
            ArrayList<Object> converters = new ArrayList<Object>();
            converters.add(new MessageHistoryToDocumentConverter());
            converters.add(new DocumentToGenericMessageConverter());
            converters.add(new DocumentToMutableMessageConverter());
            DocumentToErrorMessageConverter docToErrorMessageConverter = new DocumentToErrorMessageConverter();
            if (MongoDbMessageStore.this.whiteListPatterns != null) {
                docToErrorMessageConverter.deserializingConverter.addWhiteListPatterns(MongoDbMessageStore.this.whiteListPatterns);
            }
            converters.add(docToErrorMessageConverter);
            converters.add(new DocumentToAdviceMessageConverter());
            converters.add(new ThrowableToBytesConverter());
            if (this.customConverters != null) {
                Collections.addAll(converters, this.customConverters);
            }
            this.setCustomConversions((CustomConversions)new MongoCustomConversions(converters));
            super.afterPropertiesSet();
        }

        public void write(Object source, Bson target) {
            Assert.isInstanceOf(MessageWrapper.class, (Object)source);
            MongoDbMessageStore.asMap(target).put(MongoDbMessageStore.CREATED_DATE, System.currentTimeMillis());
            super.write(source, target);
        }

        public <S> S read(Class<S> clazz, Bson source) {
            if (!MessageWrapper.class.equals(clazz)) {
                return (S)super.read(clazz, source);
            }
            if (source != null) {
                Map sourceMap = MongoDbMessageStore.asMap(source);
                Message message = null;
                Object messageType = sourceMap.get("_messageType");
                if (messageType == null) {
                    messageType = GenericMessage.class.getName();
                }
                try {
                    message = (Message)this.read(ClassUtils.forName((String)messageType.toString(), (ClassLoader)MongoDbMessageStore.this.classLoader), source);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("failed to load class: " + messageType, e);
                }
                Long groupTimestamp = (Long)sourceMap.get(MongoDbMessageStore.GROUP_TIMESTAMP_KEY);
                Long lastModified = (Long)sourceMap.get(MongoDbMessageStore.GROUP_UPDATE_TIMESTAMP_KEY);
                Integer lastReleasedSequenceNumber = (Integer)sourceMap.get(MongoDbMessageStore.LAST_RELEASED_SEQUENCE_NUMBER);
                Boolean completeGroup = (Boolean)sourceMap.get(MongoDbMessageStore.GROUP_COMPLETE_KEY);
                MessageWrapper wrapper = new MessageWrapper(message);
                if (sourceMap.containsKey(MongoDbMessageStore.GROUP_ID_KEY)) {
                    wrapper.set_GroupId(sourceMap.get(MongoDbMessageStore.GROUP_ID_KEY));
                }
                if (groupTimestamp != null) {
                    wrapper.set_Group_timestamp(groupTimestamp);
                }
                if (lastModified != null) {
                    wrapper.set_Group_update_timestamp(lastModified);
                }
                if (lastReleasedSequenceNumber != null) {
                    wrapper.set_LastReleasedSequenceNumber(lastReleasedSequenceNumber);
                }
                if (completeGroup != null) {
                    wrapper.set_Group_complete(completeGroup);
                }
                return (S)wrapper;
            }
            return null;
        }

        private Map<String, Object> normalizeHeaders(Map<String, Object> headers) {
            HashMap<String, Object> normalizedHeaders = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : headers.entrySet()) {
                String headerName = entry.getKey();
                Object headerValue = entry.getValue();
                if (headerValue instanceof Bson) {
                    Bson source = (Bson)headerValue;
                    Map document = MongoDbMessageStore.asMap(source);
                    try {
                        Class typeClass = null;
                        if (document.containsKey(CLASS)) {
                            Object type = document.get(CLASS);
                            typeClass = ClassUtils.forName((String)type.toString(), (ClassLoader)MongoDbMessageStore.this.classLoader);
                        } else if (source instanceof BasicDBList) {
                            typeClass = List.class;
                        } else {
                            throw new IllegalStateException("Unsupported 'Bson' type: " + source.getClass());
                        }
                        normalizedHeaders.put(headerName, super.read(typeClass, source));
                    }
                    catch (Exception e) {
                        MongoDbMessageStore.this.logger.warn((Object)("Header '" + headerName + "' could not be deserialized."), (Throwable)e);
                    }
                    continue;
                }
                normalizedHeaders.put(headerName, headerValue);
            }
            return normalizedHeaders;
        }

        private Object extractPayload(Bson source) {
            Object payload = MongoDbMessageStore.asMap(source).get("payload");
            if (payload instanceof Bson) {
                Bson payloadObject = (Bson)payload;
                Object payloadType = MongoDbMessageStore.asMap(payloadObject).get(CLASS);
                try {
                    Class payloadClass = ClassUtils.forName((String)payloadType.toString(), (ClassLoader)MongoDbMessageStore.this.classLoader);
                    payload = this.read(payloadClass, payloadObject);
                }
                catch (Exception e) {
                    throw new IllegalStateException("failed to load class: " + payloadType, e);
                }
            }
            return payload;
        }
    }
}

