/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.config;

import jakarta.mail.Authenticator;
import jakarta.mail.Session;
import jakarta.mail.URLName;
import jakarta.mail.internet.MimeMessage;
import java.util.Locale;
import java.util.Properties;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.expression.Expression;
import org.springframework.integration.mail.AbstractMailReceiver;
import org.springframework.integration.mail.ImapMailReceiver;
import org.springframework.integration.mail.MailReceiver;
import org.springframework.integration.mail.Pop3MailReceiver;
import org.springframework.integration.mail.SearchTermStrategy;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MailReceiverFactoryBean
extends AbstractFactoryBean<MailReceiver> {
    private @Nullable String storeUri;
    private @Nullable String protocol;
    private @Nullable Session session;
    private MailReceiver receiver;
    private @Nullable Properties javaMailProperties;
    private @Nullable Authenticator authenticator;
    private @Nullable Boolean shouldDeleteMessages = null;
    private @Nullable Boolean shouldMarkMessagesAsRead = null;
    private int maxFetchSize = 1;
    private @Nullable Expression selectorExpression;
    private @Nullable SearchTermStrategy searchTermStrategy;
    private @Nullable String userFlag;
    private @Nullable HeaderMapper<MimeMessage> headerMapper;
    private @Nullable Boolean embeddedPartsAsBytes;
    private @Nullable Boolean simpleContent;
    private @Nullable Boolean autoCloseFolder;

    public void setStoreUri(@Nullable String storeUri) {
        this.storeUri = storeUri;
    }

    public void setProtocol(@Nullable String protocol) {
        this.protocol = protocol;
    }

    public void setSession(@Nullable Session session) {
        this.session = session;
    }

    public void setJavaMailProperties(@Nullable Properties javaMailProperties) {
        this.javaMailProperties = javaMailProperties;
    }

    public void setAuthenticator(@Nullable Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setShouldDeleteMessages(@Nullable Boolean shouldDeleteMessages) {
        this.shouldDeleteMessages = shouldDeleteMessages;
    }

    public void setShouldMarkMessagesAsRead(@Nullable Boolean shouldMarkMessagesAsRead) {
        this.shouldMarkMessagesAsRead = shouldMarkMessagesAsRead;
    }

    public Boolean isShouldMarkMessagesAsRead() {
        return this.shouldMarkMessagesAsRead != null && this.shouldMarkMessagesAsRead != false;
    }

    public void setMaxFetchSize(int maxFetchSize) {
        this.maxFetchSize = maxFetchSize;
    }

    public void setSelectorExpression(@Nullable Expression selectorExpression) {
        this.selectorExpression = selectorExpression;
    }

    public void setSearchTermStrategy(@Nullable SearchTermStrategy searchTermStrategy) {
        this.searchTermStrategy = searchTermStrategy;
    }

    public void setUserFlag(@Nullable String userFlag) {
        this.userFlag = userFlag;
    }

    public void setHeaderMapper(@Nullable HeaderMapper<MimeMessage> headerMapper) {
        this.headerMapper = headerMapper;
    }

    public void setEmbeddedPartsAsBytes(@Nullable Boolean embeddedPartsAsBytes) {
        this.embeddedPartsAsBytes = embeddedPartsAsBytes;
    }

    public void setSimpleContent(@Nullable Boolean simpleContent) {
        this.simpleContent = simpleContent;
    }

    public void setAutoCloseFolder(@Nullable Boolean autoCloseFolder) {
        this.autoCloseFolder = autoCloseFolder;
    }

    protected MailReceiver createInstance() {
        if (this.receiver == null) {
            this.receiver = this.createReceiver();
        }
        return this.receiver;
    }

    public Class<?> getObjectType() {
        return this.receiver != null ? this.receiver.getClass() : MailReceiver.class;
    }

    private MailReceiver createReceiver() {
        BeanFactory beanFactory;
        AbstractMailReceiver mailReceiver;
        this.verifyProtocol();
        Assert.state((this.protocol != null ? 1 : 0) != 0, (String)"'protocol' should not be null ");
        boolean isPop3 = this.protocol.toLowerCase(Locale.ROOT).startsWith("pop3");
        boolean isImap = this.protocol.toLowerCase(Locale.ROOT).startsWith("imap");
        Assert.isTrue((isPop3 || isImap ? 1 : 0) != 0, (String)"the store URI must begin with 'pop3' or 'imap'");
        AbstractMailReceiver abstractMailReceiver = mailReceiver = isPop3 ? new Pop3MailReceiver(this.storeUri) : new ImapMailReceiver(this.storeUri);
        if (this.session != null) {
            Assert.isNull((Object)this.javaMailProperties, (String)"JavaMail Properties are not allowed when a Session has been provided.");
            Assert.isNull((Object)this.authenticator, (String)"A JavaMail Authenticator is not allowed when a Session has been provided.");
            mailReceiver.setSession(this.session);
        }
        if (this.searchTermStrategy != null) {
            Assert.isTrue((boolean)isImap, (String)"searchTermStrategy is only allowed with imap");
            ((ImapMailReceiver)mailReceiver).setSearchTermStrategy(this.searchTermStrategy);
        }
        if (this.javaMailProperties != null) {
            mailReceiver.setJavaMailProperties(this.javaMailProperties);
        }
        if (this.authenticator != null) {
            mailReceiver.setJavaMailAuthenticator(this.authenticator);
        }
        if (this.shouldDeleteMessages != null) {
            mailReceiver.setShouldDeleteMessages(this.shouldDeleteMessages);
        }
        mailReceiver.setMaxFetchSize(this.maxFetchSize);
        mailReceiver.setSelectorExpression(this.selectorExpression);
        if (StringUtils.hasText((String)this.userFlag)) {
            mailReceiver.setUserFlag(this.userFlag);
        }
        if (isPop3) {
            if (this.isShouldMarkMessagesAsRead().booleanValue()) {
                this.logger.warn((Object)"Setting 'should-mark-messages-as-read' to 'true' while using POP3 has no effect");
            }
        } else {
            ((ImapMailReceiver)mailReceiver).setShouldMarkMessagesAsRead(this.isShouldMarkMessagesAsRead());
        }
        if ((beanFactory = this.getBeanFactory()) != null) {
            mailReceiver.setBeanFactory(beanFactory);
        }
        if (this.headerMapper != null) {
            mailReceiver.setHeaderMapper(this.headerMapper);
        }
        if (this.embeddedPartsAsBytes != null) {
            mailReceiver.setEmbeddedPartsAsBytes(this.embeddedPartsAsBytes);
        }
        if (this.simpleContent != null) {
            mailReceiver.setSimpleContent(this.simpleContent);
        }
        if (this.autoCloseFolder != null) {
            mailReceiver.setAutoCloseFolder(this.autoCloseFolder);
        }
        mailReceiver.afterPropertiesSet();
        return mailReceiver;
    }

    private void verifyProtocol() {
        if (StringUtils.hasText((String)this.storeUri)) {
            URLName urlName = new URLName(this.storeUri);
            if (this.protocol == null) {
                this.protocol = urlName.getProtocol();
            } else {
                Assert.isTrue((boolean)this.protocol.equals(urlName.getProtocol()), (String)"The provided 'protocol' does not match that in the 'storeUri'.");
            }
        } else {
            Assert.hasText((String)this.protocol, (String)"Either the 'storeUri' or 'protocol' is required.");
        }
        Assert.hasText((String)this.protocol, (String)"Unable to resolve protocol.");
    }

    public void destroy() {
        MailReceiver mailReceiver;
        if (this.receiver != null && (mailReceiver = this.receiver) instanceof DisposableBean) {
            DisposableBean disposableReceiver = (DisposableBean)mailReceiver;
            try {
                disposableReceiver.destroy();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

