/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import java.util.Date;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import javax.mail.Folder;
import javax.mail.Message;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.mail.ImapMailReceiver;
import org.springframework.integration.mail.event.MailIntegrationEvent;
import org.springframework.integration.transaction.IntegrationResourceHolder;
import org.springframework.integration.transaction.IntegrationResourceHolderSynchronization;
import org.springframework.integration.transaction.TransactionSynchronizationFactory;
import org.springframework.messaging.MessagingException;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ImapIdleChannelAdapter
extends MessageProducerSupport
implements BeanClassLoaderAware,
ApplicationEventPublisherAware {
    private static final int DEFAULT_RECONNECT_DELAY = 10000;
    private final ExceptionAwarePeriodicTrigger receivingTaskTrigger = new ExceptionAwarePeriodicTrigger();
    private final IdleTask idleTask = new IdleTask();
    private final ImapMailReceiver mailReceiver;
    private TransactionSynchronizationFactory transactionSynchronizationFactory;
    private ClassLoader classLoader;
    private ApplicationEventPublisher applicationEventPublisher;
    private boolean shouldReconnectAutomatically = true;
    private Executor sendingTaskExecutor = Executors.newFixedThreadPool(1);
    private boolean sendingTaskExecutorSet;
    private List<Advice> adviceChain;
    private long reconnectDelay = 10000L;
    private volatile ScheduledFuture<?> receivingTask;

    public ImapIdleChannelAdapter(ImapMailReceiver mailReceiver) {
        Assert.notNull((Object)mailReceiver, (String)"'mailReceiver' must not be null");
        this.mailReceiver = mailReceiver;
    }

    public void setTransactionSynchronizationFactory(TransactionSynchronizationFactory transactionSynchronizationFactory) {
        this.transactionSynchronizationFactory = transactionSynchronizationFactory;
    }

    public void setAdviceChain(List<Advice> adviceChain) {
        this.adviceChain = adviceChain;
    }

    public void setSendingTaskExecutor(Executor sendingTaskExecutor) {
        Assert.notNull((Object)sendingTaskExecutor, (String)"'sendingTaskExecutor' must not be null");
        this.sendingTaskExecutor = sendingTaskExecutor;
        this.sendingTaskExecutorSet = true;
    }

    public void setShouldReconnectAutomatically(boolean shouldReconnectAutomatically) {
        this.shouldReconnectAutomatically = shouldReconnectAutomatically;
    }

    public void setReconnectDelay(long reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public String getComponentType() {
        return "mail:imap-idle-channel-adapter";
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    protected void doStart() {
        TaskScheduler scheduler = this.getTaskScheduler();
        Assert.notNull((Object)scheduler, (String)"'taskScheduler' must not be null");
        this.receivingTask = scheduler.schedule((Runnable)new ReceivingTask(), (Trigger)this.receivingTaskTrigger);
    }

    protected void doStop() {
        this.receivingTask.cancel(true);
        this.mailReceiver.cancelPing();
    }

    public void destroy() {
        super.destroy();
        this.mailReceiver.destroy();
        if (!this.sendingTaskExecutorSet && this.sendingTaskExecutor != null) {
            ((ExecutorService)this.sendingTaskExecutor).shutdown();
        }
    }

    private Runnable createMessageSendingTask(Object mailMessage) {
        Runnable sendingTask = this.prepareSendingTask(mailMessage);
        if (!CollectionUtils.isEmpty(this.adviceChain)) {
            ProxyFactory proxyFactory = new ProxyFactory((Object)sendingTask);
            if (!CollectionUtils.isEmpty(this.adviceChain)) {
                for (Advice advice : this.adviceChain) {
                    proxyFactory.addAdvice(advice);
                }
            }
            sendingTask = (Runnable)proxyFactory.getProxy(this.classLoader);
        }
        return sendingTask;
    }

    private Runnable prepareSendingTask(Object mailMessage) {
        return () -> {
            TransactionSynchronization synchronization;
            org.springframework.messaging.Message message;
            org.springframework.messaging.Message message2 = message = mailMessage instanceof Message ? this.getMessageBuilderFactory().withPayload(mailMessage).build() : (org.springframework.messaging.Message)mailMessage;
            if (TransactionSynchronizationManager.isActualTransactionActive() && this.transactionSynchronizationFactory != null && (synchronization = this.transactionSynchronizationFactory.create((Object)this)) != null) {
                Object resourceHolder;
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)synchronization);
                if (synchronization instanceof IntegrationResourceHolderSynchronization && !TransactionSynchronizationManager.hasResource((Object)((Object)this))) {
                    TransactionSynchronizationManager.bindResource((Object)((Object)this), (Object)((IntegrationResourceHolderSynchronization)synchronization).getResourceHolder());
                }
                if ((resourceHolder = TransactionSynchronizationManager.getResource((Object)((Object)this))) instanceof IntegrationResourceHolder) {
                    ((IntegrationResourceHolder)resourceHolder).setMessage(message);
                }
            }
            this.sendMessage(message);
        };
    }

    private void publishException(Exception e) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ImapIdleExceptionEvent(e));
        } else {
            this.logger.debug(() -> "No application event publisher for exception: " + e.getMessage());
        }
    }

    public class ImapIdleExceptionEvent
    extends MailIntegrationEvent {
        private static final long serialVersionUID = -5875388810251967741L;

        ImapIdleExceptionEvent(Exception e) {
            super((Object)ImapIdleChannelAdapter.this, e);
        }
    }

    private class ExceptionAwarePeriodicTrigger
    implements Trigger {
        private volatile boolean delayNextExecution;

        ExceptionAwarePeriodicTrigger() {
        }

        public Date nextExecutionTime(TriggerContext triggerContext) {
            if (this.delayNextExecution) {
                this.delayNextExecution = false;
                return new Date(System.currentTimeMillis() + ImapIdleChannelAdapter.this.reconnectDelay);
            }
            return new Date(System.currentTimeMillis());
        }

        void delayNextExecution() {
            this.delayNextExecution = true;
        }
    }

    private class IdleTask
    implements Runnable {
        IdleTask() {
        }

        @Override
        public void run() {
            if (ImapIdleChannelAdapter.this.isRunning()) {
                try {
                    ImapIdleChannelAdapter.this.logger.debug((CharSequence)"waiting for mail");
                    ImapIdleChannelAdapter.this.mailReceiver.waitForNewMessages();
                    Folder folder = ImapIdleChannelAdapter.this.mailReceiver.getFolder();
                    if (folder != null && folder.isOpen() && ImapIdleChannelAdapter.this.isRunning()) {
                        Object[] mailMessages = ImapIdleChannelAdapter.this.mailReceiver.receive();
                        ImapIdleChannelAdapter.this.logger.debug(() -> "received " + mailMessages.length + " mail messages");
                        for (Object mailMessage : mailMessages) {
                            Runnable messageSendingTask = ImapIdleChannelAdapter.this.createMessageSendingTask(mailMessage);
                            if (!ImapIdleChannelAdapter.this.isRunning()) continue;
                            ImapIdleChannelAdapter.this.sendingTaskExecutor.execute(messageSendingTask);
                        }
                    }
                }
                catch (javax.mail.MessagingException ex) {
                    ImapIdleChannelAdapter.this.logger.warn((Throwable)ex, (CharSequence)"error occurred in idle task");
                    if (ImapIdleChannelAdapter.this.shouldReconnectAutomatically) {
                        throw new IllegalStateException("Failure in 'idle' task. Will resubmit.", ex);
                    }
                    throw new MessagingException("Failure in 'idle' task. Will NOT resubmit.", (Throwable)ex);
                }
            }
        }
    }

    private class ReceivingTask
    implements Runnable {
        ReceivingTask() {
        }

        @Override
        public void run() {
            if (ImapIdleChannelAdapter.this.isRunning()) {
                try {
                    ImapIdleChannelAdapter.this.idleTask.run();
                    ImapIdleChannelAdapter.this.logger.debug((CharSequence)"Task completed successfully. Re-scheduling it again right away.");
                }
                catch (Exception ex) {
                    ImapIdleChannelAdapter.this.logger.warn((Throwable)ex, () -> "Failed to execute IDLE task. Will attempt to resubmit in " + ImapIdleChannelAdapter.this.reconnectDelay + " milliseconds.");
                    ImapIdleChannelAdapter.this.receivingTaskTrigger.delayNextExecution();
                    ImapIdleChannelAdapter.this.publishException(ex);
                }
            }
        }
    }
}

