/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.Message;
import org.springframework.integration.MessagingException;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.mail.MailReceiver;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailReceivingMessageSource
implements MessageSource<javax.mail.Message> {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final MailReceiver mailReceiver;
    private final Queue<javax.mail.Message> mailQueue = new ConcurrentLinkedQueue<javax.mail.Message>();

    public MailReceivingMessageSource(MailReceiver mailReceiver) {
        Assert.notNull((Object)mailReceiver, (String)"mailReceiver must not be null");
        this.mailReceiver = mailReceiver;
    }

    public Message<javax.mail.Message> receive() {
        try {
            javax.mail.Message mailMessage = this.mailQueue.poll();
            if (mailMessage == null) {
                javax.mail.Message[] messages = this.mailReceiver.receive();
                if (messages != null) {
                    this.mailQueue.addAll(Arrays.asList(messages));
                }
                mailMessage = this.mailQueue.poll();
            }
            if (mailMessage != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("received mail message [" + mailMessage + "]"));
                }
                return MessageBuilder.withPayload((Object)mailMessage).build();
            }
        }
        catch (Exception e) {
            throw new MessagingException("failure occurred while polling for mail", (Throwable)e);
        }
        return null;
    }
}

