/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.config.xml;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractChannelParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.kafka.channel.PollableKafkaChannel;
import org.springframework.integration.kafka.channel.PublishSubscribeKafkaChannel;
import org.springframework.integration.kafka.channel.SubscribableKafkaChannel;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class KafkaChannelParser
extends AbstractChannelParser {
    protected BeanDefinitionBuilder buildBeanDefinition(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder;
        String factory = element.getAttribute("container-factory");
        boolean hasFactory = StringUtils.hasText((String)factory);
        String source = element.getAttribute("message-source");
        boolean hasSource = StringUtils.hasText((String)source);
        String template = element.getAttribute("kafka-template");
        String topic = element.getAttribute("topic");
        boolean pubSub = "publish-subscribe-channel".equals(element.getLocalName());
        if (hasFactory) {
            builder = BeanDefinitionBuilder.genericBeanDefinition(pubSub ? PublishSubscribeKafkaChannel.class : SubscribableKafkaChannel.class);
            builder.addConstructorArgReference(template);
            builder.addConstructorArgReference(factory);
            builder.addConstructorArgValue((Object)topic);
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"auto-startup");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"phase");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"role");
        } else if (hasSource) {
            builder = BeanDefinitionBuilder.genericBeanDefinition(PollableKafkaChannel.class);
            builder.addConstructorArgReference(template);
            builder.addConstructorArgReference(source);
        } else {
            if (pubSub) {
                parserContext.getReaderContext().error("A 'container-factory' is required", (Object)element);
            } else {
                parserContext.getReaderContext().error("Either a 'container-factory' or 'message-source' is required", (Object)element);
            }
            throw new IllegalStateException("Either a 'container-factory' or 'message-source' is required");
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"group-id");
        return builder;
    }
}

