/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.dsl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.MessageHandlerSpec;
import org.springframework.integration.jpa.core.JpaExecutor;
import org.springframework.integration.jpa.outbound.JpaOutboundGateway;
import org.springframework.integration.jpa.support.JpaParameter;
import org.springframework.integration.jpa.support.parametersource.ParameterSourceFactory;

public abstract class JpaBaseOutboundEndpointSpec<S extends JpaBaseOutboundEndpointSpec<S>>
extends MessageHandlerSpec<S, JpaOutboundGateway>
implements ComponentsRegistration {
    private final List<JpaParameter> jpaParameters = new LinkedList<JpaParameter>();
    protected final JpaExecutor jpaExecutor;

    protected JpaBaseOutboundEndpointSpec(JpaExecutor jpaExecutor) {
        this.jpaExecutor = jpaExecutor;
        this.jpaExecutor.setJpaParameters(this.jpaParameters);
        this.target = new JpaOutboundGateway(this.jpaExecutor);
    }

    public S entityClass(Class<?> entityClass) {
        this.jpaExecutor.setEntityClass(entityClass);
        return (S)((Object)((JpaBaseOutboundEndpointSpec)this._this()));
    }

    public S jpaQuery(String jpaQuery) {
        this.jpaExecutor.setJpaQuery(jpaQuery);
        return (S)((Object)((JpaBaseOutboundEndpointSpec)this._this()));
    }

    public S nativeQuery(String nativeQuery) {
        this.jpaExecutor.setNativeQuery(nativeQuery);
        return (S)((Object)((JpaBaseOutboundEndpointSpec)this._this()));
    }

    public S namedQuery(String namedQuery) {
        this.jpaExecutor.setNamedQuery(namedQuery);
        return (S)((Object)((JpaBaseOutboundEndpointSpec)this._this()));
    }

    public S parameterSourceFactory(ParameterSourceFactory parameterSourceFactory) {
        this.jpaExecutor.setParameterSourceFactory(parameterSourceFactory);
        return (S)((Object)((JpaBaseOutboundEndpointSpec)this._this()));
    }

    public S parameter(Object value) {
        return this.parameter(new JpaParameter(value, null));
    }

    public S parameter(String name, Object value) {
        return this.parameter(new JpaParameter(name, value, null));
    }

    public S parameterExpression(String expression) {
        return this.parameter(new JpaParameter(null, expression));
    }

    public S parameterExpression(String name, String expression) {
        return this.parameter(new JpaParameter(name, null, expression));
    }

    public S parameter(JpaParameter jpaParameter) {
        this.jpaParameters.add(jpaParameter);
        return (S)((Object)((JpaBaseOutboundEndpointSpec)this._this()));
    }

    public S usePayloadAsParameterSource(Boolean usePayloadAsParameterSource) {
        this.jpaExecutor.setUsePayloadAsParameterSource(usePayloadAsParameterSource);
        return (S)((Object)((JpaBaseOutboundEndpointSpec)this._this()));
    }

    public Map<Object, @Nullable String> getComponentsToRegister() {
        return Collections.singletonMap(this.jpaExecutor, null);
    }
}

