/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.outbound;

import org.jspecify.annotations.Nullable;
import org.springframework.integration.config.AbstractSimpleMessageHandlerFactoryBean;
import org.springframework.integration.jpa.core.JpaExecutor;
import org.springframework.integration.jpa.outbound.JpaOutboundGateway;
import org.springframework.integration.jpa.support.OutboundGatewayType;
import org.springframework.util.Assert;

public class JpaOutboundGatewayFactoryBean
extends AbstractSimpleMessageHandlerFactoryBean<JpaOutboundGateway> {
    private @Nullable JpaExecutor jpaExecutor;
    private OutboundGatewayType gatewayType = OutboundGatewayType.UPDATING;
    private boolean producesReply = true;
    private @Nullable Long replyTimeout;
    private boolean requiresReply = false;

    public void setJpaExecutor(JpaExecutor jpaExecutor) {
        this.jpaExecutor = jpaExecutor;
    }

    public void setGatewayType(OutboundGatewayType gatewayType) {
        this.gatewayType = gatewayType;
    }

    public void setProducesReply(boolean producesReply) {
        this.producesReply = producesReply;
    }

    public void setReplyTimeout(long replyTimeout) {
        this.replyTimeout = replyTimeout;
    }

    public void setRequiresReply(boolean requiresReply) {
        this.requiresReply = requiresReply;
    }

    protected JpaOutboundGateway createHandler() {
        Assert.state((this.jpaExecutor != null ? 1 : 0) != 0, (String)"'jpaExecutor' must not be null");
        JpaOutboundGateway jpaOutboundGateway = new JpaOutboundGateway(this.jpaExecutor);
        jpaOutboundGateway.setGatewayType(this.gatewayType);
        jpaOutboundGateway.setProducesReply(this.producesReply);
        if (this.replyTimeout != null) {
            jpaOutboundGateway.setSendTimeout(this.replyTimeout);
        }
        jpaOutboundGateway.setRequiresReply(this.requiresReply);
        return jpaOutboundGateway;
    }
}

