/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.support;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

public final class JpaUtils {
    public static final String DELETE_ALL_QUERY_STRING = "delete from %s x";
    private static final Pattern ALIAS_MATCH;
    private static final String IDENTIFIER = "[\\p{Alnum}._$]+";
    private static final String IDENTIFIER_GROUP;

    private JpaUtils() {
    }

    public static String detectAlias(String query) {
        Matcher matcher = ALIAS_MATCH.matcher(query);
        return matcher.find() ? matcher.group(2) : null;
    }

    public static <T> Query applyAndBind(String queryString, Iterable<T> entities, EntityManager entityManager) {
        Assert.hasText((String)queryString, (String)"'queryString' must not be empty");
        Assert.notNull(entities, (String)"'entities' must not be null");
        Assert.notNull((Object)entityManager, (String)"'entityManager' must not be null");
        Iterator<T> iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return entityManager.createQuery(queryString);
        }
        String alias = JpaUtils.detectAlias(queryString);
        StringBuilder builder = new StringBuilder(queryString);
        builder.append(" where");
        int i = 0;
        while (iterator.hasNext()) {
            iterator.next();
            builder.append(String.format(" %s = ?%d", alias, ++i));
            if (!iterator.hasNext()) continue;
            builder.append(" or");
        }
        Query query = entityManager.createQuery(builder.toString());
        iterator = entities.iterator();
        i = 0;
        while (iterator.hasNext()) {
            query.setParameter(++i, iterator.next());
        }
        return query;
    }

    public static String getQueryString(String template, String entityName) {
        Assert.hasText((String)entityName, (String)"Entity name must not be null or empty!");
        return String.format(template, entityName);
    }

    public static String getEntityName(EntityManager em, Class<?> entityClass) {
        return em.getMetamodel().entity(entityClass).getName();
    }

    static {
        IDENTIFIER_GROUP = String.format("(%s)", IDENTIFIER);
        StringBuilder builder = new StringBuilder();
        builder.append("(?<=from)");
        builder.append("(?: )+");
        builder.append(IDENTIFIER_GROUP);
        builder.append("(?: as)*");
        builder.append("(?: )+");
        builder.append("(\\w*)");
        ALIAS_MATCH = Pattern.compile(builder.toString(), 2);
        builder = new StringBuilder();
        builder.append("(select\\s+((distinct )?.+?)\\s+)?(from\\s+");
        builder.append(IDENTIFIER);
        builder.append("(?:\\s+as)?\\s+)");
        builder.append(IDENTIFIER_GROUP);
        builder.append("(.*)");
    }
}

