/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.monitor;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.DynamicMBean;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.PointcutAdvisor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.support.NameMatchMethodPointcutAdvisor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.Lifecycle;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.integration.context.OrderlyShutdownCapable;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.history.MessageHistoryConfigurer;
import org.springframework.integration.monitor.DirectChannelMetrics;
import org.springframework.integration.monitor.LifecycleMessageHandlerMetrics;
import org.springframework.integration.monitor.LifecycleMessageSourceMetrics;
import org.springframework.integration.monitor.ManagedEndpoint;
import org.springframework.integration.monitor.MessageChannelMetrics;
import org.springframework.integration.monitor.MessageHandlerMetrics;
import org.springframework.integration.monitor.MessageSourceMetrics;
import org.springframework.integration.monitor.PollableChannelMetrics;
import org.springframework.integration.monitor.QueueChannelMetrics;
import org.springframework.integration.monitor.SimpleMessageHandlerMetrics;
import org.springframework.integration.monitor.SimpleMessageSourceMetrics;
import org.springframework.integration.monitor.Statistics;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.export.UnableToRegisterMBeanException;
import org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.export.assembler.MBeanInfoAssembler;
import org.springframework.jmx.export.assembler.MetadataMBeanInfoAssembler;
import org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.springframework.jmx.export.naming.MetadataNamingStrategy;
import org.springframework.jmx.export.naming.ObjectNamingStrategy;
import org.springframework.jmx.support.MetricType;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.PollableChannel;
import org.springframework.util.Assert;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.ReflectionUtils;

@ManagedResource
public class IntegrationMBeanExporter
extends MBeanExporter
implements BeanPostProcessor,
BeanFactoryAware,
ApplicationContextAware,
BeanClassLoaderAware,
SmartLifecycle {
    private static final Log logger = LogFactory.getLog(IntegrationMBeanExporter.class);
    public static final String DEFAULT_DOMAIN = "org.springframework.integration";
    private final AnnotationJmxAttributeSource attributeSource = new AnnotationJmxAttributeSource();
    private ListableBeanFactory beanFactory;
    private ApplicationContext applicationContext;
    private final Map<Object, AtomicLong> anonymousHandlerCounters = new HashMap<Object, AtomicLong>();
    private final Map<Object, AtomicLong> anonymousSourceCounters = new HashMap<Object, AtomicLong>();
    private final Set<SimpleMessageHandlerMetrics> handlers = new HashSet<SimpleMessageHandlerMetrics>();
    private final Set<SimpleMessageSourceMetrics> sources = new HashSet<SimpleMessageSourceMetrics>();
    private final Set<Lifecycle> inboundLifecycleMessageProducers = new HashSet<Lifecycle>();
    private final Set<DirectChannelMetrics> channels = new HashSet<DirectChannelMetrics>();
    private final Map<String, Object> exposedBeans = new HashMap<String, Object>();
    private final Map<String, DirectChannelMetrics> channelsByName = new HashMap<String, DirectChannelMetrics>();
    private final Map<String, MessageHandlerMetrics> handlersByName = new HashMap<String, MessageHandlerMetrics>();
    private final Map<String, MessageSourceMetrics> sourcesByName = new HashMap<String, MessageSourceMetrics>();
    private final Map<String, DirectChannelMetrics> allChannelsByName = new HashMap<String, DirectChannelMetrics>();
    private final Map<String, MessageHandlerMetrics> allHandlersByName = new HashMap<String, MessageHandlerMetrics>();
    private final Map<String, MessageSourceMetrics> allSourcesByName = new HashMap<String, MessageSourceMetrics>();
    private final Map<String, String> beansByEndpointName = new HashMap<String, String>();
    private ClassLoader beanClassLoader;
    private volatile boolean autoStartup = true;
    private volatile int phase = 0;
    private volatile boolean running;
    private final ReentrantLock lifecycleLock = new ReentrantLock();
    private String domain = "org.springframework.integration";
    private final Properties objectNameStaticProperties = new Properties();
    private final MetadataMBeanInfoAssembler assembler = new MetadataMBeanInfoAssembler((JmxAttributeSource)this.attributeSource);
    private final MetadataNamingStrategy defaultNamingStrategy = new MetadataNamingStrategy((JmxAttributeSource)this.attributeSource);
    private String[] componentNamePatterns = new String[]{"*"};
    private volatile long shutdownDeadline;
    private final AtomicBoolean shuttingDown = new AtomicBoolean();
    private MessageHistoryConfigurer messageHistoryConfigurer;

    public IntegrationMBeanExporter() {
        this.setAutodetect(false);
        this.setNamingStrategy((ObjectNamingStrategy)this.defaultNamingStrategy);
        this.setAssembler((MBeanInfoAssembler)this.assembler);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
        super.setBeanClassLoader(classLoader);
    }

    public void setObjectNameStaticProperties(Map<String, String> objectNameStaticProperties) {
        this.objectNameStaticProperties.putAll(objectNameStaticProperties);
    }

    public void setDefaultDomain(String domain) {
        this.domain = domain;
        this.defaultNamingStrategy.setDefaultDomain(domain);
    }

    public void setComponentNamePatterns(String[] componentNamePatterns) {
        Assert.notEmpty((Object[])componentNamePatterns, (String)"componentNamePatterns must not be empty");
        this.componentNamePatterns = componentNamePatterns;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        super.setBeanFactory(beanFactory);
        Assert.isInstanceOf(ListableBeanFactory.class, (Object)beanFactory, (String)"A ListableBeanFactory is required.");
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Assert.notNull((Object)applicationContext, (String)"ApplicationContext may not be null");
        this.applicationContext = applicationContext;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Lifecycle target;
        MethodInterceptor monitor;
        if (bean instanceof Advised) {
            for (Advisor advisor : ((Advised)bean).getAdvisors()) {
                Advice advice = advisor.getAdvice();
                if (!(advice instanceof MessageHandlerMetrics) && !(advice instanceof MessageSourceMetrics) && !(advice instanceof MessageChannelMetrics)) continue;
                return bean;
            }
        }
        if ("messageHistoryConfigurer".equals(beanName) && bean instanceof MessageHistoryConfigurer) {
            this.messageHistoryConfigurer = (MessageHistoryConfigurer)bean;
            return bean;
        }
        if (bean instanceof MessageHandler) {
            if (this.handlerInAnonymousWrapper(bean) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Skipping " + beanName + " because it wraps another handler"));
                }
                return bean;
            }
            monitor = new SimpleMessageHandlerMetrics((MessageHandler)bean);
            Object advised = this.applyHandlerInterceptor(bean, (SimpleMessageHandlerMetrics)monitor, this.beanClassLoader);
            this.handlers.add((SimpleMessageHandlerMetrics)monitor);
            bean = advised;
        }
        if (bean instanceof MessageSource) {
            monitor = new SimpleMessageSourceMetrics((MessageSource)bean);
            Object advised = this.applySourceInterceptor(bean, (SimpleMessageSourceMetrics)monitor, this.beanClassLoader);
            this.sources.add((SimpleMessageSourceMetrics)monitor);
            bean = advised;
        }
        if (bean instanceof MessageChannel) {
            MessageChannel target2 = (MessageChannel)this.extractTarget(bean);
            monitor = bean instanceof PollableChannel ? (target2 instanceof QueueChannel ? new QueueChannelMetrics((QueueChannel)target2, beanName) : new PollableChannelMetrics(target2, beanName)) : new DirectChannelMetrics(target2, beanName);
            Object advised = this.applyChannelInterceptor(bean, (DirectChannelMetrics)monitor, this.beanClassLoader);
            this.channels.add((DirectChannelMetrics)monitor);
            bean = advised;
        }
        if (bean instanceof MessageProducer && bean instanceof Lifecycle && !((target = (Lifecycle)this.extractTarget(bean)) instanceof AbstractReplyProducingMessageHandler)) {
            this.inboundLifecycleMessageProducers.add(target);
        }
        return bean;
    }

    private MessageHandler handlerInAnonymousWrapper(final Object bean) {
        if (bean != null && bean.getClass().isAnonymousClass()) {
            final AtomicReference wrapped = new AtomicReference();
            ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                    field.setAccessible(true);
                    Object handler = field.get(bean);
                    if (handler instanceof MessageHandler) {
                        wrapped.set((MessageHandler)handler);
                    }
                }
            }, (ReflectionUtils.FieldFilter)new ReflectionUtils.FieldFilter(){

                public boolean matches(Field field) {
                    return wrapped.get() == null && field.getName().startsWith("val$");
                }
            });
            return (MessageHandler)wrapped.get();
        }
        return null;
    }

    private ObjectName registerBeanInstance(Object bean, String beanKey) {
        try {
            ObjectName objectName = this.getObjectName(bean, beanKey);
            Object mbeanToExpose = null;
            if (this.isMBean(bean.getClass())) {
                mbeanToExpose = bean;
            } else {
                DynamicMBean adaptedBean = this.adaptMBeanIfPossible(bean);
                if (adaptedBean != null) {
                    mbeanToExpose = adaptedBean;
                }
            }
            if (mbeanToExpose != null) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Located MBean '" + beanKey + "': registering with JMX server as MBean [" + objectName + "]"));
                }
                this.doRegister(mbeanToExpose, objectName);
            } else {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Located managed bean '" + beanKey + "': registering with JMX server as MBean [" + objectName + "]"));
                }
                ModelMBean mbean = this.createAndConfigureMBean(bean, beanKey);
                this.doRegister(mbean, objectName);
            }
            return objectName;
        }
        catch (JMException e) {
            throw new UnableToRegisterMBeanException("Unable to register MBean [" + bean + "] with key '" + beanKey + "'", (Throwable)e);
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public final boolean isAutoStartup() {
        return this.autoStartup;
    }

    public final int getPhase() {
        return this.phase;
    }

    public final boolean isRunning() {
        this.lifecycleLock.lock();
        try {
            boolean bl = this.running;
            return bl;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public final void start() {
        this.lifecycleLock.lock();
        try {
            if (!this.running) {
                this.doStart();
                this.running = true;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("started " + (Object)((Object)this)));
                }
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public final void stop() {
        this.lifecycleLock.lock();
        try {
            if (this.running) {
                this.doStop();
                this.running = false;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("stopped " + (Object)((Object)this)));
                }
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public final void stop(Runnable callback) {
        this.lifecycleLock.lock();
        try {
            this.stop();
            callback.run();
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    protected void doStop() {
        this.unregisterBeans();
        this.channelsByName.clear();
        this.handlersByName.clear();
        this.sourcesByName.clear();
    }

    protected void doStart() {
        this.registerChannels();
        this.registerHandlers();
        this.registerSources();
        this.registerEndpoints();
        if (this.messageHistoryConfigurer != null) {
            this.registerBeanInstance(this.messageHistoryConfigurer, "messageHistoryConfigurer");
        }
    }

    public void destroy() {
        super.destroy();
        for (MessageChannelMetrics messageChannelMetrics : this.channels) {
            logger.info((Object)("Summary on shutdown: " + messageChannelMetrics));
        }
        for (MessageHandlerMetrics messageHandlerMetrics : this.handlers) {
            logger.info((Object)("Summary on shutdown: " + messageHandlerMetrics));
        }
    }

    @Deprecated
    @ManagedOperation
    public void stopActiveComponents(boolean force, long howLong) {
        this.stopActiveComponents(howLong);
    }

    @ManagedOperation
    public void stopActiveComponents(long howLong) {
        if (!this.shuttingDown.compareAndSet(false, true)) {
            logger.error((Object)"Shutdown already in process");
            return;
        }
        this.shutdownDeadline = System.currentTimeMillis() + howLong;
        try {
            logger.debug((Object)"Running shutdown");
            this.doShutdown();
        }
        catch (Exception e) {
            logger.error((Object)"Orderly shutdown failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doShutdown() {
        try {
            this.orderlyShutdownCapableComponentsBefore();
            this.stopActiveChannels();
            this.stopMessageSources();
            this.stopInboundMessageProducers();
            long timeLeft = this.shutdownDeadline - System.currentTimeMillis();
            if (timeLeft > 0L) {
                try {
                    Thread.sleep(timeLeft);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error((Object)"Interrupted while waiting for quiesce");
                }
            }
            this.orderlyShutdownCapableComponentsAfter();
        }
        finally {
            this.shuttingDown.set(false);
        }
    }

    @ManagedOperation
    public void stopMessageSources() {
        for (Map.Entry<String, MessageSourceMetrics> entry : this.allSourcesByName.entrySet()) {
            MessageSourceMetrics sourceMetrics = entry.getValue();
            if (sourceMetrics instanceof LifecycleMessageSourceMetrics) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Stopping message source " + sourceMetrics));
                }
                ((LifecycleMessageSourceMetrics)sourceMetrics).stop();
                continue;
            }
            if (!logger.isInfoEnabled()) continue;
            logger.info((Object)("Message source " + sourceMetrics + " cannot be stopped"));
        }
    }

    @ManagedOperation
    public void stopInboundMessageProducers() {
        for (Lifecycle producer : this.inboundLifecycleMessageProducers) {
            if (producer instanceof OrderlyShutdownCapable) continue;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Stopping message producer " + producer));
            }
            producer.stop();
        }
    }

    @ManagedOperation
    public void stopActiveChannels() {
        for (Map.Entry<String, DirectChannelMetrics> entry : this.allChannelsByName.entrySet()) {
            DirectChannelMetrics metrics = entry.getValue();
            MessageChannel channel = metrics.getMessageChannel();
            if (!(channel instanceof Lifecycle)) continue;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Stopping channel " + channel));
            }
            ((Lifecycle)channel).stop();
        }
    }

    protected final void orderlyShutdownCapableComponentsBefore() {
        logger.debug((Object)"Initiating stop OrderlyShutdownCapable components");
        Map components = this.applicationContext.getBeansOfType(OrderlyShutdownCapable.class);
        for (Map.Entry componentEntry : components.entrySet()) {
            OrderlyShutdownCapable component = (OrderlyShutdownCapable)componentEntry.getValue();
            int n = component.beforeShutdown();
            if (!logger.isInfoEnabled()) continue;
            logger.info((Object)("Initiated stop for component " + component + "; it reported " + n + " active messages"));
        }
        logger.debug((Object)"Initiated stop OrderlyShutdownCapable components");
    }

    protected final void orderlyShutdownCapableComponentsAfter() {
        logger.debug((Object)"Finalizing stop OrderlyShutdownCapable components");
        Map components = this.applicationContext.getBeansOfType(OrderlyShutdownCapable.class);
        for (Map.Entry componentEntry : components.entrySet()) {
            OrderlyShutdownCapable component = (OrderlyShutdownCapable)componentEntry.getValue();
            int n = component.afterShutdown();
            if (!logger.isInfoEnabled()) continue;
            logger.info((Object)("Finalized stop for component " + component + "; it reported " + n + " active messages"));
        }
        logger.debug((Object)"Finalized stop OrderlyShutdownCapable components");
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="MessageChannel Channel Count")
    public int getChannelCount() {
        return this.channelsByName.size();
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="MessageHandler Handler Count")
    public int getHandlerCount() {
        return this.handlersByName.size();
    }

    @ManagedAttribute
    public String[] getHandlerNames() {
        return this.handlersByName.keySet().toArray(new String[this.handlersByName.size()]);
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Active Handler Count")
    public int getActiveHandlerCount() {
        return (int)this.getActiveHandlerCountLong();
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Active Handler Count")
    public long getActiveHandlerCountLong() {
        int count = 0;
        for (MessageHandlerMetrics messageHandlerMetrics : this.handlers) {
            count = (int)((long)count + messageHandlerMetrics.getActiveCountLong());
        }
        return count;
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Queued Message Count")
    public int getQueuedMessageCount() {
        int count = 0;
        for (MessageChannelMetrics messageChannelMetrics : this.channels) {
            if (!(messageChannelMetrics instanceof QueueChannelMetrics)) continue;
            count += ((QueueChannelMetrics)messageChannelMetrics).getQueueSize();
        }
        return count;
    }

    @ManagedAttribute
    public String[] getChannelNames() {
        return this.channelsByName.keySet().toArray(new String[this.channelsByName.size()]);
    }

    public MessageHandlerMetrics getHandlerMetrics(String name) {
        if (this.handlersByName.containsKey(name)) {
            return this.handlersByName.get(name);
        }
        logger.debug((Object)("No handler found for (" + name + ")"));
        return null;
    }

    public Statistics getHandlerDuration(String name) {
        if (this.handlersByName.containsKey(name)) {
            return this.handlersByName.get(name).getDuration();
        }
        logger.debug((Object)("No handler found for (" + name + ")"));
        return null;
    }

    public MessageSourceMetrics getSourceMetrics(String name) {
        if (this.sourcesByName.containsKey(name)) {
            return this.sourcesByName.get(name);
        }
        logger.debug((Object)("No source found for (" + name + ")"));
        return null;
    }

    public int getSourceMessageCount(String name) {
        return (int)this.getSourceMessageCountLong(name);
    }

    public long getSourceMessageCountLong(String name) {
        if (this.sourcesByName.containsKey(name)) {
            return this.sourcesByName.get(name).getMessageCountLong();
        }
        logger.debug((Object)("No source found for (" + name + ")"));
        return -1L;
    }

    public MessageChannelMetrics getChannelMetrics(String name) {
        if (this.channelsByName.containsKey(name)) {
            return this.channelsByName.get(name);
        }
        logger.debug((Object)("No channel found for (" + name + ")"));
        return null;
    }

    public int getChannelSendCount(String name) {
        return (int)this.getChannelSendCountLong(name);
    }

    public long getChannelSendCountLong(String name) {
        if (this.channelsByName.containsKey(name)) {
            return this.channelsByName.get(name).getSendCountLong();
        }
        logger.debug((Object)("No channel found for (" + name + ")"));
        return -1L;
    }

    public int getChannelSendErrorCount(String name) {
        return (int)this.getChannelSendErrorCountLong(name);
    }

    public long getChannelSendErrorCountLong(String name) {
        if (this.channelsByName.containsKey(name)) {
            return this.channelsByName.get(name).getSendErrorCountLong();
        }
        logger.debug((Object)("No channel found for (" + name + ")"));
        return -1L;
    }

    public int getChannelReceiveCount(String name) {
        return (int)this.getChannelReceiveCountLong(name);
    }

    public long getChannelReceiveCountLong(String name) {
        if (this.channelsByName.containsKey(name) && this.channelsByName.get(name) instanceof PollableChannelMetrics) {
            return ((PollableChannelMetrics)this.channelsByName.get(name)).getReceiveCountLong();
        }
        logger.debug((Object)("No channel found for (" + name + ")"));
        return -1L;
    }

    @ManagedOperation
    public Statistics getChannelSendRate(String name) {
        if (this.channelsByName.containsKey(name)) {
            return this.channelsByName.get(name).getSendRate();
        }
        logger.debug((Object)("No channel found for (" + name + ")"));
        return null;
    }

    public Statistics getChannelErrorRate(String name) {
        if (this.channelsByName.containsKey(name)) {
            return this.channelsByName.get(name).getErrorRate();
        }
        logger.debug((Object)("No channel found for (" + name + ")"));
        return null;
    }

    protected void registerBeans() {
        if (!this.exposedBeans.isEmpty()) {
            super.setBeans(this.exposedBeans);
            super.registerBeans();
        }
    }

    private void registerChannels() {
        for (DirectChannelMetrics monitor : this.channels) {
            String name = monitor.getName();
            this.allChannelsByName.put(name, monitor);
            if (!PatternMatchUtils.simpleMatch((String[])this.componentNamePatterns, (String)name) || this.channelsByName.containsKey(name)) continue;
            String beanKey = this.getChannelBeanKey(name);
            logger.info((Object)("Registering MessageChannel " + name));
            if (name != null) {
                this.channelsByName.put(name, monitor);
            }
            this.registerBeanNameOrInstance(monitor, beanKey);
            MessageChannel bean = monitor.getMessageChannel();
            if (!this.assembler.includeBean(bean.getClass(), monitor.getName())) continue;
            this.registerBeanInstance(bean, this.getMonitoredIntegrationObjectBeanKey(bean, name));
        }
    }

    private void registerHandlers() {
        for (SimpleMessageHandlerMetrics source : this.handlers) {
            MessageHandlerMetrics monitor = this.enhanceHandlerMonitor(source);
            String name = monitor.getName();
            this.allHandlersByName.put(name, monitor);
            if (!PatternMatchUtils.simpleMatch((String[])this.componentNamePatterns, (String)name) || this.handlersByName.containsKey(name)) continue;
            String beanKey = this.getHandlerBeanKey(monitor);
            if (name != null) {
                this.handlersByName.put(name, monitor);
            }
            this.registerBeanNameOrInstance(monitor, beanKey);
            MessageHandler bean = source.getMessageHandler();
            if (!this.assembler.includeBean(bean.getClass(), source.getName())) continue;
            this.registerBeanInstance(bean, this.getMonitoredIntegrationObjectBeanKey(bean, name));
        }
    }

    private void registerSources() {
        for (SimpleMessageSourceMetrics source : this.sources) {
            MessageSourceMetrics monitor = this.enhanceSourceMonitor(source);
            String name = monitor.getName();
            this.allSourcesByName.put(name, monitor);
            if (!PatternMatchUtils.simpleMatch((String[])this.componentNamePatterns, (String)name) || this.sourcesByName.containsKey(name)) continue;
            String beanKey = this.getSourceBeanKey(monitor);
            if (name != null) {
                this.sourcesByName.put(name, monitor);
            }
            this.registerBeanNameOrInstance(monitor, beanKey);
            MessageSource<?> bean = source.getMessageSource();
            if (!this.assembler.includeBean(bean.getClass(), source.getName())) continue;
            this.registerBeanInstance(bean, this.getMonitoredIntegrationObjectBeanKey(bean, name));
        }
    }

    private void registerEndpoints() {
        String[] names = this.beanFactory.getBeanNamesForType(AbstractEndpoint.class);
        HashSet<String> endpointNames = new HashSet<String>();
        for (String name : names) {
            String source;
            if (this.beansByEndpointName.values().contains(name)) continue;
            AbstractEndpoint endpoint = (AbstractEndpoint)this.beanFactory.getBean(name, AbstractEndpoint.class);
            if ((name = endpoint.getComponentName()).startsWith("_org.springframework.integration")) {
                name = this.getInternalComponentName(name);
                source = "internal";
            } else {
                name = endpoint.getComponentName();
                source = "endpoint";
            }
            if (!PatternMatchUtils.simpleMatch((String[])this.componentNamePatterns, (String)name)) continue;
            if (endpointNames.contains(name)) {
                int count = 0;
                String unique = name + "#" + count;
                while (endpointNames.contains(unique)) {
                    unique = name + "#" + ++count;
                }
                name = unique;
            }
            endpointNames.add(name);
            String beanKey = this.getEndpointBeanKey(endpoint, name, source);
            ObjectName objectName = this.registerBeanInstance(new ManagedEndpoint(endpoint), beanKey);
            logger.info((Object)("Registered endpoint without MessageSource: " + objectName));
        }
    }

    private Object applyChannelInterceptor(Object bean, DirectChannelMetrics interceptor, ClassLoader beanClassLoader) {
        NameMatchMethodPointcutAdvisor channelsAdvice = new NameMatchMethodPointcutAdvisor((Advice)interceptor);
        channelsAdvice.addMethodName("send");
        channelsAdvice.addMethodName("receive");
        return this.applyAdvice(bean, (PointcutAdvisor)channelsAdvice, beanClassLoader);
    }

    private Object applyHandlerInterceptor(Object bean, SimpleMessageHandlerMetrics interceptor, ClassLoader beanClassLoader) {
        NameMatchMethodPointcutAdvisor handlerAdvice = new NameMatchMethodPointcutAdvisor((Advice)interceptor);
        handlerAdvice.addMethodName("handleMessage");
        return this.applyAdvice(bean, (PointcutAdvisor)handlerAdvice, beanClassLoader);
    }

    private Object applySourceInterceptor(Object bean, SimpleMessageSourceMetrics interceptor, ClassLoader beanClassLoader) {
        NameMatchMethodPointcutAdvisor sourceAdvice = new NameMatchMethodPointcutAdvisor((Advice)interceptor);
        sourceAdvice.addMethodName("receive");
        return this.applyAdvice(bean, (PointcutAdvisor)sourceAdvice, beanClassLoader);
    }

    private Object extractTarget(Object bean) {
        if (!(bean instanceof Advised)) {
            return bean;
        }
        Advised advised = (Advised)bean;
        if (advised.getTargetSource() == null) {
            return null;
        }
        try {
            return this.extractTarget(advised.getTargetSource().getTarget());
        }
        catch (Exception e) {
            logger.error((Object)"Could not extract target", (Throwable)e);
            return null;
        }
    }

    private Object applyAdvice(Object bean, PointcutAdvisor advisor, ClassLoader beanClassLoader) {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        if (AopUtils.canApply((Pointcut)advisor.getPointcut(), (Class)targetClass)) {
            if (bean instanceof Advised) {
                ((Advised)bean).addAdvisor((Advisor)advisor);
                return bean;
            }
            ProxyFactory proxyFactory = new ProxyFactory(bean);
            proxyFactory.addAdvisor((Advisor)advisor);
            return proxyFactory.getProxy(beanClassLoader);
        }
        return bean;
    }

    private String getChannelBeanKey(String channel) {
        String name = "" + channel;
        if (name.startsWith(DEFAULT_DOMAIN)) {
            name = name + ",source=anonymous";
        }
        return String.format(this.domain + ":type=MessageChannel,name=%s" + this.getStaticNames(), name);
    }

    private String getHandlerBeanKey(MessageHandlerMetrics handler) {
        return String.format(this.domain + ":type=MessageHandler,name=%s,bean=%s" + this.getStaticNames(), handler.getName(), handler.getSource());
    }

    private String getSourceBeanKey(MessageSourceMetrics handler) {
        return String.format(this.domain + ":type=MessageSource,name=%s,bean=%s" + this.getStaticNames(), handler.getName(), handler.getSource());
    }

    private String getEndpointBeanKey(AbstractEndpoint endpoint, String name, String source) {
        return String.format(this.domain + ":type=ManagedEndpoint,name=%s,bean=%s" + this.getStaticNames(), name, source);
    }

    private String getMonitoredIntegrationObjectBeanKey(Object object, String name) {
        return String.format(this.domain + ":type=" + object.getClass().getSimpleName() + ",name=%s" + this.getStaticNames(), name);
    }

    private String getStaticNames() {
        if (this.objectNameStaticProperties.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Object key : this.objectNameStaticProperties.keySet()) {
            builder.append("," + key + "=" + this.objectNameStaticProperties.get(key));
        }
        return builder.toString();
    }

    private MessageHandlerMetrics enhanceHandlerMonitor(SimpleMessageHandlerMetrics monitor) {
        MessageHandlerMetrics result = monitor;
        if (monitor.getName() != null && monitor.getSource() != null) {
            return monitor;
        }
        String[] names = this.beanFactory.getBeanNamesForType(AbstractEndpoint.class);
        String name = null;
        String endpointName = null;
        String source = "endpoint";
        Object endpoint = null;
        MessageHandler messageHandler = monitor.getMessageHandler();
        for (String beanName : names) {
            endpoint = this.beanFactory.getBean(beanName);
            try {
                Object field = this.extractTarget(IntegrationMBeanExporter.getField(endpoint, "handler"));
                if (field != messageHandler && this.extractTarget(this.handlerInAnonymousWrapper(field)) != messageHandler) continue;
                name = beanName;
                endpointName = beanName;
                break;
            }
            catch (Exception e) {
                logger.trace((Object)("Could not get handler from bean = " + beanName));
            }
        }
        if (name != null && endpoint != null && name.startsWith("_org.springframework.integration")) {
            name = this.getInternalComponentName(name);
            source = "internal";
        }
        if (name != null && endpoint != null && name.startsWith(DEFAULT_DOMAIN)) {
            Object field;
            TargetSource targetSource;
            Object target = endpoint;
            if (endpoint instanceof Advised && (targetSource = ((Advised)endpoint).getTargetSource()) != null) {
                try {
                    target = targetSource.getTarget();
                }
                catch (Exception e) {
                    logger.debug((Object)("Could not get handler from bean = " + name));
                }
            }
            if ((field = IntegrationMBeanExporter.getField(target, "inputChannel")) != null) {
                if (!this.anonymousHandlerCounters.containsKey(field)) {
                    this.anonymousHandlerCounters.put(field, new AtomicLong());
                }
                AtomicLong count = this.anonymousHandlerCounters.get(field);
                long total = count.incrementAndGet();
                String suffix = "";
                if (total > 1L) {
                    suffix = "#" + total;
                }
                name = field + suffix;
                source = "anonymous";
            }
        }
        if (endpoint instanceof Lifecycle) {
            result = new LifecycleMessageHandlerMetrics((Lifecycle)endpoint, monitor);
        }
        if (name == null) {
            if (messageHandler instanceof NamedComponent) {
                name = ((NamedComponent)messageHandler).getComponentName();
            }
            if (name == null) {
                name = messageHandler.toString();
            }
            source = "handler";
        }
        if (endpointName != null) {
            this.beansByEndpointName.put(name, endpointName);
        }
        monitor.setSource(source);
        monitor.setName(name);
        return result;
    }

    private String getInternalComponentName(String name) {
        return name.substring("_org.springframework.integration".length() + 1);
    }

    private MessageSourceMetrics enhanceSourceMonitor(SimpleMessageSourceMetrics monitor) {
        MessageSourceMetrics result = monitor;
        if (monitor.getName() != null && monitor.getSource() != null) {
            return monitor;
        }
        String[] names = this.beanFactory.getBeanNamesForType(AbstractEndpoint.class);
        String name = null;
        String endpointName = null;
        String source = "endpoint";
        Object endpoint = null;
        for (String beanName : names) {
            endpoint = this.beanFactory.getBean(beanName);
            Object field = null;
            try {
                field = this.extractTarget(IntegrationMBeanExporter.getField(endpoint, "source"));
            }
            catch (Exception e) {
                logger.trace((Object)("Could not get source from bean = " + beanName));
            }
            if (field != monitor.getMessageSource()) continue;
            name = beanName;
            endpointName = beanName;
            break;
        }
        if (name != null && endpoint != null && name.startsWith("_org.springframework.integration")) {
            name = this.getInternalComponentName(name);
            source = "internal";
        }
        if (name != null && endpoint != null && name.startsWith(DEFAULT_DOMAIN)) {
            Object field;
            TargetSource targetSource;
            Object target = endpoint;
            if (endpoint instanceof Advised && (targetSource = ((Advised)endpoint).getTargetSource()) != null) {
                try {
                    target = targetSource.getTarget();
                }
                catch (Exception e) {
                    logger.debug((Object)("Could not get handler from bean = " + name));
                }
            }
            if ((field = IntegrationMBeanExporter.getField(target, "outputChannel")) != null) {
                if (!this.anonymousSourceCounters.containsKey(field)) {
                    this.anonymousSourceCounters.put(field, new AtomicLong());
                }
                AtomicLong count = this.anonymousSourceCounters.get(field);
                long total = count.incrementAndGet();
                String suffix = "";
                if (total > 1L) {
                    suffix = "#" + total;
                }
                name = field + suffix;
                source = "anonymous";
            }
        }
        if (endpoint instanceof Lifecycle) {
            result = new LifecycleMessageSourceMetrics((Lifecycle)endpoint, monitor);
        }
        if (name == null) {
            name = monitor.getMessageSource().toString();
            source = "handler";
        }
        if (endpointName != null) {
            this.beansByEndpointName.put(name, endpointName);
        }
        monitor.setSource(source);
        monitor.setName(name);
        return result;
    }

    private static Object getField(Object target, String name) {
        Assert.notNull((Object)target, (String)"Target object must not be null");
        Field field = ReflectionUtils.findField(target.getClass(), (String)name);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + name + "] on target [" + target + "]");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting field [" + name + "] from target [" + target + "]"));
        }
        ReflectionUtils.makeAccessible((Field)field);
        return ReflectionUtils.getField((Field)field, (Object)target);
    }
}

