/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.monitor;

import java.util.concurrent.atomic.AtomicInteger;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.monitor.DirectChannelMetrics;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.support.MetricType;

public class PollableChannelMetrics
extends DirectChannelMetrics {
    private final AtomicInteger receiveCount = new AtomicInteger();
    private final AtomicInteger receiveErrorCount = new AtomicInteger();

    public PollableChannelMetrics(MessageChannel messageChannel, String name) {
        super(messageChannel, name);
    }

    protected Object doInvoke(MethodInvocation invocation, String method, MessageChannel channel) throws Throwable {
        if ("receive".equals(method)) {
            return this.monitorReceive(invocation, channel);
        }
        return super.doInvoke(invocation, method, channel);
    }

    private Object monitorReceive(MethodInvocation invocation, MessageChannel channel) throws Throwable {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Recording receive on channel(" + channel + ") "));
        }
        try {
            Object object = invocation.proceed();
            if (object != null) {
                this.receiveCount.incrementAndGet();
            }
            return object;
        }
        catch (Throwable e) {
            this.receiveErrorCount.incrementAndGet();
            throw e;
        }
    }

    @ManagedOperation
    public synchronized void reset() {
        super.reset();
        this.receiveErrorCount.set(0);
        this.receiveCount.set(0);
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="MessageChannel Receive Count")
    public int getReceiveCount() {
        return this.receiveCount.get();
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="MessageChannel Receive Error Count")
    public int getReceiveErrorCount() {
        return this.receiveErrorCount.get();
    }

    public String toString() {
        return String.format("MessageChannelMonitor: [name=%s, sends=%d, receives=%d]", this.getName(), this.getSendCount(), this.receiveCount.get());
    }
}

