/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms.channel;

import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.MessageDispatchingException;
import org.springframework.integration.channel.BroadcastCapableChannel;
import org.springframework.integration.dispatcher.AbstractDispatcher;
import org.springframework.integration.dispatcher.BroadcastingDispatcher;
import org.springframework.integration.dispatcher.LoadBalancingStrategy;
import org.springframework.integration.dispatcher.MessageDispatcher;
import org.springframework.integration.dispatcher.RoundRobinLoadBalancingStrategy;
import org.springframework.integration.dispatcher.UnicastingDispatcher;
import org.springframework.integration.jms.channel.AbstractJmsChannel;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.management.ManageableSmartLifecycle;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public class SubscribableJmsChannel
extends AbstractJmsChannel
implements BroadcastCapableChannel,
ManageableSmartLifecycle {
    private final AbstractMessageListenerContainer container;
    private volatile AbstractDispatcher dispatcher;
    private volatile boolean initialized;
    private volatile Integer maxSubscribers;

    public SubscribableJmsChannel(AbstractMessageListenerContainer container, JmsTemplate jmsTemplate) {
        super(jmsTemplate);
        Assert.notNull((Object)container, (String)"container must not be null");
        this.container = container;
    }

    public void setMaxSubscribers(int maxSubscribers) {
        this.maxSubscribers = maxSubscribers;
    }

    public boolean subscribe(MessageHandler handler) {
        Assert.state((this.dispatcher != null ? 1 : 0) != 0, (String)"'MessageDispatcher' must not be null. This channel might not have been initialized");
        return this.dispatcher.addHandler(handler);
    }

    public boolean unsubscribe(MessageHandler handler) {
        Assert.state((this.dispatcher != null ? 1 : 0) != 0, (String)"'MessageDispatcher' must not be null. This channel might not have been initialized");
        return this.dispatcher.removeHandler(handler);
    }

    public boolean isBroadcast() {
        return this.container.isPubSubDomain();
    }

    public void onInit() {
        if (this.initialized) {
            return;
        }
        super.onInit();
        boolean isPubSub = this.isBroadcast();
        this.configureDispatcher(isPubSub);
        DispatchingMessageListener listener = new DispatchingMessageListener(this.getJmsTemplate(), (MessageDispatcher)this.dispatcher, this, isPubSub, this.getMessageBuilderFactory());
        this.container.setMessageListener((Object)listener);
        if (!this.container.isActive()) {
            this.container.afterPropertiesSet();
        }
        this.initialized = true;
    }

    private void configureDispatcher(boolean isPubSub) {
        if (isPubSub) {
            BroadcastingDispatcher broadcastingDispatcher = new BroadcastingDispatcher(true);
            broadcastingDispatcher.setBeanFactory(this.getBeanFactory());
            this.dispatcher = broadcastingDispatcher;
        } else {
            UnicastingDispatcher unicastingDispatcher = new UnicastingDispatcher();
            unicastingDispatcher.setLoadBalancingStrategy((LoadBalancingStrategy)new RoundRobinLoadBalancingStrategy());
            this.dispatcher = unicastingDispatcher;
        }
        if (this.maxSubscribers == null) {
            this.maxSubscribers = isPubSub ? this.getIntegrationProperties().getChannelsMaxBroadcastSubscribers() : this.getIntegrationProperties().getChannelsMaxUnicastSubscribers();
        }
        this.dispatcher.setMaxSubscribers(this.maxSubscribers.intValue());
    }

    public boolean isAutoStartup() {
        return this.container != null && this.container.isAutoStartup();
    }

    public int getPhase() {
        return this.container != null ? this.container.getPhase() : 0;
    }

    public boolean isRunning() {
        return this.container != null && this.container.isRunning();
    }

    public void start() {
        if (this.container != null) {
            this.container.start();
        }
    }

    public void stop() {
        if (this.container != null) {
            this.container.stop();
        }
    }

    public void stop(Runnable callback) {
        if (this.container != null) {
            this.container.stop(callback);
        } else {
            callback.run();
        }
    }

    public void destroy() {
        if (this.container != null) {
            this.container.destroy();
        }
    }

    private static final class DispatchingMessageListener
    implements MessageListener {
        private final Log logger = LogFactory.getLog(this.getClass());
        private final JmsTemplate jmsTemplate;
        private final MessageDispatcher dispatcher;
        private final SubscribableJmsChannel channel;
        private final boolean isPubSub;
        private final MessageBuilderFactory messageBuilderFactory;

        DispatchingMessageListener(JmsTemplate jmsTemplate, MessageDispatcher dispatcher, SubscribableJmsChannel channel, boolean isPubSub, MessageBuilderFactory messageBuilderFactory) {
            this.jmsTemplate = jmsTemplate;
            this.dispatcher = dispatcher;
            this.channel = channel;
            this.isPubSub = isPubSub;
            this.messageBuilderFactory = messageBuilderFactory;
        }

        public void onMessage(Message message) {
            org.springframework.messaging.Message messageToSend = null;
            try {
                MessageConverter converter = this.jmsTemplate.getMessageConverter();
                Object converted = null;
                if (converter != null) {
                    converted = converter.fromMessage(message);
                }
                if (converted != null) {
                    org.springframework.messaging.Message convertedMessage;
                    messageToSend = converted instanceof org.springframework.messaging.Message ? (convertedMessage = (org.springframework.messaging.Message)converted) : this.messageBuilderFactory.withPayload(converted).build();
                    this.dispatcher.dispatch(messageToSend);
                } else if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("No converter found, or converter returned null for: " + String.valueOf(message) + ", no Message to dispatch"));
                }
            }
            catch (MessageDispatchingException ex) {
                String exceptionMessage = ex.getMessage() + " for jms-channel '" + this.channel.getFullChannelName() + "'.";
                if (this.isPubSub) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn((Object)exceptionMessage, (Throwable)ex);
                    }
                }
                throw new MessageDeliveryException(messageToSend, exceptionMessage, (Throwable)ex);
            }
            catch (Exception ex) {
                throw new MessagingException("failed to handle incoming JMS Message", (Throwable)ex);
            }
        }
    }
}

