/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.ExpressionFactoryBean;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class JmsOutboundGatewayParser
extends AbstractConsumerEndpointParser {
    protected String getInputChannelAttributeName() {
        return "request-channel";
    }

    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.jms.JmsOutboundGateway");
        builder.addPropertyReference("connectionFactory", element.getAttribute("connection-factory"));
        String requestDestination = element.getAttribute("request-destination");
        String requestDestinationName = element.getAttribute("request-destination-name");
        String requestDestinationExpression = element.getAttribute("request-destination-expression");
        boolean hasRequestDestination = StringUtils.hasText((String)requestDestination);
        boolean hasRequestDestinationName = StringUtils.hasText((String)requestDestinationName);
        boolean hasRequestDestinationExpression = StringUtils.hasText((String)requestDestinationExpression);
        if (!(hasRequestDestination ^ hasRequestDestinationName ^ hasRequestDestinationExpression)) {
            parserContext.getReaderContext().error("Exactly one of the 'request-destination', 'request-destination-name', or 'request-destination-expression' attributes is required.", (Object)element);
        }
        if (hasRequestDestination) {
            builder.addPropertyReference("requestDestination", requestDestination);
        } else if (hasRequestDestinationName) {
            builder.addPropertyValue("requestDestinationName", (Object)requestDestinationName);
        } else if (hasRequestDestinationExpression) {
            BeanDefinitionBuilder expressionBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExpressionFactoryBean.class);
            expressionBuilder.addConstructorArgValue((Object)requestDestinationExpression);
            builder.addPropertyValue("requestDestinationExpression", (Object)expressionBuilder.getBeanDefinition());
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-destination");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-destination-name");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-channel");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"correlation-key");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"message-converter");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"header-mapper");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"destination-resolver");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"extract-request-payload");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"extract-reply-payload");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"receive-timeout");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-timeout", (String)"sendTimeout");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"request-pub-sub-domain");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-pub-sub-domain");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"time-to-live");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"priority");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"explicit-qos-enabled");
        String deliveryMode = element.getAttribute("delivery-mode");
        String deliveryPersistent = element.getAttribute("delivery-persistent");
        if (StringUtils.hasText((String)deliveryMode) && StringUtils.hasText((String)deliveryPersistent)) {
            parserContext.getReaderContext().error("The 'delivery-mode' and 'delivery-persistent' attributes are mutually exclusive.", (Object)element);
            return null;
        }
        if (StringUtils.hasText((String)deliveryMode)) {
            parserContext.getReaderContext().warning("The 'delivery-mode' attribute is deprecated. Use 'delivery-persistent' instead.", (Object)element);
            builder.addPropertyValue("deliveryMode", (Object)deliveryMode);
        } else if (StringUtils.hasText((String)deliveryPersistent)) {
            builder.addPropertyValue("deliveryPersistent", (Object)deliveryPersistent);
        }
        return builder;
    }
}

