/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.integration.jdbc.ExpressionEvaluatingSqlParameterSourceFactory;
import org.springframework.integration.jdbc.SqlParameterSourceFactory;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlProvider;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.Assert;

public class JdbcPollingChannelAdapter
extends AbstractMessageSource<Object> {
    private final NamedParameterJdbcOperations jdbcOperations;
    private RowMapper<?> rowMapper;
    private @Nullable SqlParameterSource sqlQueryParameterSource;
    private boolean updatePerRow = false;
    private SqlParameterSourceFactory sqlParameterSourceFactory = new ExpressionEvaluatingSqlParameterSourceFactory();
    private boolean sqlParameterSourceFactorySet;
    private int maxRows = 0;
    private volatile String selectQuery;
    private volatile @Nullable String updateSql;

    public JdbcPollingChannelAdapter(DataSource dataSource, String selectQuery) {
        this((JdbcOperations)new JdbcTemplate(dataSource), selectQuery);
    }

    public JdbcPollingChannelAdapter(JdbcOperations jdbcOperations, String selectQuery) {
        this.jdbcOperations = new NamedParameterJdbcTemplate(jdbcOperations){

            protected PreparedStatementCreator getPreparedStatementCreator(String sql, SqlParameterSource paramSource, @Nullable Consumer<PreparedStatementCreatorFactory> customizer) {
                PreparedStatementCreator preparedStatementCreator = super.getPreparedStatementCreator(sql, paramSource, customizer);
                return new PreparedStatementCreatorWithMaxRows(preparedStatementCreator, JdbcPollingChannelAdapter.this.maxRows);
            }
        };
        this.setSelectQuery(selectQuery);
        this.rowMapper = new ColumnMapRowMapper();
    }

    public void setRowMapper(@Nullable RowMapper<?> rowMapper) {
        this.rowMapper = Objects.requireNonNullElseGet(rowMapper, ColumnMapRowMapper::new);
    }

    public final void setSelectQuery(String selectQuery) {
        Assert.hasText((String)selectQuery, (String)"'selectQuery' must be specified.");
        this.selectQuery = selectQuery;
    }

    public void setUpdateSql(String updateSql) {
        this.updateSql = updateSql;
    }

    public void setUpdatePerRow(boolean updatePerRow) {
        this.updatePerRow = updatePerRow;
    }

    public void setUpdateSqlParameterSourceFactory(SqlParameterSourceFactory sqlParameterSourceFactory) {
        Assert.notNull((Object)sqlParameterSourceFactory, (String)"'sqlParameterSourceFactory' must be null.");
        this.sqlParameterSourceFactory = sqlParameterSourceFactory;
        this.sqlParameterSourceFactorySet = true;
    }

    public void setSelectSqlParameterSource(@Nullable SqlParameterSource sqlQueryParameterSource) {
        this.sqlQueryParameterSource = sqlQueryParameterSource;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    protected void onInit() {
        BeanFactory beanFactory = this.getBeanFactory();
        if (!this.sqlParameterSourceFactorySet && beanFactory != null) {
            ((ExpressionEvaluatingSqlParameterSourceFactory)this.sqlParameterSourceFactory).setBeanFactory(beanFactory);
        }
    }

    public String getComponentType() {
        return "jdbc:inbound-channel-adapter";
    }

    protected @Nullable Object doReceive() {
        List<?> payload = this.doPoll(this.sqlQueryParameterSource);
        if (payload.isEmpty()) {
            payload = null;
        }
        if (payload != null && this.updateSql != null) {
            if (this.updatePerRow) {
                for (Object row : payload) {
                    this.executeUpdateQuery(row);
                }
            } else {
                this.executeUpdateQuery(payload);
            }
        }
        return payload;
    }

    protected List<?> doPoll(@Nullable SqlParameterSource sqlQueryParameterSource) {
        if (sqlQueryParameterSource != null) {
            return this.jdbcOperations.query(this.selectQuery, sqlQueryParameterSource, this.rowMapper);
        }
        return this.jdbcOperations.query(this.selectQuery, this.rowMapper);
    }

    private void executeUpdateQuery(Object obj) {
        this.jdbcOperations.update(this.updateSql, this.sqlParameterSourceFactory.createParameterSource(obj));
    }

    private record PreparedStatementCreatorWithMaxRows(PreparedStatementCreator delegate, int maxRows) implements PreparedStatementCreator,
    PreparedStatementSetter,
    SqlProvider,
    ParameterDisposer
    {
        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
            PreparedStatement preparedStatement = this.delegate.createPreparedStatement(con);
            preparedStatement.setMaxRows(this.maxRows);
            return preparedStatement;
        }

        public @Nullable String getSql() {
            if (this.delegate instanceof SqlProvider) {
                return ((SqlProvider)this.delegate).getSql();
            }
            return null;
        }

        public void setValues(PreparedStatement ps) throws SQLException {
            if (this.delegate instanceof PreparedStatementSetter) {
                ((PreparedStatementSetter)this.delegate).setValues(ps);
            }
        }

        public void cleanupParameters() {
            if (this.delegate instanceof ParameterDisposer) {
                ((ParameterDisposer)this.delegate).cleanupParameters();
            }
        }
    }
}

