/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.udp.inbound;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationEvent;
import org.springframework.integration.ip.udp.DatagramPacketMessageMapper;
import org.springframework.integration.ip.udp.SocketCustomizer;
import org.springframework.integration.ip.udp.UdpServerListeningEvent;
import org.springframework.integration.ip.udp.inbound.AbstractInternetProtocolReceivingChannelAdapter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public class UnicastReceivingChannelAdapter
extends AbstractInternetProtocolReceivingChannelAdapter {
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("([^:]*):([0-9]*)");
    private final DatagramPacketMessageMapper mapper = new DatagramPacketMessageMapper();
    protected final Lock lock = new ReentrantLock();
    private @Nullable DatagramSocket socket;
    private boolean socketExplicitlySet;
    private int soSendBufferSize = -1;
    private SocketCustomizer socketCustomizer;

    public UnicastReceivingChannelAdapter(int port) {
        super(port);
        this.socketCustomizer = aSocket -> {};
        this.mapper.setLengthCheck(false);
    }

    public UnicastReceivingChannelAdapter(int port, boolean lengthCheck) {
        super(port);
        this.socketCustomizer = aSocket -> {};
        this.mapper.setLengthCheck(lengthCheck);
    }

    public void setLengthCheck(boolean lengthCheck) {
        this.mapper.setLengthCheck(lengthCheck);
    }

    public void setSocketCustomizer(SocketCustomizer socketCustomizer) {
        Assert.notNull((Object)socketCustomizer, (String)"'socketCustomizer' cannot be null");
        this.socketCustomizer = socketCustomizer;
    }

    public boolean isLongLived() {
        return true;
    }

    @Override
    public int getPort() {
        if (this.socket == null) {
            return super.getPort();
        }
        return this.socket.getLocalPort();
    }

    protected void onInit() {
        super.onInit();
        this.mapper.setBeanFactory(this.getBeanFactory());
    }

    public void run() {
        this.getSocket();
        this.getApplicationEventPublisher().publishEvent((ApplicationEvent)new UdpServerListeningEvent((Object)this, this.getPort()));
        this.logger.debug(() -> "UDP Receiver running on port: " + this.getPort());
        this.setListening(true);
        while (this.isActive()) {
            try {
                this.asyncSendMessage(this.receive());
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (SocketException ex) {
                this.stop();
            }
            catch (Exception ex) {
                if (ex instanceof MessagingException) {
                    MessagingException messagingException = (MessagingException)ex;
                    throw messagingException;
                }
                throw new MessagingException("failed to receive DatagramPacket", (Throwable)ex);
            }
        }
        this.setListening(false);
    }

    protected void sendAck(Message<byte[]> message) {
        MessageHeaders headers = message.getHeaders();
        Object id = headers.get((Object)"ip_ackId");
        if (id == null) {
            this.logger.error(() -> "No ip_ackId header; cannot send ack");
            return;
        }
        byte[] ack = id.toString().getBytes();
        String ackAddress = Objects.requireNonNull((String)headers.get((Object)"ip_ackTo", String.class)).trim();
        Matcher mat = ADDRESS_PATTERN.matcher(ackAddress);
        if (!mat.matches()) {
            throw new MessagingException(message, "Ack requested but could not decode acknowledgment address: " + ackAddress);
        }
        String host = mat.group(1);
        int port = Integer.parseInt(mat.group(2));
        InetSocketAddress whereTo = new InetSocketAddress(host, port);
        this.logger.debug(() -> "Sending ack for " + String.valueOf(id) + " to " + ackAddress);
        try {
            DatagramPacket ackPack = new DatagramPacket(ack, ack.length, whereTo);
            DatagramSocket out = new DatagramSocket();
            if (this.soSendBufferSize > 0) {
                out.setSendBufferSize(this.soSendBufferSize);
            }
            this.socketCustomizer.configure(out);
            out.send(ackPack);
            out.close();
        }
        catch (IOException ex) {
            throw new MessagingException(message, "Failed to send acknowledgment to: " + ackAddress, (Throwable)ex);
        }
    }

    protected boolean asyncSendMessage(DatagramPacket packet) {
        Executor taskExecutor = this.getTaskExecutor();
        if (taskExecutor != null) {
            try {
                taskExecutor.execute(() -> this.doSend(packet));
            }
            catch (RejectedExecutionException ex) {
                this.logger.debug((CharSequence)"Adapter stopped, sending on main thread");
                this.doSend(packet);
            }
        }
        return true;
    }

    protected void doSend(DatagramPacket packet) {
        Message<byte[]> message = null;
        try {
            Message<byte[]> messageToLog = message = this.mapper.toMessage(packet);
            this.logger.debug(() -> "Received: " + String.valueOf(messageToLog));
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex, (CharSequence)"Failed to map packet to message ");
        }
        if (message != null) {
            if (message.getHeaders().containsKey((Object)"ip_ackTo")) {
                this.sendAck(message);
            }
            try {
                this.sendMessage(message);
            }
            catch (Exception ex) {
                this.logger.error((Throwable)ex, (CharSequence)("Failed to send message " + String.valueOf(message)));
            }
        }
    }

    protected DatagramPacket receive() throws IOException {
        byte[] buffer = new byte[this.getReceiveBufferSize()];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        this.getSocket().receive(packet);
        return packet;
    }

    public void setSocket(DatagramSocket socket) {
        this.socket = socket;
        this.socketExplicitlySet = true;
    }

    protected @Nullable DatagramSocket getTheSocket() {
        return this.socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramSocket getSocket() {
        this.lock.lock();
        try {
            if (this.socket == null) {
                try {
                    DatagramSocket datagramSocket;
                    String localAddress = this.getLocalAddress();
                    int port = super.getPort();
                    if (localAddress == null) {
                        datagramSocket = new DatagramSocket(port);
                    } else {
                        InetAddress whichNic = InetAddress.getByName(localAddress);
                        datagramSocket = new DatagramSocket(new InetSocketAddress(whichNic, port));
                    }
                    this.setSocketAttributes(datagramSocket);
                    this.socket = datagramSocket;
                }
                catch (IOException ex) {
                    throw new MessagingException("failed to create DatagramSocket", (Throwable)ex);
                }
            }
            DatagramSocket datagramSocket = this.socket;
            return datagramSocket;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void setSocketAttributes(DatagramSocket socket) throws SocketException {
        socket.setSoTimeout(this.getSoTimeout());
        int soReceiveBufferSize = this.getSoReceiveBufferSize();
        if (soReceiveBufferSize > 0) {
            socket.setReceiveBufferSize(soReceiveBufferSize);
        }
        this.socketCustomizer.configure(socket);
    }

    @Override
    public void setSoSendBufferSize(int soSendBufferSize) {
        this.soSendBufferSize = soSendBufferSize;
    }

    public void setLookupHost(boolean lookupHost) {
        this.mapper.setLookupHost(lookupHost);
    }

    public String getComponentType() {
        return "ip:udp-inbound-channel-adapter";
    }

    @Override
    protected void doStop() {
        super.doStop();
        try {
            DatagramSocket datagramSocket = this.socket;
            if (!this.socketExplicitlySet) {
                this.socket = null;
            }
            if (datagramSocket != null) {
                datagramSocket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

