/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.connection;

import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.ip.tcp.connection.SocketInfo;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.mapping.BytesMessageMapper;
import org.springframework.integration.mapping.InboundMessageMapper;
import org.springframework.integration.mapping.OutboundMessageMapper;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.MutableMessageHeaders;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;
import org.springframework.util.InvalidMimeTypeException;
import org.springframework.util.MimeType;

public class TcpMessageMapper
implements InboundMessageMapper<TcpConnection>,
OutboundMessageMapper<Object>,
BeanFactoryAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String charset = "UTF-8";
    private boolean stringToBytes = true;
    private boolean applySequence = false;
    private MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();
    private boolean messageBuilderFactorySet;
    private String contentType = "application/octet-stream;charset=" + this.charset;
    private boolean addContentTypeHeader;
    private BeanFactory beanFactory;
    private BytesMessageMapper bytesMessageMapper;

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setStringToBytes(boolean stringToBytes) {
        this.stringToBytes = stringToBytes;
    }

    public void setApplySequence(boolean applySequence) {
        this.applySequence = applySequence;
    }

    public void setContentType(String contentType) {
        Assert.notNull((Object)contentType, (String)"'contentType' cannot be null");
        try {
            MimeType.valueOf((String)contentType);
        }
        catch (InvalidMimeTypeException e) {
            throw new IllegalArgumentException("'contentType' could not be parsed", e);
        }
        this.contentType = contentType;
    }

    public void setAddContentTypeHeader(boolean addContentTypeHeader) {
        this.addContentTypeHeader = addContentTypeHeader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setBytesMessageMapper(BytesMessageMapper bytesMessageMapper) {
        this.bytesMessageMapper = bytesMessageMapper;
    }

    protected MessageBuilderFactory getMessageBuilderFactory() {
        if (!this.messageBuilderFactorySet) {
            if (this.beanFactory != null) {
                this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory((BeanFactory)this.beanFactory);
            }
            this.messageBuilderFactorySet = true;
        }
        return this.messageBuilderFactory;
    }

    public Message<?> toMessage(TcpConnection connection, @Nullable Map<String, Object> headers) {
        Message message = null;
        Object payload = connection.getPayload();
        if (payload != null) {
            AbstractIntegrationMessageBuilder messageBuilder = this.bytesMessageMapper != null && payload instanceof byte[] ? this.getMessageBuilderFactory().fromMessage(this.bytesMessageMapper.toMessage((byte[])payload)) : this.getMessageBuilderFactory().withPayload(payload);
            MutableMessageHeaders messageHeaders = new MutableMessageHeaders(null);
            this.addStandardHeaders(connection, (MessageHeaders)messageHeaders);
            this.addCustomHeaders(connection, (MessageHeaders)messageHeaders);
            message = messageBuilder.copyHeaders((Map)messageHeaders).copyHeadersIfAbsent(headers).build();
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Null payload from connection " + connection.getConnectionId()));
        }
        return message;
    }

    protected final void addStandardHeaders(TcpConnection connection, MessageHeaders messageHeaders) {
        String connectionId = connection.getConnectionId();
        messageHeaders.put("ip_hostname", (Object)connection.getHostName());
        messageHeaders.put("ip_address", (Object)connection.getHostAddress());
        messageHeaders.put("ip_tcp_remotePort", (Object)connection.getPort());
        messageHeaders.put("ip_connectionId", (Object)connectionId);
        SocketInfo socketInfo = connection.getSocketInfo();
        if (socketInfo != null) {
            messageHeaders.put("ip_localInetAddress", (Object)socketInfo.getLocalAddress());
        }
        if (this.applySequence) {
            messageHeaders.put("correlationId", (Object)connectionId);
            messageHeaders.put("sequenceNumber", (Object)connection.incrementAndGetConnectionSequence());
        }
        if (this.addContentTypeHeader) {
            messageHeaders.put("contentType", (Object)this.contentType);
        }
    }

    protected final void addCustomHeaders(TcpConnection connection, MessageHeaders messageHeaders) {
        Map<String, ?> customHeaders = this.supplyCustomHeaders(connection);
        if (customHeaders != null) {
            customHeaders.forEach((arg_0, arg_1) -> messageHeaders.putIfAbsent(arg_0, arg_1));
        }
    }

    @Nullable
    protected Map<String, ?> supplyCustomHeaders(TcpConnection connection) {
        return null;
    }

    public Object fromMessage(Message<?> message) {
        if (this.bytesMessageMapper != null) {
            return this.bytesMessageMapper.fromMessage(message);
        }
        if (this.stringToBytes) {
            return this.getPayloadAsBytes(message);
        }
        return message.getPayload();
    }

    private byte[] getPayloadAsBytes(Message<?> message) {
        byte[] bytes = null;
        Object payload = message.getPayload();
        if (payload instanceof byte[]) {
            bytes = (byte[])payload;
        } else if (payload instanceof String) {
            try {
                bytes = ((String)payload).getBytes(this.charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new UncheckedIOException(e);
            }
        } else {
            throw new IllegalArgumentException("When using a byte array serializer, the socket mapper expects either a byte array or String payload, but received: " + String.valueOf(payload.getClass()));
        }
        return bytes;
    }
}

