/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.integration.context.OrderlyShutdownCapable;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.ip.tcp.connection.AbstractClientConnectionFactory;
import org.springframework.integration.ip.tcp.connection.AbstractConnectionFactory;
import org.springframework.integration.ip.tcp.connection.AbstractServerConnectionFactory;
import org.springframework.integration.ip.tcp.connection.ClientModeCapable;
import org.springframework.integration.ip.tcp.connection.ClientModeConnectionManager;
import org.springframework.integration.ip.tcp.connection.ConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;

public class TcpReceivingChannelAdapter
extends MessageProducerSupport
implements TcpListener,
ClientModeCapable,
OrderlyShutdownCapable {
    private AbstractConnectionFactory clientConnectionFactory;
    private AbstractConnectionFactory serverConnectionFactory;
    private volatile boolean isSingleUse;
    private volatile boolean isClientMode;
    private volatile long retryInterval = 60000L;
    private volatile ScheduledFuture<?> scheduledFuture;
    private volatile ClientModeConnectionManager clientModeConnectionManager;
    private volatile boolean shuttingDown;
    private final AtomicInteger activeCount = new AtomicInteger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onMessage(Message<?> message) {
        boolean isErrorMessage = message instanceof ErrorMessage;
        try {
            if (this.shuttingDown) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Inbound message ignored; shutting down; " + message.toString()));
                }
            } else {
                if (isErrorMessage) {
                    boolean bl = false;
                    return bl;
                }
                this.activeCount.incrementAndGet();
                try {
                    this.sendMessage(message);
                }
                finally {
                    this.activeCount.decrementAndGet();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            String connectionId = (String)message.getHeaders().get((Object)"ip_connectionId");
            if (connectionId != null && !isErrorMessage && this.isSingleUse) {
                if (this.serverConnectionFactory != null) {
                    if (this.serverConnectionFactory.getSender() == null) {
                        this.serverConnectionFactory.closeConnection(connectionId);
                    }
                } else {
                    this.clientConnectionFactory.closeConnection(connectionId);
                }
            }
        }
    }

    protected void onInit() {
        super.onInit();
        if (this.isClientMode) {
            Assert.notNull((Object)this.clientConnectionFactory, (String)"For client-mode, connection factory must be type='client'");
            Assert.isTrue((!this.clientConnectionFactory.isSingleUse() ? 1 : 0) != 0, (String)"For client-mode, connection factory must have single-use='false'");
        }
    }

    protected void doStart() {
        this.shuttingDown = false;
        if (this.serverConnectionFactory != null) {
            this.serverConnectionFactory.start();
        }
        if (this.clientConnectionFactory != null) {
            this.clientConnectionFactory.start();
        }
        if (this.isClientMode) {
            ClientModeConnectionManager manager;
            this.clientModeConnectionManager = manager = new ClientModeConnectionManager(this.clientConnectionFactory);
            TaskScheduler taskScheduler = this.getTaskScheduler();
            Assert.state((taskScheduler != null ? 1 : 0) != 0, (String)"Client mode requires a task scheduler");
            this.scheduledFuture = taskScheduler.scheduleAtFixedRate((Runnable)manager, this.retryInterval);
        }
    }

    protected void doStop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        this.clientModeConnectionManager = null;
        if (this.clientConnectionFactory != null) {
            this.clientConnectionFactory.stop();
        }
        if (this.serverConnectionFactory != null) {
            this.serverConnectionFactory.stop();
        }
    }

    public void setConnectionFactory(AbstractConnectionFactory connectionFactory) {
        if (connectionFactory instanceof AbstractClientConnectionFactory) {
            this.clientConnectionFactory = connectionFactory;
        } else {
            this.serverConnectionFactory = connectionFactory;
        }
        connectionFactory.registerListener(this);
        this.isSingleUse = connectionFactory.isSingleUse();
    }

    public boolean isListening() {
        if (this.serverConnectionFactory == null) {
            return false;
        }
        if (this.serverConnectionFactory instanceof AbstractServerConnectionFactory) {
            return ((AbstractServerConnectionFactory)this.serverConnectionFactory).isListening();
        }
        return false;
    }

    public String getComponentType() {
        return "ip:tcp-inbound-channel-adapter";
    }

    protected ConnectionFactory getClientConnectionFactory() {
        return this.clientConnectionFactory;
    }

    protected ConnectionFactory getServerConnectionFactory() {
        return this.serverConnectionFactory;
    }

    @Override
    public boolean isClientMode() {
        return this.isClientMode;
    }

    public void setClientMode(boolean isClientMode) {
        this.isClientMode = isClientMode;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    @Override
    public boolean isClientModeConnected() {
        if (this.isClientMode && this.clientModeConnectionManager != null) {
            return this.clientModeConnectionManager.isConnected();
        }
        return false;
    }

    @Override
    public void retryConnection() {
        if (this.isActive() && this.isClientMode && this.clientModeConnectionManager != null) {
            this.clientModeConnectionManager.run();
        }
    }

    public int beforeShutdown() {
        this.shuttingDown = true;
        return this.activeCount.get();
    }

    public int afterShutdown() {
        this.stop();
        return this.activeCount.get();
    }
}

