/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.integration.ip.tcp.connection;


/**
 * @author Gary Russell
 * @since 3.0
 *
 */
public class TcpConnectionCloseEvent extends TcpConnectionEvent {

	private static final long serialVersionUID = 7237316997596598287L;

	public TcpConnectionCloseEvent(TcpConnection connection, String connectionFactoryName) {
		super(connection, connectionFactoryName);
	}

	@Override
	public String toString() {
		return super.toString() + " **CLOSED**";
	}

}
