/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.integration.ip.tcp.serializer.AbstractPooledBufferByteArraySerializer;
import org.springframework.integration.ip.tcp.serializer.SoftEndOfStreamException;
import org.springframework.integration.mapping.MessageMappingException;

public class ByteArrayStxEtxSerializer
extends AbstractPooledBufferByteArraySerializer {
    public static final int STX = 2;
    public static final int ETX = 3;

    @Override
    public byte[] doDeserialize(InputStream inputStream, byte[] buffer) throws IOException {
        int bite = inputStream.read();
        if (bite < 0) {
            throw new SoftEndOfStreamException("Stream closed between payloads");
        }
        int n = 0;
        try {
            if (bite != 2) {
                throw new MessageMappingException("Expected STX to begin message");
            }
            while ((bite = inputStream.read()) != 3) {
                this.checkClosure(bite);
                buffer[n++] = (byte)bite;
                if (n < this.maxMessageSize) continue;
                throw new IOException("ETX not found before max message length: " + this.maxMessageSize);
            }
            return this.copyToSizedArray(buffer, n);
        }
        catch (IOException e) {
            this.publishEvent(e, buffer, n);
            throw e;
        }
        catch (RuntimeException e) {
            this.publishEvent(e, buffer, n);
            throw e;
        }
    }

    public void serialize(byte[] bytes, OutputStream outputStream) throws IOException {
        outputStream.write(2);
        outputStream.write(bytes);
        outputStream.write(3);
    }
}

