/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.serializer;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.integration.ip.tcp.serializer.TcpDeserializationExceptionEvent;

public abstract class AbstractByteArraySerializer
implements Serializer<byte[]>,
Deserializer<byte[]>,
ApplicationEventPublisherAware {
    protected int maxMessageSize = 2048;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ApplicationEventPublisher applicationEventPublisher;

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    protected void checkClosure(int bite) throws IOException {
        if (bite < 0) {
            this.logger.debug((Object)"Socket closed during message assembly");
            throw new IOException("Socket closed during message assembly");
        }
    }

    protected byte[] copyToSizedArray(byte[] buffer, int size) {
        if (size == buffer.length) {
            return buffer;
        }
        byte[] assembledData = new byte[size];
        System.arraycopy(buffer, 0, assembledData, 0, size);
        return assembledData;
    }

    protected void publishEvent(Exception cause, byte[] buffer, int offset) {
        TcpDeserializationExceptionEvent event = new TcpDeserializationExceptionEvent(this, cause, buffer, offset);
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("No event publisher for " + (Object)((Object)event)));
        }
    }
}

