/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.http.HttpRequest;
import org.springframework.integration.http.HttpRequestExecutor;
import org.springframework.integration.http.HttpResponse;

public abstract class AbstractHttpRequestExecutor
implements HttpRequestExecutor {
    protected static final String HTTP_HEADER_ACCEPT_LANGUAGE = "Accept-Language";
    protected static final String HTTP_HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    protected static final String HTTP_HEADER_CONTENT_ENCODING = "Content-Encoding";
    protected static final String HTTP_HEADER_CONTENT_TYPE = "Content-Type";
    protected static final String HTTP_HEADER_CONTENT_LENGTH = "Content-Length";
    protected static final String ENCODING_GZIP = "gzip";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean acceptGzipEncoding = true;

    public void setAcceptGzipEncoding(boolean acceptGzipEncoding) {
        this.acceptGzipEncoding = acceptGzipEncoding;
    }

    public boolean isAcceptGzipEncoding() {
        return this.acceptGzipEncoding;
    }

    public final HttpResponse executeRequest(HttpRequest request) throws Exception {
        if (this.logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("Sending HTTP request to [" + request.getTargetUrl() + "]");
            Integer contentLength = request.getContentLength();
            if (contentLength != null) {
                sb.append(", with size " + contentLength);
            }
            this.logger.debug((Object)sb.toString());
        }
        return this.doExecuteRequest(request);
    }

    protected abstract HttpResponse doExecuteRequest(HttpRequest var1) throws Exception;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DefaultHttpResponse
    implements HttpResponse {
        private final InputStream body;
        private final Map<String, List<String>> headers;

        public DefaultHttpResponse(InputStream body, Map<String, List<String>> headers) {
            this.body = body;
            this.headers = headers != null ? headers : Collections.emptyMap();
        }

        @Override
        public InputStream getBody() {
            return this.body;
        }

        @Override
        public String getFirstHeader(String key) {
            List<String> values = this.headers.get(key);
            return values != null && values.size() > 0 ? values.get(0) : null;
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        @Override
        public List<String> getHeaders(String key) {
            return this.headers.get(key);
        }
    }
}

