/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.hazelcast.inbound;

import com.hazelcast.client.Client;
import com.hazelcast.client.ClientListener;
import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.core.DistributedObjectEvent;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.partition.MigrationListener;
import com.hazelcast.partition.MigrationState;
import com.hazelcast.partition.ReplicaMigrationEvent;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.hazelcast.ClusterMonitorType;
import org.springframework.integration.hazelcast.HazelcastIntegrationDefinitionValidator;
import org.springframework.util.Assert;

public class HazelcastClusterMonitorMessageProducer
extends MessageProducerSupport {
    private final HazelcastInstance hazelcastInstance;
    private Set<String> monitorTypes = Collections.singleton(ClusterMonitorType.MEMBERSHIP.name());
    private final Map<ClusterMonitorType, UUID> hazelcastRegisteredListenerIdMap = new ConcurrentHashMap<ClusterMonitorType, UUID>(5);

    public HazelcastClusterMonitorMessageProducer(HazelcastInstance hazelcastInstance) {
        Assert.notNull((Object)hazelcastInstance, (String)"'hazelcastInstance' must not be null");
        this.hazelcastInstance = hazelcastInstance;
    }

    public void setMonitorEventTypes(String monitorEventTypes) {
        Set<String> types = HazelcastIntegrationDefinitionValidator.validateEnumType(ClusterMonitorType.class, monitorEventTypes);
        Assert.notEmpty(types, (String)"'monitorTypes' must have elements");
        this.monitorTypes = types;
    }

    protected void doStart() {
        UUID registrationId;
        HazelcastClusterMonitorListener clusterMonitorListener = new HazelcastClusterMonitorListener();
        if (this.monitorTypes.contains(ClusterMonitorType.MEMBERSHIP.name())) {
            registrationId = this.hazelcastInstance.getCluster().addMembershipListener((MembershipListener)clusterMonitorListener);
            this.hazelcastRegisteredListenerIdMap.put(ClusterMonitorType.MEMBERSHIP, registrationId);
        }
        if (this.monitorTypes.contains(ClusterMonitorType.DISTRIBUTED_OBJECT.name())) {
            registrationId = this.hazelcastInstance.addDistributedObjectListener((DistributedObjectListener)clusterMonitorListener);
            this.hazelcastRegisteredListenerIdMap.put(ClusterMonitorType.DISTRIBUTED_OBJECT, registrationId);
        }
        if (this.monitorTypes.contains(ClusterMonitorType.MIGRATION.name())) {
            registrationId = this.hazelcastInstance.getPartitionService().addMigrationListener((MigrationListener)clusterMonitorListener);
            this.hazelcastRegisteredListenerIdMap.put(ClusterMonitorType.MIGRATION, registrationId);
        }
        if (this.monitorTypes.contains(ClusterMonitorType.LIFECYCLE.name())) {
            registrationId = this.hazelcastInstance.getLifecycleService().addLifecycleListener((LifecycleListener)clusterMonitorListener);
            this.hazelcastRegisteredListenerIdMap.put(ClusterMonitorType.LIFECYCLE, registrationId);
        }
        if (this.monitorTypes.contains(ClusterMonitorType.CLIENT.name())) {
            registrationId = this.hazelcastInstance.getClientService().addClientListener((ClientListener)clusterMonitorListener);
            this.hazelcastRegisteredListenerIdMap.put(ClusterMonitorType.CLIENT, registrationId);
        }
    }

    protected void doStop() {
        if (this.hazelcastInstance.getLifecycleService().isRunning()) {
            UUID id = this.hazelcastRegisteredListenerIdMap.remove((Object)ClusterMonitorType.MEMBERSHIP);
            if (id != null) {
                this.hazelcastInstance.getCluster().removeMembershipListener(id);
            }
            if ((id = this.hazelcastRegisteredListenerIdMap.remove((Object)ClusterMonitorType.DISTRIBUTED_OBJECT)) != null) {
                this.hazelcastInstance.removeDistributedObjectListener(id);
            }
            if ((id = this.hazelcastRegisteredListenerIdMap.remove((Object)ClusterMonitorType.MIGRATION)) != null) {
                this.hazelcastInstance.getPartitionService().removeMigrationListener(id);
            }
            if ((id = this.hazelcastRegisteredListenerIdMap.remove((Object)ClusterMonitorType.LIFECYCLE)) != null) {
                this.hazelcastInstance.getLifecycleService().removeLifecycleListener(id);
            }
            if ((id = this.hazelcastRegisteredListenerIdMap.remove((Object)ClusterMonitorType.CLIENT)) != null) {
                this.hazelcastInstance.getClientService().removeClientListener(id);
            }
        }
    }

    public String getComponentType() {
        return "hazelcast:cm-inbound-channel-adapter";
    }

    private void processEvent(Object event) {
        Assert.notNull((Object)event, (String)"'hazelcast event' must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((CharSequence)("Received Cluster Monitor Event : " + String.valueOf(event)));
        }
        this.sendMessage(this.getMessageBuilderFactory().withPayload(event).build());
    }

    private final class HazelcastClusterMonitorListener
    implements MembershipListener,
    DistributedObjectListener,
    MigrationListener,
    LifecycleListener,
    ClientListener {
        private HazelcastClusterMonitorListener() {
        }

        public void memberAdded(MembershipEvent membershipEvent) {
            HazelcastClusterMonitorMessageProducer.this.processEvent(membershipEvent);
        }

        public void memberRemoved(MembershipEvent membershipEvent) {
            HazelcastClusterMonitorMessageProducer.this.processEvent(membershipEvent);
        }

        public void distributedObjectCreated(DistributedObjectEvent event) {
            HazelcastClusterMonitorMessageProducer.this.processEvent(event);
        }

        public void distributedObjectDestroyed(DistributedObjectEvent event) {
            HazelcastClusterMonitorMessageProducer.this.processEvent(event);
        }

        public void migrationStarted(MigrationState migrationEvent) {
            HazelcastClusterMonitorMessageProducer.this.processEvent(migrationEvent);
        }

        public void migrationFinished(MigrationState migrationEvent) {
            HazelcastClusterMonitorMessageProducer.this.processEvent(migrationEvent);
        }

        public void replicaMigrationCompleted(ReplicaMigrationEvent event) {
            HazelcastClusterMonitorMessageProducer.this.processEvent(event);
        }

        public void replicaMigrationFailed(ReplicaMigrationEvent event) {
            HazelcastClusterMonitorMessageProducer.this.processEvent(event);
        }

        public void stateChanged(LifecycleEvent event) {
            HazelcastClusterMonitorMessageProducer.this.processEvent(event);
        }

        public void clientConnected(Client client) {
            HazelcastClusterMonitorMessageProducer.this.processEvent(client);
        }

        public void clientDisconnected(Client client) {
            HazelcastClusterMonitorMessageProducer.this.processEvent(client);
        }
    }
}

