/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ftp.inbound;

import org.apache.commons.net.ftp.FTPFile;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.synchronizer.AbstractInboundFileSynchronizer;
import org.springframework.integration.ftp.filters.FtpPersistentAcceptOnceFileListFilter;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;

public class FtpInboundFileSynchronizer
extends AbstractInboundFileSynchronizer<FTPFile> {
    public FtpInboundFileSynchronizer(SessionFactory<FTPFile> sessionFactory) {
        super(sessionFactory);
        this.doSetRemoteDirectoryExpression((Expression)new LiteralExpression(null));
        this.doSetFilter((FileListFilter)new FtpPersistentAcceptOnceFileListFilter((ConcurrentMetadataStore)new SimpleMetadataStore(), "ftpMessageSource"));
    }

    protected boolean isFile(FTPFile file) {
        return file.isFile();
    }

    protected String getFilename(FTPFile file) {
        return file.getName();
    }

    protected long getModified(FTPFile file) {
        return file.getTimestamp().getTimeInMillis();
    }

    protected String protocol() {
        return "ftp";
    }
}

