/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ftp.session;

import java.io.IOException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.springframework.integration.file.remote.ClientCallback;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class FtpRemoteFileTemplate
extends RemoteFileTemplate<FTPFile> {
    private ExistsMode existsMode = ExistsMode.STAT;

    public FtpRemoteFileTemplate(SessionFactory<FTPFile> sessionFactory) {
        super(sessionFactory);
    }

    public <T, C> T executeWithClient(ClientCallback<C, T> callback) {
        return this.doExecuteWithClient(callback);
    }

    public void setExistsMode(ExistsMode existsMode) {
        Assert.notNull((Object)((Object)existsMode), (String)"'existsMode' must not be null.");
        this.existsMode = existsMode;
    }

    protected <T> T doExecuteWithClient(ClientCallback<FTPClient, T> callback) {
        return (T)this.execute(session -> callback.doWithClient((Object)((FTPClient)session.getClientInstance())));
    }

    public boolean exists(String path) {
        return (Boolean)this.doExecuteWithClient(client -> {
            try {
                return switch (this.existsMode.ordinal()) {
                    default -> throw new IncompatibleClassChangeError();
                    case 0 -> client.getStatus(path) != null;
                    case 1 -> !ObjectUtils.isEmpty((Object[])client.listNames(path));
                    case 2 -> FtpRemoteFileTemplate.super.exists(path);
                };
            }
            catch (IOException e) {
                throw new MessagingException("Failed to check the remote path for " + path, (Throwable)e);
            }
        });
    }

    protected boolean shouldMarkSessionAsDirty(Exception ex) {
        IOException ftpException = FtpRemoteFileTemplate.findIoException(ex);
        if (ftpException != null) {
            return this.isStatusDirty(ftpException.getMessage());
        }
        return super.shouldMarkSessionAsDirty(ex);
    }

    protected boolean isStatusDirty(String ftpErrorMessage) {
        return !ftpErrorMessage.contains("550") && !ftpErrorMessage.contains("553");
    }

    @Nullable
    private static IOException findIoException(Throwable ex) {
        if (ex == null || ex instanceof IOException) {
            return (IOException)ex;
        }
        return FtpRemoteFileTemplate.findIoException(ex.getCause());
    }

    public static enum ExistsMode {
        STAT,
        NLST,
        NLST_AND_DIRS;

    }
}

