/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.flow.interceptor;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.ChannelInterceptorAdapter;

public class FlowInterceptor
extends ChannelInterceptorAdapter {
    private static Log log = LogFactory.getLog(FlowInterceptor.class);
    private final String portName;

    public FlowInterceptor(String portName) {
        this.portName = portName;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        if (log.isDebugEnabled()) {
            log.debug((Object)((Object)((Object)this) + " received a message from port " + this.portName + " on channel " + channel));
        }
        Map<String, String> headersToCopy = Collections.singletonMap("flow.output.port", this.portName);
        return MessageBuilder.fromMessage(message).copyHeaders(headersToCopy).build();
    }
}

