/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.splitter;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.springframework.integration.StaticMessageHeaderAccessor;
import org.springframework.integration.splitter.AbstractMessageSplitter;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.json.JsonObjectMapper;
import org.springframework.integration.support.json.JsonObjectMapperProvider;
import org.springframework.integration.util.CloseableIterator;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FileSplitter
extends AbstractMessageSplitter {
    private static final JsonObjectMapper<?, ?> OBJECT_MAPPER = JsonObjectMapperProvider.jsonAvailable() ? JsonObjectMapperProvider.newInstance() : null;
    private final boolean returnIterator;
    private final boolean markers;
    private final boolean markersJson;
    private Charset charset;
    private String firstLineHeaderName;

    public FileSplitter() {
        this(true, false);
    }

    public FileSplitter(boolean iterator) {
        this(iterator, false);
    }

    public FileSplitter(boolean iterator, boolean markers) {
        this(iterator, markers, false);
    }

    public FileSplitter(boolean iterator, boolean markers, boolean markersJson) {
        this.returnIterator = iterator;
        this.markers = markers;
        if (markers) {
            this.setApplySequence(false);
            if (markersJson) {
                Assert.notNull(OBJECT_MAPPER, (String)"'markersJson' requires an object mapper");
            }
        }
        this.markersJson = markersJson;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setFirstLineAsHeader(String firstLineHeaderName) {
        Assert.hasText((String)firstLineHeaderName, (String)"'firstLineHeaderName' must not be empty");
        this.firstLineHeaderName = firstLineHeaderName;
    }

    protected Object splitMessage(Message<?> message) {
        String filePath;
        Reader reader;
        Object payload = message.getPayload();
        if (payload instanceof String) {
            try {
                reader = new FileReader((String)payload);
                filePath = (String)payload;
            }
            catch (FileNotFoundException e) {
                throw new MessageHandlingException(message, "Error handing message in the [" + (Object)((Object)this) + "]. Failed to read file [" + payload + "]", (Throwable)e);
            }
        } else if (payload instanceof File) {
            try {
                reader = this.charset == null ? new FileReader((File)payload) : new InputStreamReader((InputStream)new FileInputStream((File)payload), this.charset);
                filePath = ((File)payload).getAbsolutePath();
            }
            catch (FileNotFoundException e) {
                throw new MessageHandlingException(message, "failed to read file [" + payload + "]", (Throwable)e);
            }
        } else if (payload instanceof InputStream) {
            reader = this.charset == null ? new InputStreamReader((InputStream)payload) : new InputStreamReader((InputStream)payload, this.charset);
            filePath = this.buildPathFromMessage(message, ":stream:");
        } else if (payload instanceof Reader) {
            reader = (Reader)payload;
            filePath = this.buildPathFromMessage(message, ":reader:");
        } else {
            return message;
        }
        Iterator<Object> iterator = this.messageToFileIterator(message, reader, filePath);
        if (this.returnIterator) {
            return iterator;
        }
        ArrayList<Object> lines = new ArrayList<Object>();
        while (iterator.hasNext()) {
            lines.add(iterator.next());
        }
        return lines;
    }

    private Iterator<Object> messageToFileIterator(Message<?> message, Reader reader, String filePath) {
        BufferedReader bufferedReader = this.wrapToBufferedReader(message, reader);
        String firstLineAsHeader = null;
        if (this.firstLineHeaderName != null) {
            try {
                firstLineAsHeader = bufferedReader.readLine();
            }
            catch (IOException e) {
                throw new MessageHandlingException(message, "IOException while reading first line", (Throwable)e);
            }
        }
        return new FileIterator(message, bufferedReader, firstLineAsHeader, filePath);
    }

    private BufferedReader wrapToBufferedReader(final Message<?> message, Reader reader) {
        return new BufferedReader(reader){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    Closeable closeableResource = StaticMessageHeaderAccessor.getCloseableResource((Message)message);
                    if (closeableResource != null) {
                        closeableResource.close();
                    }
                }
            }
        };
    }

    protected boolean willAddHeaders(Message<?> message) {
        Object payload = message.getPayload();
        return payload instanceof File || payload instanceof String;
    }

    protected void addHeaders(Message<?> message, Map<String, Object> headers) {
        File file = null;
        if (message.getPayload() instanceof File) {
            file = (File)message.getPayload();
        } else if (message.getPayload() instanceof String) {
            file = new File((String)message.getPayload());
        }
        if (file != null) {
            if (!headers.containsKey("file_originalFile")) {
                headers.put("file_originalFile", file);
            }
            if (!headers.containsKey("file_name")) {
                headers.put("file_name", file.getName());
            }
        }
    }

    private String buildPathFromMessage(Message<?> message, String defaultPath) {
        String remoteDir = (String)message.getHeaders().get((Object)"file_remoteDirectory");
        String remoteFile = (String)message.getHeaders().get((Object)"file_remoteFile");
        if (StringUtils.hasText((String)remoteDir) && StringUtils.hasText((String)remoteFile)) {
            return remoteDir + remoteFile;
        }
        return defaultPath;
    }

    public static class FileMarker
    implements Serializable {
        private static final long serialVersionUID = 8514605438145748406L;
        private final String filePath;
        private final Mark mark;
        private final long lineCount;

        public FileMarker() {
            this.filePath = null;
            this.mark = null;
            this.lineCount = 0L;
        }

        public FileMarker(String filePath, Mark mark, long lineCount) {
            this.filePath = filePath;
            this.mark = mark;
            this.lineCount = lineCount;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public Mark getMark() {
            return this.mark;
        }

        public long getLineCount() {
            return this.lineCount;
        }

        public String toString() {
            if (Mark.START.equals((Object)this.mark)) {
                return "FileMarker [filePath=" + this.filePath + ", mark=" + (Object)((Object)this.mark) + "]";
            }
            return "FileMarker [filePath=" + this.filePath + ", mark=" + (Object)((Object)this.mark) + ", lineCount=" + this.lineCount + "]";
        }

        public static enum Mark {
            START,
            END;

        }
    }

    private class FileIterator
    implements CloseableIterator<Object> {
        private final Message<?> message;
        private final BufferedReader bufferedReader;
        private final String firstLineAsHeader;
        private final String filePath;
        private boolean markers;
        private boolean sof;
        private boolean eof;
        private boolean done;
        private String line;
        private long lineCount;
        private boolean hasNextCalled;

        FileIterator(Message<?> message, BufferedReader bufferedReader, String firstLineAsHeader, String filePath) {
            this.sof = this.markers = FileSplitter.this.markers;
            this.message = message;
            this.bufferedReader = bufferedReader;
            this.firstLineAsHeader = firstLineAsHeader;
            this.filePath = filePath;
        }

        public boolean hasNext() {
            this.hasNextCalled = true;
            try {
                return this.hasNextLine();
            }
            catch (IOException e) {
                try {
                    this.done = true;
                    this.bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new MessageHandlingException(this.message, "IOException while iterating", (Throwable)e);
            }
        }

        private boolean hasNextLine() throws IOException {
            boolean ready;
            if (!this.done && this.line == null) {
                this.line = this.bufferedReader.readLine();
            }
            boolean bl = ready = !this.done && this.line != null;
            if (!ready) {
                if (this.markers) {
                    this.eof = true;
                    if (this.sof) {
                        this.done = true;
                    }
                }
                this.bufferedReader.close();
            }
            return this.sof || ready || this.eof;
        }

        public Object next() {
            if (!this.hasNextCalled) {
                this.hasNext();
            }
            this.hasNextCalled = false;
            if (this.sof) {
                this.sof = false;
                return this.markerToReturn(new FileMarker(this.filePath, FileMarker.Mark.START, 0L));
            }
            if (this.eof) {
                this.eof = false;
                this.markers = false;
                this.done = true;
                return this.markerToReturn(new FileMarker(this.filePath, FileMarker.Mark.END, this.lineCount));
            }
            if (this.line != null) {
                String payload = this.line;
                this.line = null;
                ++this.lineCount;
                AbstractIntegrationMessageBuilder messageBuilder = FileSplitter.this.getMessageBuilderFactory().withPayload((Object)payload);
                if (this.firstLineAsHeader != null) {
                    messageBuilder.setHeader(FileSplitter.this.firstLineHeaderName, (Object)this.firstLineAsHeader);
                }
                return messageBuilder;
            }
            this.done = true;
            throw new NoSuchElementException(this.filePath + " has been consumed");
        }

        private AbstractIntegrationMessageBuilder<Object> markerToReturn(FileMarker fileMarker) {
            Object payload;
            if (FileSplitter.this.markersJson) {
                try {
                    payload = OBJECT_MAPPER.toJson((Object)fileMarker);
                }
                catch (Exception e) {
                    throw new MessageHandlingException(this.message, "Failed to convert marker to JSON", (Throwable)e);
                }
            } else {
                payload = fileMarker;
            }
            return FileSplitter.this.getMessageBuilderFactory().withPayload(payload).setHeader("file_marker", (Object)fileMarker.mark.name());
        }

        public void close() {
            try {
                this.done = true;
                this.bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

