/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.Lifecycle;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.file.DefaultDirectoryScanner;
import org.springframework.integration.file.DirectoryScanner;
import org.springframework.integration.file.FileLocker;
import org.springframework.integration.file.HeadDirectoryScanner;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.ResettableFileListFilter;
import org.springframework.lang.UsesJava7;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public class FileReadingMessageSource
extends IntegrationObjectSupport
implements MessageSource<File>,
Lifecycle {
    private static final int DEFAULT_INTERNAL_QUEUE_CAPACITY = 5;
    private static final Log logger = LogFactory.getLog(FileReadingMessageSource.class);
    private final AtomicBoolean running = new AtomicBoolean();
    private final Queue<File> toBeReceived;
    private volatile File directory;
    private volatile DirectoryScanner scanner = new DefaultDirectoryScanner();
    private volatile boolean scannerExplicitlySet;
    private volatile boolean autoCreateDirectory = true;
    private volatile boolean scanEachPoll = false;
    private FileListFilter<File> filter;
    private FileLocker locker;
    private boolean useWatchService;
    private WatchEventType[] watchEvents = new WatchEventType[]{WatchEventType.CREATE};

    public FileReadingMessageSource() {
        this(null);
    }

    public FileReadingMessageSource(int internalQueueCapacity) {
        this(null);
        Assert.isTrue((internalQueueCapacity > 0 ? 1 : 0) != 0, (String)"Cannot create a queue with non positive capacity");
        this.scanner = new HeadDirectoryScanner(internalQueueCapacity);
    }

    public FileReadingMessageSource(Comparator<File> receptionOrderComparator) {
        this.toBeReceived = new PriorityBlockingQueue<File>(5, receptionOrderComparator);
    }

    public void setDirectory(File directory) {
        Assert.notNull((Object)directory, (String)"directory must not be null");
        this.directory = directory;
    }

    public void setScanner(DirectoryScanner scanner) {
        Assert.notNull((Object)scanner, (String)"'scanner' must not be null.");
        this.scanner = scanner;
        this.scannerExplicitlySet = true;
    }

    public DirectoryScanner getScanner() {
        return this.scanner;
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public void setFilter(FileListFilter<File> filter) {
        Assert.notNull(filter, (String)"'filter' must not be null");
        this.filter = filter;
    }

    public void setLocker(FileLocker locker) {
        Assert.notNull((Object)locker, (String)"'fileLocker' must not be null.");
        this.locker = locker;
    }

    public void setScanEachPoll(boolean scanEachPoll) {
        this.scanEachPoll = scanEachPoll;
    }

    public void setUseWatchService(boolean useWatchService) {
        this.useWatchService = useWatchService;
    }

    public void setWatchEvents(WatchEventType ... watchEvents) {
        Assert.notEmpty((Object[])watchEvents, (String)"'watchEvents' must not be empty.");
        Assert.noNullElements((Object[])watchEvents, (String)"'watchEvents' must not contain null elements.");
        Assert.state((!this.running.get() ? 1 : 0) != 0, (String)"Cannot change watch events while running.");
        this.watchEvents = Arrays.copyOf(watchEvents, watchEvents.length);
    }

    public String getComponentType() {
        return "file:inbound-channel-adapter";
    }

    public void start() {
        if (!this.running.getAndSet(true) && this.scanner instanceof Lifecycle) {
            ((Lifecycle)this.scanner).start();
        }
    }

    public void stop() {
        if (this.running.getAndSet(false) && this.scanner instanceof Lifecycle) {
            ((Lifecycle)this.scanner).stop();
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    protected void onInit() {
        Assert.notNull((Object)this.directory, (String)"'directory' must not be null");
        if (!this.directory.exists() && this.autoCreateDirectory) {
            this.directory.mkdirs();
        }
        Assert.isTrue((boolean)this.directory.exists(), (String)("Source directory [" + this.directory + "] does not exist."));
        Assert.isTrue((boolean)this.directory.isDirectory(), (String)("Source path [" + this.directory + "] does not point to a directory."));
        Assert.isTrue((boolean)this.directory.canRead(), (String)("Source directory [" + this.directory + "] is not readable."));
        Assert.state((!this.scannerExplicitlySet || !this.useWatchService ? 1 : 0) != 0, (String)("The 'scanner' and 'useWatchService' options are mutually exclusive: " + this.scanner));
        if (this.useWatchService) {
            this.scanner = new WatchServiceDirectoryScanner();
        }
        Assert.state((!this.scannerExplicitlySet || this.filter == null && this.locker == null ? 1 : 0) != 0, (String)("The 'filter' and 'locker' options must be present on the provided external 'scanner': " + this.scanner));
        if (this.filter != null) {
            this.scanner.setFilter(this.filter);
        }
        if (this.locker != null) {
            this.scanner.setLocker(this.locker);
        }
    }

    public Message<File> receive() throws MessagingException {
        Message message = null;
        if (this.scanEachPoll || this.toBeReceived.isEmpty()) {
            this.scanInputDirectory();
        }
        File file = this.toBeReceived.poll();
        while (file != null && !this.scanner.tryClaim(file)) {
            file = this.toBeReceived.poll();
        }
        if (file != null) {
            message = this.getMessageBuilderFactory().withPayload((Object)file).build();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Created message: [" + message + "]"));
            }
        }
        return message;
    }

    private void scanInputDirectory() {
        List<File> filteredFiles = this.scanner.listFiles(this.directory);
        LinkedHashSet<File> freshFiles = new LinkedHashSet<File>(filteredFiles);
        if (!freshFiles.isEmpty()) {
            this.toBeReceived.addAll(freshFiles);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Added to queue: " + freshFiles));
            }
        }
    }

    public void onFailure(Message<File> failedMessage) {
        if (logger.isWarnEnabled()) {
            logger.warn((Object)("Failed to send: " + failedMessage));
        }
        this.toBeReceived.offer((File)failedMessage.getPayload());
    }

    @Deprecated
    public void onSend(Message<File> sentMessage) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Sent: " + sentMessage));
        }
    }

    @UsesJava7
    private class WatchServiceDirectoryScanner
    extends DefaultDirectoryScanner
    implements Lifecycle {
        private final ConcurrentMap<Path, WatchKey> pathKeys = new ConcurrentHashMap<Path, WatchKey>();
        private WatchService watcher;
        private Collection<File> initialFiles;
        private WatchEvent.Kind<?>[] kinds;

        private WatchServiceDirectoryScanner() {
        }

        public void start() {
            try {
                this.watcher = FileSystems.getDefault().newWatchService();
            }
            catch (IOException e) {
                logger.error((Object)("Failed to create watcher for " + FileReadingMessageSource.this.directory), (Throwable)e);
            }
            this.kinds = new WatchEvent.Kind[FileReadingMessageSource.this.watchEvents.length];
            for (int i = 0; i < FileReadingMessageSource.this.watchEvents.length; ++i) {
                this.kinds[i] = FileReadingMessageSource.this.watchEvents[i].kind;
            }
            Set<File> initialFiles = this.walkDirectory(FileReadingMessageSource.this.directory.toPath(), null);
            initialFiles.addAll(this.filesFromEvents());
            this.initialFiles = initialFiles;
        }

        public void stop() {
            try {
                this.watcher.close();
                this.watcher = null;
                this.pathKeys.clear();
            }
            catch (IOException e) {
                logger.error((Object)("Failed to close watcher for " + FileReadingMessageSource.this.directory), (Throwable)e);
            }
        }

        public boolean isRunning() {
            return true;
        }

        @Override
        protected File[] listEligibleFiles(File directory) {
            Assert.state((this.watcher != null ? 1 : 0) != 0, (String)"The WatchService has'nt been started");
            if (this.initialFiles != null) {
                File[] initial = this.initialFiles.toArray(new File[this.initialFiles.size()]);
                this.initialFiles = null;
                return initial;
            }
            Set<File> files = this.filesFromEvents();
            return files.toArray(new File[files.size()]);
        }

        private Set<File> filesFromEvents() {
            WatchKey key = this.watcher.poll();
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            while (key != null) {
                File parentDir = ((Path)key.watchable()).toAbsolutePath().toFile();
                for (WatchEvent<?> event : key.pollEvents()) {
                    if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE || event.kind() == StandardWatchEventKinds.ENTRY_MODIFY || event.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                        Path item = (Path)event.context();
                        File file = new File(parentDir, item.toFile().getName());
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Watch event [" + event.kind() + "] for file [" + file + "]"));
                        }
                        if (event.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                            boolean fileRemoved;
                            if (this.getFilter() instanceof ResettableFileListFilter) {
                                ((ResettableFileListFilter)this.getFilter()).remove(file);
                            }
                            if (!(fileRemoved = files.remove(file)) || !logger.isDebugEnabled()) continue;
                            logger.debug((Object)("The file [" + file + "] has been removed from the queue because of DELETE event."));
                            continue;
                        }
                        if (file.exists()) {
                            if (file.isDirectory()) {
                                files.addAll(this.walkDirectory(file.toPath(), event.kind()));
                                continue;
                            }
                            files.remove(file);
                            files.add(file);
                            continue;
                        }
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("A file [" + file + "] for the event [" + event.kind() + "] doesn't exist. Ignored."));
                        continue;
                    }
                    if (event.kind() != StandardWatchEventKinds.OVERFLOW) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Watch event [" + StandardWatchEventKinds.OVERFLOW + "] with context [" + event.context() + "]"));
                    }
                    for (WatchKey watchKey : this.pathKeys.values()) {
                        watchKey.cancel();
                    }
                    this.pathKeys.clear();
                    if (event.context() != null && event.context() instanceof Path) {
                        files.addAll(this.walkDirectory((Path)event.context(), event.kind()));
                        continue;
                    }
                    files.addAll(this.walkDirectory(FileReadingMessageSource.this.directory.toPath(), event.kind()));
                }
                key.reset();
                key = this.watcher.poll();
            }
            return files;
        }

        private Set<File> walkDirectory(Path directory, final WatchEvent.Kind<?> kind) {
            final LinkedHashSet<File> walkedFiles = new LinkedHashSet<File>();
            try {
                this.registerWatch(directory);
                Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        FileVisitResult fileVisitResult = super.preVisitDirectory(dir, attrs);
                        WatchServiceDirectoryScanner.this.registerWatch(dir);
                        return fileVisitResult;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        FileVisitResult fileVisitResult = super.visitFile(file, attrs);
                        if (!StandardWatchEventKinds.ENTRY_MODIFY.equals(kind)) {
                            walkedFiles.add(file.toFile());
                        }
                        return fileVisitResult;
                    }
                });
            }
            catch (IOException e) {
                logger.error((Object)("Failed to walk directory: " + directory.toString()), (Throwable)e);
            }
            return walkedFiles;
        }

        private void registerWatch(Path dir) throws IOException {
            if (!this.pathKeys.containsKey(dir)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("registering: " + dir + " for file events"));
                }
                WatchKey watchKey = dir.register(this.watcher, this.kinds);
                this.pathKeys.putIfAbsent(dir, watchKey);
            }
        }
    }

    @UsesJava7
    public static enum WatchEventType {
        CREATE(StandardWatchEventKinds.ENTRY_CREATE),
        MODIFY(StandardWatchEventKinds.ENTRY_MODIFY),
        DELETE(StandardWatchEventKinds.ENTRY_DELETE);

        private final WatchEvent.Kind<Path> kind;

        private WatchEventType(WatchEvent.Kind<Path> kind) {
            this.kind = kind;
        }
    }
}

