/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.file.DefaultFileNameGenerator;
import org.springframework.integration.file.remote.RemoteFileOperations;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public final class FileParserUtils {
    private FileParserUtils() {
    }

    public static BeanDefinition parseRemoteFileTemplate(Element element, ParserContext parserContext, boolean atLeastOneRemoteDirectoryAttributeRequired, Class<? extends RemoteFileOperations<?>> templateClass) {
        BeanDefinitionBuilder templateBuilder = BeanDefinitionBuilder.genericBeanDefinition(templateClass);
        templateBuilder.addConstructorArgReference(element.getAttribute("session-factory"));
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)templateBuilder, (Element)element, (String)"temporary-file-suffix");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)templateBuilder, (Element)element, (String)"use-temporary-file-name");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)templateBuilder, (Element)element, (String)"auto-create-directory");
        BeanDefinition expressionDef = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"remote-directory", (String)"remote-directory-expression", (ParserContext)parserContext, (Element)element, (boolean)atLeastOneRemoteDirectoryAttributeRequired);
        if (expressionDef != null) {
            templateBuilder.addPropertyValue("remoteDirectoryExpression", (Object)expressionDef);
        }
        if ((expressionDef = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"temporary-remote-directory", (String)"temporary-remote-directory-expression", (ParserContext)parserContext, (Element)element, (boolean)false)) != null) {
            templateBuilder.addPropertyValue("temporaryRemoteDirectoryExpression", (Object)expressionDef);
        }
        String remoteFileNameGenerator = element.getAttribute("remote-filename-generator");
        String remoteFileNameGeneratorExpression = element.getAttribute("remote-filename-generator-expression");
        boolean hasRemoteFileNameGenerator = StringUtils.hasText((String)remoteFileNameGenerator);
        boolean hasRemoteFileNameGeneratorExpression = StringUtils.hasText((String)remoteFileNameGeneratorExpression);
        if (hasRemoteFileNameGenerator || hasRemoteFileNameGeneratorExpression) {
            if (hasRemoteFileNameGenerator && hasRemoteFileNameGeneratorExpression) {
                parserContext.getReaderContext().error("at most one of 'remote-filename-generator-expression' or 'remote-filename-generator' is allowed on a remote file outbound adapter", (Object)element);
            }
            if (hasRemoteFileNameGenerator) {
                templateBuilder.addPropertyReference("fileNameGenerator", remoteFileNameGenerator);
            } else {
                BeanDefinitionBuilder fileNameGeneratorBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultFileNameGenerator.class);
                fileNameGeneratorBuilder.addPropertyValue("expression", (Object)remoteFileNameGeneratorExpression);
                templateBuilder.addPropertyValue("fileNameGenerator", (Object)fileNameGeneratorBuilder.getBeanDefinition());
            }
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)templateBuilder, (Element)element, (String)"charset");
        templateBuilder.addPropertyValue("remoteFileSeparator", (Object)element.getAttribute("remote-file-separator"));
        return templateBuilder.getBeanDefinition();
    }
}

