/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

abstract class FileWritingMessageHandlerBeanDefinitionBuilder {
    FileWritingMessageHandlerBeanDefinitionBuilder() {
    }

    static BeanDefinitionBuilder configure(Element element, String outputChannelBeanName, ParserContext parserContext) {
        if (outputChannelBeanName == null) {
            parserContext.getReaderContext().error("outputChannelBeanName must not be null", (Object)element);
            return null;
        }
        String directory = element.getAttribute("directory");
        if (!StringUtils.hasText((String)directory)) {
            parserContext.getReaderContext().error("directory is required", (Object)element);
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.file.config.FileWritingMessageHandlerFactoryBean");
        builder.addPropertyValue("directory", (Object)directory);
        if (StringUtils.hasText((String)outputChannelBeanName)) {
            builder.addPropertyReference("outputChannel", outputChannelBeanName);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"auto-create-directory");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"delete-source-files");
        String fileNameGenerator = element.getAttribute("filename-generator");
        if (StringUtils.hasText((String)fileNameGenerator)) {
            builder.addPropertyReference("fileNameGenerator", fileNameGenerator);
        }
        return builder;
    }
}

