/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.integration.core.Message;
import org.springframework.integration.core.MessagingException;
import org.springframework.integration.file.AcceptOnceFileListFilter;
import org.springframework.integration.file.FileListFilter;
import org.springframework.integration.message.MessageBuilder;
import org.springframework.integration.message.MessageSource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileReadingMessageSource
implements MessageSource<File>,
InitializingBean {
    private static final int INTERNAL_QUEUE_CAPACITY = 5;
    private static final Log logger = LogFactory.getLog(FileReadingMessageSource.class);
    private volatile File inputDirectory;
    private volatile boolean autoCreateDirectory = true;
    private final Queue<File> toBeReceived;
    private volatile FileListFilter filter = new AcceptOnceFileListFilter();
    private boolean scanEachPoll = false;

    public FileReadingMessageSource() {
        this.toBeReceived = new PriorityBlockingQueue<File>(5);
    }

    public FileReadingMessageSource(Comparator<File> receptionOrderComparator) {
        this.toBeReceived = new PriorityBlockingQueue<File>(5, receptionOrderComparator);
    }

    public void setInputDirectory(Resource inputDirectory) {
        Assert.notNull((Object)inputDirectory, (String)"inputDirectory must not be null");
        try {
            this.inputDirectory = inputDirectory.getFile();
        }
        catch (IOException ioe) {
            try {
                this.inputDirectory = new File(inputDirectory.getURI());
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Unexpected IOException when looking for source directory: " + inputDirectory, ioe);
            }
        }
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public void setFilter(FileListFilter filter) {
        Assert.notNull((Object)filter, (String)"'filter' should not be null");
        this.filter = filter;
    }

    public void setScanEachPoll(boolean scanEachPoll) {
        this.scanEachPoll = scanEachPoll;
    }

    public final void afterPropertiesSet() {
        if (!this.inputDirectory.exists() && this.autoCreateDirectory) {
            this.inputDirectory.mkdirs();
        }
        Assert.isTrue((boolean)this.inputDirectory.exists(), (String)("Source directory [" + this.inputDirectory + "] does not exist."));
        Assert.isTrue((boolean)this.inputDirectory.isDirectory(), (String)("Source path [" + this.inputDirectory + "] does not point to a directory."));
        Assert.isTrue((boolean)this.inputDirectory.canRead(), (String)("Source directory [" + this.inputDirectory + "] is not readable."));
    }

    public Message<File> receive() throws MessagingException {
        File file;
        Message message = null;
        if (this.scanEachPoll || this.toBeReceived.isEmpty()) {
            this.scanInputDirectory();
        }
        if ((file = this.toBeReceived.poll()) != null) {
            message = MessageBuilder.withPayload((Object)file).build();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Created message: [" + message + "]"));
            }
        }
        return message;
    }

    private void scanInputDirectory() {
        File[] fileArray = this.inputDirectory.listFiles();
        if (fileArray == null) {
            throw new MessagingException("Either the path [" + this.inputDirectory + "] does not denote a directory, or an I/O error has occured.");
        }
        List<File> filteredFiles = this.filter.filterFiles(fileArray);
        HashSet<File> freshFiles = new HashSet<File>(filteredFiles);
        if (!freshFiles.isEmpty()) {
            this.toBeReceived.addAll(freshFiles);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Added to queue: " + freshFiles));
            }
        }
    }

    public void onFailure(Message<File> failedMessage, Throwable t) {
        if (logger.isWarnEnabled()) {
            logger.warn((Object)("Failed to send: " + failedMessage));
        }
        this.toBeReceived.offer((File)failedMessage.getPayload());
    }

    public void onSend(Message<File> sentMessage) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Sent: " + sentMessage));
        }
    }
}

