/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file;

import java.io.File;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.integration.file.AbstractFileListFilter;

public class AcceptOnceFileListFilter
extends AbstractFileListFilter {
    private final Queue<File> seen;
    private final Object monitor = new Object();

    public AcceptOnceFileListFilter(int maxCapacity) {
        this.seen = new LinkedBlockingQueue<File>(maxCapacity);
    }

    public AcceptOnceFileListFilter() {
        this.seen = new LinkedBlockingQueue<File>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean accept(File pathname) {
        Object object = this.monitor;
        synchronized (object) {
            block5: {
                if (!this.seen.contains(pathname)) break block5;
                return false;
            }
            if (!this.seen.offer(pathname)) {
                this.seen.poll();
                this.seen.add(pathname);
            }
            return true;
        }
    }
}

