/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.feed.inbound;

import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.SyndFeedInput;
import com.rometools.rome.io.XmlReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.io.Resource;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.metadata.MetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class FeedEntryMessageSource
extends IntegrationObjectSupport
implements MessageSource<SyndEntry> {
    private final URL feedUrl;
    private final Resource feedResource;
    private final String metadataKey;
    private final Queue<SyndEntry> entries = new ConcurrentLinkedQueue<SyndEntry>();
    private final Object monitor = new Object();
    private final Comparator<SyndEntry> syndEntryComparator = new SyndEntryPublishedDateComparator();
    private final Object feedMonitor = new Object();
    private volatile SyndFeedInput syndFeedInput = new SyndFeedInput();
    private boolean syndFeedInputSet;
    private volatile MetadataStore metadataStore;
    private volatile long lastTime = -1L;
    private volatile boolean initialized;

    public FeedEntryMessageSource(URL feedUrl, String metadataKey) {
        Assert.notNull((Object)feedUrl, (String)"'feedUrl' must not be null");
        Assert.notNull((Object)metadataKey, (String)"'metadataKey' must not be null");
        this.feedUrl = feedUrl;
        this.metadataKey = metadataKey + "." + feedUrl;
        this.feedResource = null;
    }

    public FeedEntryMessageSource(Resource feedResource, String metadataKey) {
        Assert.notNull((Object)feedResource, (String)"'feedResource' must not be null");
        Assert.notNull((Object)metadataKey, (String)"'metadataKey' must not be null");
        this.feedResource = feedResource;
        this.metadataKey = metadataKey;
        this.feedUrl = null;
    }

    public void setMetadataStore(MetadataStore metadataStore) {
        Assert.notNull((Object)metadataStore, (String)"'metadataStore' must not be null");
        this.metadataStore = metadataStore;
    }

    public void setSyndFeedInput(SyndFeedInput syndFeedInput) {
        Assert.notNull((Object)syndFeedInput, (String)"'syndFeedInput' must not be null");
        this.syndFeedInput = syndFeedInput;
        this.syndFeedInputSet = true;
    }

    public void setPreserveWireFeed(boolean preserveWireFeed) {
        Assert.isTrue((!this.syndFeedInputSet ? 1 : 0) != 0, (String)("'preserveWireFeed' must be configured on the provided [" + this.syndFeedInput + "]"));
        this.syndFeedInput.setPreserveWireFeed(preserveWireFeed);
    }

    public String getComponentType() {
        return "feed:inbound-channel-adapter";
    }

    public Message<SyndEntry> receive() {
        Assert.isTrue((boolean)this.initialized, (String)"'FeedEntryReaderMessageSource' must be initialized before it can produce Messages.");
        SyndEntry entry = this.doReceive();
        if (entry == null) {
            return null;
        }
        return this.getMessageBuilderFactory().withPayload((Object)entry).build();
    }

    protected void onInit() throws Exception {
        String lastTimeValue;
        if (this.metadataStore == null) {
            BeanFactory beanFactory = this.getBeanFactory();
            if (beanFactory != null) {
                this.metadataStore = IntegrationContextUtils.getMetadataStore((BeanFactory)beanFactory);
            }
            if (this.metadataStore == null) {
                this.metadataStore = new SimpleMetadataStore();
            }
        }
        if (StringUtils.hasText((String)(lastTimeValue = this.metadataStore.get(this.metadataKey)))) {
            this.lastTime = Long.parseLong(lastTimeValue);
        }
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyndEntry doReceive() {
        SyndEntry nextEntry = null;
        Object object = this.monitor;
        synchronized (object) {
            nextEntry = this.getNextEntry();
            if (nextEntry == null) {
                this.populateEntryList();
                nextEntry = this.getNextEntry();
            }
        }
        return nextEntry;
    }

    private SyndEntry getNextEntry() {
        SyndEntry next = this.entries.poll();
        if (next == null) {
            return null;
        }
        Date lastModifiedDate = FeedEntryMessageSource.getLastModifiedDate(next);
        this.lastTime = lastModifiedDate != null ? lastModifiedDate.getTime() : ++this.lastTime;
        this.metadataStore.put(this.metadataKey, this.lastTime + "");
        return next;
    }

    private void populateEntryList() {
        List retrievedEntries;
        SyndFeed syndFeed = this.getFeed();
        if (syndFeed != null && !CollectionUtils.isEmpty((Collection)(retrievedEntries = syndFeed.getEntries()))) {
            boolean withinNewEntries = false;
            Collections.sort(retrievedEntries, this.syndEntryComparator);
            for (SyndEntry entry : retrievedEntries) {
                Date entryDate = FeedEntryMessageSource.getLastModifiedDate(entry);
                if ((entryDate == null || entryDate.getTime() <= this.lastTime) && (entryDate != null || !withinNewEntries)) continue;
                this.entries.add(entry);
                withinNewEntries = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyndFeed getFeed() {
        try {
            Object object = this.feedMonitor;
            synchronized (object) {
                XmlReader reader = this.feedUrl != null ? new XmlReader(this.feedUrl) : new XmlReader(this.feedResource.getInputStream());
                SyndFeed feed = this.syndFeedInput.build((Reader)reader);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Retrieved feed for [" + (Object)((Object)this) + "]"));
                }
                if (feed == null && this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("No feeds updated for [" + (Object)((Object)this) + "], returning null"));
                }
                return feed;
            }
        }
        catch (Exception e) {
            throw new MessagingException("Failed to retrieve feed for '" + (Object)((Object)this) + "'", (Throwable)e);
        }
    }

    public String toString() {
        return "FeedEntryMessageSource{feedUrl=" + this.feedUrl + ", feedResource=" + this.feedResource + ", metadataKey='" + this.metadataKey + '\'' + ", lastTime=" + this.lastTime + '}';
    }

    private static Date getLastModifiedDate(SyndEntry entry) {
        return entry.getUpdatedDate() != null ? entry.getUpdatedDate() : entry.getPublishedDate();
    }

    private static final class SyndEntryPublishedDateComparator
    implements Comparator<SyndEntry> {
        SyndEntryPublishedDateComparator() {
        }

        @Override
        public int compare(SyndEntry entry1, SyndEntry entry2) {
            Date date1 = FeedEntryMessageSource.getLastModifiedDate(entry1);
            Date date2 = FeedEntryMessageSource.getLastModifiedDate(entry2);
            if (date1 != null && date2 != null) {
                return date1.compareTo(date2);
            }
            if (date1 == null && date2 == null) {
                return 0;
            }
            return date2 == null ? -1 : 1;
        }
    }
}

