/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.camel.dsl;

import org.apache.camel.ExchangePattern;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.LambdaRouteBuilder;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.camel.dsl.CamelMessageHandlerSpec;

public final class Camel {
    public static CamelMessageHandlerSpec handler() {
        return Camel.camelHandler(null, ExchangePattern.InOnly);
    }

    public static CamelMessageHandlerSpec handler(ProducerTemplate producerTemplate) {
        return Camel.camelHandler(producerTemplate, ExchangePattern.InOnly);
    }

    public static CamelMessageHandlerSpec gateway() {
        return Camel.camelHandler(null, ExchangePattern.InOut);
    }

    public static CamelMessageHandlerSpec gateway(ProducerTemplate producerTemplate) {
        return Camel.camelHandler(producerTemplate, ExchangePattern.InOut);
    }

    public static CamelMessageHandlerSpec route(LambdaRouteBuilder route) {
        return Camel.camelHandler(null, ExchangePattern.InOut).route(route);
    }

    private static CamelMessageHandlerSpec camelHandler(@Nullable ProducerTemplate producerTemplate, ExchangePattern exchangePattern) {
        return new CamelMessageHandlerSpec(producerTemplate).exchangePattern(exchangePattern);
    }

    private Camel() {
    }
}

