/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.support;

import io.awspring.cloud.sns.core.TopicArnResolver;
import org.springframework.util.Assert;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.model.CreateTopicResponse;

public class SnsAsyncTopicArnResolver
implements TopicArnResolver {
    private final SnsAsyncClient snsClient;

    public SnsAsyncTopicArnResolver(SnsAsyncClient snsClient) {
        Assert.notNull((Object)snsClient, (String)"snsClient is required");
        this.snsClient = snsClient;
    }

    public Arn resolveTopicArn(String topicName) {
        Assert.notNull((Object)topicName, (String)"topicName must not be null");
        if (topicName.toLowerCase().startsWith("arn:")) {
            return Arn.fromString((String)topicName);
        }
        return Arn.fromString((String)((CreateTopicResponse)this.snsClient.createTopic(request -> request.name(topicName)).join()).topicArn());
    }
}

