/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.inbound;

import com.rabbitmq.client.amqp.Resource;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import org.aopalliance.aop.Advice;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.Address;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.listener.adapter.ReplyPostProcessor;
import org.springframework.amqp.rabbitmq.client.AmqpConnectionFactory;
import org.springframework.amqp.rabbitmq.client.RabbitAmqpTemplate;
import org.springframework.amqp.rabbitmq.client.listener.RabbitAmqpListenerContainer;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SimpleMessageConverter;
import org.springframework.amqp.support.postprocessor.MessagePostProcessorUtils;
import org.springframework.integration.amqp.inbound.IntegrationRabbitAmqpMessageListener;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.core.Pausable;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AmqpClientInboundGateway
extends MessagingGatewaySupport
implements Pausable {
    private final RabbitAmqpListenerContainer listenerContainer;
    private final RabbitAmqpTemplate replyTemplate;
    private @Nullable MessageConverter messageConverter = new SimpleMessageConverter();
    private AmqpHeaderMapper headerMapper = DefaultAmqpHeaderMapper.inboundMapper();
    private @Nullable Collection<MessagePostProcessor> afterReceivePostProcessors;
    private @Nullable ReplyPostProcessor replyPostProcessor;
    private volatile boolean paused;

    public AmqpClientInboundGateway(AmqpConnectionFactory connectionFactory, String ... queueNames) {
        this.listenerContainer = new RabbitAmqpListenerContainer(connectionFactory);
        this.listenerContainer.setQueueNames(queueNames);
        this.replyTemplate = new RabbitAmqpTemplate(connectionFactory);
    }

    public void setInitialCredits(int initialCredits) {
        this.listenerContainer.setInitialCredits(initialCredits);
    }

    public void setPriority(int priority) {
        this.listenerContainer.setPriority(priority);
    }

    public void setStateListeners(Resource.StateListener ... stateListeners) {
        this.listenerContainer.setStateListeners(stateListeners);
    }

    public void setAfterReceivePostProcessors(MessagePostProcessor ... afterReceivePostProcessors) {
        this.afterReceivePostProcessors = MessagePostProcessorUtils.sort(Arrays.asList(afterReceivePostProcessors));
    }

    public void setAdviceChain(Advice ... advices) {
        this.listenerContainer.setAdviceChain(advices);
    }

    public void setAutoSettle(boolean autoSettle) {
        this.listenerContainer.setAutoSettle(autoSettle);
    }

    public void setDefaultRequeue(boolean defaultRequeue) {
        this.listenerContainer.setDefaultRequeue(defaultRequeue);
    }

    public void setGracefulShutdownPeriod(Duration gracefulShutdownPeriod) {
        this.listenerContainer.setGracefulShutdownPeriod(gracefulShutdownPeriod);
    }

    public void setConsumersPerQueue(int consumersPerQueue) {
        this.listenerContainer.setConsumersPerQueue(consumersPerQueue);
    }

    public void setMessageConverter(@Nullable MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setHeaderMapper(AmqpHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    public void setReplyPostProcessor(ReplyPostProcessor replyPostProcessor) {
        this.replyPostProcessor = replyPostProcessor;
    }

    public void setReplyExchange(String exchange) {
        this.replyTemplate.setExchange(exchange);
    }

    public void setReplyRoutingKey(String routingKey) {
        this.replyTemplate.setRoutingKey(routingKey);
    }

    public void setReplyQueue(String queue) {
        this.replyTemplate.setQueue(queue);
    }

    public String getComponentType() {
        return "amqp:inbound-gateway";
    }

    protected void onInit() {
        super.onInit();
        this.listenerContainer.setBeanName(this.getComponentName() + ".listenerContainer");
        IntegrationRabbitAmqpMessageListener messageListener = new IntegrationRabbitAmqpMessageListener((NamedComponent)this, this::processRequest, this.headerMapper, this.messageConverter, this.afterReceivePostProcessors);
        this.listenerContainer.setupMessageListener((MessageListener)messageListener);
        this.listenerContainer.afterPropertiesSet();
    }

    protected void doStart() {
        super.doStart();
        this.listenerContainer.start();
    }

    protected void doStop() {
        super.doStop();
        this.listenerContainer.stop();
    }

    public void destroy() {
        super.destroy();
        this.listenerContainer.destroy();
        this.replyTemplate.destroy();
    }

    public void pause() {
        this.listenerContainer.pause();
        this.paused = true;
    }

    public void resume() {
        this.listenerContainer.resume();
        this.paused = false;
    }

    public boolean isPaused() {
        return this.paused;
    }

    private void processRequest(Message<?> messageToSend, org.springframework.amqp.core.Message requestMessage) {
        Message receivedMessage = this.sendAndReceiveMessage(messageToSend);
        if (receivedMessage != null) {
            org.springframework.amqp.core.Message replyMessage = this.fromSpringMessage(receivedMessage, requestMessage);
            this.publishReply(requestMessage, replyMessage);
        } else {
            this.logger.warn(() -> "No reply received for message: " + String.valueOf(requestMessage));
        }
    }

    private org.springframework.amqp.core.Message fromSpringMessage(Message<?> receivedMessage, org.springframework.amqp.core.Message requestMessage) {
        org.springframework.amqp.core.Message replyMessage;
        MessageProperties messageProperties = new MessageProperties();
        Object payload = receivedMessage.getPayload();
        if (payload instanceof org.springframework.amqp.core.Message) {
            org.springframework.amqp.core.Message amqpMessage;
            replyMessage = amqpMessage = (org.springframework.amqp.core.Message)payload;
        } else {
            Assert.state((this.messageConverter != null ? 1 : 0) != 0, (String)"If reply payload is not an 'org.springframework.amqp.core.Message', the 'messageConverter' must be provided.");
            replyMessage = this.messageConverter.toMessage(payload, messageProperties);
            this.headerMapper.fromHeadersToReply(receivedMessage.getHeaders(), messageProperties);
        }
        AmqpClientInboundGateway.postProcessResponse(requestMessage, replyMessage);
        if (this.replyPostProcessor != null) {
            replyMessage = (org.springframework.amqp.core.Message)this.replyPostProcessor.apply((Object)requestMessage, (Object)replyMessage);
        }
        return replyMessage;
    }

    private void publishReply(org.springframework.amqp.core.Message requestMessage, org.springframework.amqp.core.Message replyMessage) {
        Address replyTo = requestMessage.getMessageProperties().getReplyToAddress();
        if (replyTo != null) {
            String exchangeName = replyTo.getExchangeName();
            String routingKey = replyTo.getRoutingKey();
            if (StringUtils.hasText((String)exchangeName)) {
                this.replyTemplate.send(exchangeName, routingKey, replyMessage).join();
            } else {
                Assert.hasText((String)routingKey, (String)"A 'replyTo' property must be provided in the requestMessage.");
                String queue = routingKey.replaceFirst("queues/", "");
                this.replyTemplate.send(queue, replyMessage).join();
            }
        } else {
            this.replyTemplate.send(replyMessage).join();
        }
    }

    private static void postProcessResponse(org.springframework.amqp.core.Message request, org.springframework.amqp.core.Message response) {
        String messageId;
        String correlation = request.getMessageProperties().getCorrelationId();
        if (correlation == null && (messageId = request.getMessageProperties().getMessageId()) != null) {
            correlation = messageId;
        }
        response.getMessageProperties().setCorrelationId(correlation);
    }
}

