/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.support;

import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.ContentTypeDelegatingMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.MimeType;

public final class MappingUtils {
    private MappingUtils() {
    }

    public static org.springframework.amqp.core.Message mapMessage(Message<?> requestMessage, MessageConverter converter, AmqpHeaderMapper headerMapper, @Nullable MessageDeliveryMode defaultDeliveryMode, boolean headersMappedLast) {
        return MappingUtils.doMapMessage(requestMessage, converter, headerMapper, defaultDeliveryMode, headersMappedLast, false);
    }

    public static org.springframework.amqp.core.Message mapReplyMessage(Message<?> replyMessage, MessageConverter converter, AmqpHeaderMapper headerMapper, @Nullable MessageDeliveryMode defaultDeliveryMode, boolean headersMappedLast) {
        return MappingUtils.doMapMessage(replyMessage, converter, headerMapper, defaultDeliveryMode, headersMappedLast, true);
    }

    private static org.springframework.amqp.core.Message doMapMessage(Message<?> message, MessageConverter converter, AmqpHeaderMapper headerMapper, @Nullable MessageDeliveryMode defaultDeliveryMode, boolean headersMappedLast, boolean reply) {
        MessageProperties amqpMessageProperties = new MessageProperties();
        org.springframework.amqp.core.Message amqpMessage = MappingUtils.mapMessage(message, converter, headerMapper, headersMappedLast, reply, amqpMessageProperties);
        MappingUtils.checkDeliveryMode(message, amqpMessageProperties, defaultDeliveryMode);
        return amqpMessage;
    }

    public static org.springframework.amqp.core.Message mapMessage(Message<?> message, MessageConverter converter, AmqpHeaderMapper headerMapper, boolean headersMappedLast, boolean reply, MessageProperties amqpMessageProperties) {
        String contentType;
        if (!headersMappedLast) {
            MappingUtils.mapHeaders(message.getHeaders(), amqpMessageProperties, headerMapper, reply);
        }
        if (converter instanceof ContentTypeDelegatingMessageConverter && headersMappedLast && (contentType = MappingUtils.contentTypeAsString(message.getHeaders())) != null) {
            amqpMessageProperties.setContentType(contentType);
        }
        org.springframework.amqp.core.Message amqpMessage = converter.toMessage(message.getPayload(), amqpMessageProperties);
        if (headersMappedLast) {
            MappingUtils.mapHeaders(message.getHeaders(), amqpMessageProperties, headerMapper, reply);
        }
        return amqpMessage;
    }

    private static void mapHeaders(MessageHeaders messageHeaders, MessageProperties amqpMessageProperties, AmqpHeaderMapper headerMapper, boolean reply) {
        if (reply) {
            headerMapper.fromHeadersToReply(messageHeaders, amqpMessageProperties);
        } else {
            headerMapper.fromHeadersToRequest(messageHeaders, amqpMessageProperties);
        }
    }

    private static @Nullable String contentTypeAsString(MessageHeaders headers) {
        Object contentType = headers.get((Object)"contentType");
        if (contentType instanceof MimeType) {
            contentType = contentType.toString();
        }
        if (contentType instanceof String) {
            return (String)contentType;
        }
        if (contentType != null) {
            throw new IllegalArgumentException("contentType header must be a MimeType or String, found: " + contentType.getClass().getName());
        }
        return null;
    }

    public static void checkDeliveryMode(Message<?> requestMessage, MessageProperties messageProperties, @Nullable MessageDeliveryMode defaultDeliveryMode) {
        if (defaultDeliveryMode != null && requestMessage.getHeaders().get((Object)"amqp_deliveryMode") == null) {
            messageProperties.setDeliveryMode(defaultDeliveryMode);
        }
    }
}

