/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.outbound;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.context.Lifecycle;
import org.springframework.integration.amqp.outbound.AbstractAmqpOutboundEndpoint;
import org.springframework.integration.amqp.support.MappingUtils;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class AmqpOutboundEndpoint
extends AbstractAmqpOutboundEndpoint
implements RabbitTemplate.ConfirmCallback,
RabbitTemplate.ReturnCallback {
    private final AmqpTemplate amqpTemplate;
    private volatile boolean expectReply;

    public AmqpOutboundEndpoint(AmqpTemplate amqpTemplate) {
        Assert.notNull((Object)amqpTemplate, (String)"amqpTemplate must not be null");
        this.amqpTemplate = amqpTemplate;
        if (amqpTemplate instanceof RabbitTemplate) {
            this.setConnectionFactory(((RabbitTemplate)amqpTemplate).getConnectionFactory());
        }
    }

    public void setExpectReply(boolean expectReply) {
        this.expectReply = expectReply;
    }

    public String getComponentType() {
        return this.expectReply ? "amqp:outbound-gateway" : "amqp:outbound-channel-adapter";
    }

    @Override
    protected void endpointInit() {
        if (this.getConfirmCorrelationExpression() != null) {
            Assert.isInstanceOf(RabbitTemplate.class, (Object)this.amqpTemplate, (String)"RabbitTemplate implementation is required for publisher confirms");
            ((RabbitTemplate)this.amqpTemplate).setConfirmCallback((RabbitTemplate.ConfirmCallback)this);
        }
        if (this.getReturnChannel() != null) {
            Assert.isInstanceOf(RabbitTemplate.class, (Object)this.amqpTemplate, (String)"RabbitTemplate implementation is required for publisher confirms");
            ((RabbitTemplate)this.amqpTemplate).setReturnCallback((RabbitTemplate.ReturnCallback)this);
        }
    }

    @Override
    protected void doStop() {
        if (this.amqpTemplate instanceof Lifecycle) {
            ((Lifecycle)this.amqpTemplate).stop();
        }
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        CorrelationData correlationData = this.generateCorrelationData(requestMessage);
        String exchangeName = this.generateExchangeName(requestMessage);
        String routingKey = this.generateRoutingKey(requestMessage);
        if (this.expectReply) {
            return this.sendAndReceive(exchangeName, routingKey, requestMessage, correlationData);
        }
        this.send(exchangeName, routingKey, requestMessage, correlationData);
        return null;
    }

    private void send(String exchangeName, String routingKey, Message<?> requestMessage, CorrelationData correlationData) {
        if (this.amqpTemplate instanceof RabbitTemplate) {
            MessageConverter converter = ((RabbitTemplate)this.amqpTemplate).getMessageConverter();
            org.springframework.amqp.core.Message amqpMessage = MappingUtils.mapMessage(requestMessage, converter, this.getHeaderMapper(), this.getDefaultDeliveryMode(), this.isHeadersMappedLast());
            this.addDelayProperty(requestMessage, amqpMessage);
            ((RabbitTemplate)this.amqpTemplate).send(exchangeName, routingKey, amqpMessage, correlationData);
        } else {
            this.amqpTemplate.convertAndSend(exchangeName, routingKey, requestMessage.getPayload(), message -> {
                this.getHeaderMapper().fromHeadersToRequest(requestMessage.getHeaders(), message.getMessageProperties());
                return message;
            });
        }
    }

    private AbstractIntegrationMessageBuilder<?> sendAndReceive(String exchangeName, String routingKey, Message<?> requestMessage, CorrelationData correlationData) {
        Assert.isInstanceOf(RabbitTemplate.class, (Object)this.amqpTemplate, (String)"RabbitTemplate implementation is required for publisher confirms");
        MessageConverter converter = ((RabbitTemplate)this.amqpTemplate).getMessageConverter();
        org.springframework.amqp.core.Message amqpMessage = MappingUtils.mapMessage(requestMessage, converter, this.getHeaderMapper(), this.getDefaultDeliveryMode(), this.isHeadersMappedLast());
        this.addDelayProperty(requestMessage, amqpMessage);
        org.springframework.amqp.core.Message amqpReplyMessage = ((RabbitTemplate)this.amqpTemplate).sendAndReceive(exchangeName, routingKey, amqpMessage, correlationData);
        if (amqpReplyMessage == null) {
            return null;
        }
        return this.buildReply(converter, amqpReplyMessage);
    }

    public void confirm(CorrelationData correlationData, boolean ack, String cause) {
        this.handleConfirm(correlationData, ack, cause);
    }

    public void returnedMessage(org.springframework.amqp.core.Message message, int replyCode, String replyText, String exchange, String routingKey) {
        MessageConverter converter = ((RabbitTemplate)this.amqpTemplate).getMessageConverter();
        Message<?> returned = this.buildReturnedMessage(message, replyCode, replyText, exchange, routingKey, converter);
        this.getReturnChannel().send(returned);
    }
}

