/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.inbound;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.GetResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.support.DefaultMessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SimpleMessageConverter;
import org.springframework.integration.acks.AcknowledgmentCallback;
import org.springframework.integration.acks.AcknowledgmentCallbackFactory;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.util.Assert;

public class AmqpMessageSource
extends AbstractMessageSource<Object> {
    private final String queue;
    private final ConnectionFactory connectionFactory;
    private final AmqpAckCallbackFactory ackCallbackFactory;
    private boolean transacted;
    private MessagePropertiesConverter propertiesConverter = new DefaultMessagePropertiesConverter();
    private AmqpHeaderMapper headerMapper = DefaultAmqpHeaderMapper.inboundMapper();
    private MessageConverter messageConverter = new SimpleMessageConverter();
    private boolean rawMessageHeader;

    public AmqpMessageSource(ConnectionFactory connectionFactory, String queue) {
        this(connectionFactory, new AmqpAckCallbackFactory(), queue);
    }

    public AmqpMessageSource(ConnectionFactory connectionFactory, AmqpAckCallbackFactory ackCallbackFactory, String queue) {
        Assert.notNull((Object)connectionFactory, (String)"'connectionFactory' cannot be null");
        Assert.notNull((Object)ackCallbackFactory, (String)"'ackCallbackFactory' cannot be null");
        Assert.notNull((Object)queue, (String)"'queue' cannot be null");
        this.connectionFactory = connectionFactory;
        this.ackCallbackFactory = ackCallbackFactory;
        this.queue = queue;
    }

    protected boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    protected MessagePropertiesConverter getPropertiesConverter() {
        return this.propertiesConverter;
    }

    public void setPropertiesConverter(MessagePropertiesConverter propertiesConverter) {
        this.propertiesConverter = propertiesConverter;
    }

    protected AmqpHeaderMapper getHeaderMapper() {
        return this.headerMapper;
    }

    public void setHeaderMapper(AmqpHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    protected MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    protected boolean isRawMessageHeader() {
        return this.rawMessageHeader;
    }

    public void setRawMessageHeader(boolean rawMessageHeader) {
        this.rawMessageHeader = rawMessageHeader;
    }

    public String getComponentType() {
        return "amqp:message-source";
    }

    protected AbstractIntegrationMessageBuilder<Object> doReceive() {
        Connection connection = this.connectionFactory.createConnection();
        Channel channel = connection.createChannel(this.transacted);
        try {
            GetResponse resp = channel.basicGet(this.queue, false);
            if (resp == null) {
                RabbitUtils.closeChannel((Channel)channel);
                RabbitUtils.closeConnection((Connection)connection);
                return null;
            }
            AcknowledgmentCallback callback = this.ackCallbackFactory.createCallback(new AmqpAckInfo(connection, channel, this.transacted, resp));
            MessageProperties messageProperties = this.propertiesConverter.toMessageProperties(resp.getProps(), resp.getEnvelope(), StandardCharsets.UTF_8.name());
            messageProperties.setConsumerQueue(this.queue);
            Map headers = this.headerMapper.toHeadersFromRequest(messageProperties);
            Message amqpMessage = new Message(resp.getBody(), messageProperties);
            Object payload = this.messageConverter.fromMessage(amqpMessage);
            AbstractIntegrationMessageBuilder builder = this.getMessageBuilderFactory().withPayload(payload).copyHeaders(headers).setHeader("acknowledgmentCallback", (Object)callback);
            if (this.rawMessageHeader) {
                builder.setHeader("amqp_raw_message", (Object)amqpMessage);
                builder.setHeader("sourceData", (Object)amqpMessage);
            }
            return builder;
        }
        catch (IOException e) {
            RabbitUtils.closeChannel((Channel)channel);
            RabbitUtils.closeConnection((Connection)connection);
            throw RabbitExceptionTranslator.convertRabbitAccessException((Throwable)e);
        }
    }

    public static class AmqpAckInfo {
        private final Connection connection;
        private final Channel channel;
        private final boolean transacted;
        private final GetResponse getResponse;

        public AmqpAckInfo(Connection connection, Channel channel, boolean transacted, GetResponse getResponse) {
            this.connection = connection;
            this.channel = channel;
            this.transacted = transacted;
            this.getResponse = getResponse;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public Channel getChannel() {
            return this.channel;
        }

        public boolean isTransacted() {
            return this.transacted;
        }

        public GetResponse getGetResponse() {
            return this.getResponse;
        }

        public String toString() {
            return "AmqpAckInfo [connection=" + this.connection + ", channel=" + this.channel + ", transacted=" + this.transacted + ", getResponse=" + this.getResponse + "]";
        }
    }

    public static class AmqpAckCallback
    implements AcknowledgmentCallback {
        private static Log logger = LogFactory.getLog(AmqpAckCallback.class);
        private final AmqpAckInfo ackInfo;
        private boolean acknowledged;
        private boolean autoAckEnabled = true;

        public AmqpAckCallback(AmqpAckInfo ackInfo) {
            this.ackInfo = ackInfo;
        }

        protected AmqpAckInfo getAckInfo() {
            return this.ackInfo;
        }

        protected void setAcknowledged(boolean acknowledged) {
            this.acknowledged = acknowledged;
        }

        public boolean isAcknowledged() {
            return this.acknowledged;
        }

        public void noAutoAck() {
            this.autoAckEnabled = false;
        }

        public boolean isAutoAck() {
            return this.autoAckEnabled;
        }

        public void acknowledge(AcknowledgmentCallback.Status status) {
            Assert.notNull((Object)status, (String)"'status' cannot be null");
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("acknowledge(" + status.name() + ") for " + this));
            }
            try {
                long deliveryTag = this.ackInfo.getGetResponse().getEnvelope().getDeliveryTag();
                switch (status) {
                    case ACCEPT: {
                        this.ackInfo.getChannel().basicAck(deliveryTag, false);
                        break;
                    }
                    case REJECT: {
                        this.ackInfo.getChannel().basicReject(deliveryTag, false);
                        break;
                    }
                    case REQUEUE: {
                        this.ackInfo.getChannel().basicReject(deliveryTag, true);
                        break;
                    }
                }
                if (this.ackInfo.isTransacted()) {
                    this.ackInfo.getChannel().txCommit();
                }
            }
            catch (IOException e) {
                throw RabbitExceptionTranslator.convertRabbitAccessException((Throwable)e);
            }
            finally {
                RabbitUtils.closeChannel((Channel)this.ackInfo.getChannel());
                RabbitUtils.closeConnection((Connection)this.ackInfo.getConnection());
                this.acknowledged = true;
            }
        }

        public String toString() {
            return "AmqpAckCallback [ackInfo=" + this.ackInfo + ", acknowledged=" + this.acknowledged + ", autoAckEnabled=" + this.autoAckEnabled + "]";
        }
    }

    public static class AmqpAckCallbackFactory
    implements AcknowledgmentCallbackFactory<AmqpAckInfo> {
        public AcknowledgmentCallback createCallback(AmqpAckInfo info) {
            return new AmqpAckCallback(info);
        }
    }
}

