/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.inbound;

import com.rabbitmq.client.Channel;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.api.ChannelAwareMessageListener;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SimpleMessageConverter;
import org.springframework.core.AttributeAccessor;
import org.springframework.integration.StaticMessageHeaderAccessor;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.AmqpMessageHeaderErrorMessageStrategy;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.amqp.support.EndpointUtils;
import org.springframework.integration.context.OrderlyShutdownCapable;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.support.ErrorMessageUtils;
import org.springframework.messaging.Message;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.support.RetrySynchronizationManager;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class AmqpInboundChannelAdapter
extends MessageProducerSupport
implements OrderlyShutdownCapable {
    private static final ThreadLocal<AttributeAccessor> attributesHolder = new ThreadLocal();
    private final AbstractMessageListenerContainer messageListenerContainer;
    private volatile MessageConverter messageConverter = new SimpleMessageConverter();
    private volatile AmqpHeaderMapper headerMapper = DefaultAmqpHeaderMapper.inboundMapper();
    private RetryTemplate retryTemplate;
    private RecoveryCallback<? extends Object> recoveryCallback;

    public AmqpInboundChannelAdapter(AbstractMessageListenerContainer listenerContainer) {
        Assert.notNull((Object)listenerContainer, (String)"listenerContainer must not be null");
        Assert.isNull((Object)listenerContainer.getMessageListener(), (String)"The listenerContainer provided to an AMQP inbound Channel Adapter must not have a MessageListener configured since the adapter configure its own listener implementation.");
        this.messageListenerContainer = listenerContainer;
        this.messageListenerContainer.setAutoStartup(false);
        this.setErrorMessageStrategy(new AmqpMessageHeaderErrorMessageStrategy());
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"messageConverter must not be null");
        this.messageConverter = messageConverter;
    }

    public void setHeaderMapper(AmqpHeaderMapper headerMapper) {
        Assert.notNull((Object)headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        this.retryTemplate = retryTemplate;
    }

    public void setRecoveryCallback(RecoveryCallback<? extends Object> recoveryCallback) {
        this.recoveryCallback = recoveryCallback;
    }

    public String getComponentType() {
        return "amqp:inbound-channel-adapter";
    }

    protected void onInit() {
        if (this.retryTemplate != null) {
            Assert.state((this.getErrorChannel() == null ? 1 : 0) != 0, (String)"Cannot have an 'errorChannel' property when a 'RetryTemplate' is provided; use an 'ErrorMessageSendingRecoverer' in the 'recoveryCallback' property to send an error message when retries are exhausted");
        }
        Listener messageListener = new Listener();
        this.messageListenerContainer.setMessageListener((MessageListener)messageListener);
        this.messageListenerContainer.afterPropertiesSet();
        super.onInit();
    }

    protected void doStart() {
        this.messageListenerContainer.start();
    }

    protected void doStop() {
        this.messageListenerContainer.stop();
    }

    public int beforeShutdown() {
        this.stop();
        return 0;
    }

    public int afterShutdown() {
        return 0;
    }

    private void setAttributesIfNecessary(org.springframework.amqp.core.Message amqpMessage, Message<?> message) {
        boolean needAttributes;
        boolean needHolder = this.getErrorChannel() != null && this.retryTemplate == null;
        boolean bl = needAttributes = needHolder || this.retryTemplate != null;
        if (needHolder) {
            attributesHolder.set(ErrorMessageUtils.getAttributeAccessor(null, null));
        }
        if (needAttributes) {
            RetryContext attributes;
            Object object = attributes = this.retryTemplate != null ? RetrySynchronizationManager.getContext() : attributesHolder.get();
            if (attributes != null) {
                attributes.setAttribute("inputMessage", message);
                attributes.setAttribute("amqp_raw_message", (Object)amqpMessage);
            }
        }
    }

    protected AttributeAccessor getErrorMessageAttributes(Message<?> message) {
        AttributeAccessor attributes = attributesHolder.get();
        if (attributes == null) {
            return super.getErrorMessageAttributes(message);
        }
        return attributes;
    }

    protected class Listener
    implements ChannelAwareMessageListener {
        protected Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(org.springframework.amqp.core.Message message, Channel channel) throws Exception {
            block9: {
                boolean retryDisabled = AmqpInboundChannelAdapter.this.retryTemplate == null;
                try {
                    if (retryDisabled) {
                        this.createAndSend(message, channel);
                    } else {
                        Message<Object> toSend = this.createMessage(message, channel);
                        AmqpInboundChannelAdapter.this.retryTemplate.execute(context -> {
                            StaticMessageHeaderAccessor.getDeliveryAttempt((Message)toSend).incrementAndGet();
                            AmqpInboundChannelAdapter.this.setAttributesIfNecessary(message, toSend);
                            AmqpInboundChannelAdapter.this.sendMessage(toSend);
                            return null;
                        }, AmqpInboundChannelAdapter.this.recoveryCallback);
                    }
                }
                catch (MessageConversionException e) {
                    if (AmqpInboundChannelAdapter.this.getErrorChannel() != null) {
                        AmqpInboundChannelAdapter.this.setAttributesIfNecessary(message, null);
                        AmqpInboundChannelAdapter.this.getMessagingTemplate().send((Object)AmqpInboundChannelAdapter.this.getErrorChannel(), (Message)AmqpInboundChannelAdapter.this.buildErrorMessage(null, (RuntimeException)EndpointUtils.errorMessagePayload(message, channel, this.isManualAck(), (Exception)((Object)e))));
                        break block9;
                    }
                    throw e;
                }
                finally {
                    if (retryDisabled) {
                        attributesHolder.remove();
                    }
                }
            }
        }

        private void createAndSend(org.springframework.amqp.core.Message message, Channel channel) {
            Message<Object> messagingMessage = this.createMessage(message, channel);
            AmqpInboundChannelAdapter.this.setAttributesIfNecessary(message, messagingMessage);
            AmqpInboundChannelAdapter.this.sendMessage(messagingMessage);
        }

        private Message<Object> createMessage(org.springframework.amqp.core.Message message, Channel channel) {
            Object payload = AmqpInboundChannelAdapter.this.messageConverter.fromMessage(message);
            Map headers = AmqpInboundChannelAdapter.this.headerMapper.toHeadersFromRequest(message.getMessageProperties());
            if (this.isManualAck()) {
                headers.put("amqp_deliveryTag", message.getMessageProperties().getDeliveryTag());
                headers.put("amqp_channel", channel);
            }
            if (AmqpInboundChannelAdapter.this.retryTemplate != null) {
                headers.put("deliveryAttempt", new AtomicInteger());
            }
            Message messagingMessage = AmqpInboundChannelAdapter.this.getMessageBuilderFactory().withPayload(payload).copyHeaders(headers).build();
            return messagingMessage;
        }

        private boolean isManualAck() {
            return AmqpInboundChannelAdapter.this.messageListenerContainer.getAcknowledgeMode() == AcknowledgeMode.MANUAL;
        }
    }
}

