/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.channel;

import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.AnonymousQueue;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.integration.amqp.channel.AbstractSubscribableAmqpChannel;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.dispatcher.AbstractDispatcher;
import org.springframework.integration.dispatcher.BroadcastingDispatcher;

public class PublishSubscribeAmqpChannel
extends AbstractSubscribableAmqpChannel {
    private volatile FanoutExchange exchange;
    private final Queue queue = new AnonymousQueue();
    private volatile Binding binding;

    public PublishSubscribeAmqpChannel(String channelName, AbstractMessageListenerContainer container, AmqpTemplate amqpTemplate) {
        super(channelName, container, amqpTemplate, true);
    }

    public PublishSubscribeAmqpChannel(String channelName, AbstractMessageListenerContainer container, AmqpTemplate amqpTemplate, AmqpHeaderMapper outboundMapper, AmqpHeaderMapper inboundMapper) {
        super(channelName, container, amqpTemplate, true, outboundMapper, inboundMapper);
    }

    public void setExchange(FanoutExchange exchange) {
        this.exchange = exchange;
    }

    @Override
    protected String getExchangeName() {
        return this.exchange != null ? this.exchange.getName() : "";
    }

    @Override
    protected String obtainQueueName(String channelName) {
        if (this.exchange == null) {
            String exchangeName = "si.fanout." + channelName;
            this.exchange = new FanoutExchange(exchangeName);
        }
        this.binding = BindingBuilder.bind((Queue)this.queue).to(this.exchange);
        return this.queue.getName();
    }

    @Override
    protected AbstractDispatcher createDispatcher() {
        BroadcastingDispatcher broadcastingDispatcher = new BroadcastingDispatcher(true);
        broadcastingDispatcher.setBeanFactory(this.getBeanFactory());
        return broadcastingDispatcher;
    }

    @Override
    protected void doDeclares() {
        AmqpAdmin admin = this.getAdmin();
        if (admin != null) {
            if (admin.getQueueProperties(this.queue.getName()) == null) {
                admin.declareQueue(this.queue);
            }
            if (this.exchange != null) {
                admin.declareExchange((Exchange)this.exchange);
            }
            if (this.binding != null) {
                admin.declareBinding(this.binding);
            }
        }
    }
}

